/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiidostatis.defs.controller;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import com.yy.hiidostatis.inner.util.log.L;

public class ActivityLifecycleController {
    private volatile boolean isRegister = false;

    @SuppressLint(value={"NewApi"})
    public void registerActivityLifecycleCallbacks(Context context, final ActivityLifecycleCallback callback) {
        try {
            if (this.isRegister()) {
                L.warnOn(this, "call registerActivityLifecycleCallbacks only once", new Object[0]);
                return;
            }
            if (Build.VERSION.SDK_INT >= 14) {
                Application app = (Application)(context instanceof Application ? context : context.getApplicationContext());
                app.registerActivityLifecycleCallbacks(new Application.ActivityLifecycleCallbacks(){

                    public void onActivityStopped(Activity activity) {
                    }

                    public void onActivityStarted(Activity activity) {
                    }

                    public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
                    }

                    public void onActivityResumed(Activity activity) {
                        callback.onActivityResumed(activity);
                    }

                    public void onActivityPaused(Activity activity) {
                        callback.onActivityPaused(activity);
                    }

                    public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
                    }

                    public void onActivityDestroyed(Activity activity) {
                    }
                });
                this.isRegister = true;
            }
        }
        catch (Throwable e) {
            L.warnOn(this, "registerActivityLifecycleCallbacks Throwable:%s", e);
        }
    }

    public boolean isRegister() {
        return this.isRegister;
    }

    public static interface ActivityLifecycleCallback {
        public void onActivityResumed(Activity var1);

        public void onActivityPaused(Activity var1);
    }
}

