/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiidostatis.defs.controller;

import android.content.Context;
import com.yy.hiidostatis.defs.interf.IStatisAPI;
import com.yy.hiidostatis.inner.util.ArdUtil;
import com.yy.hiidostatis.inner.util.DefaultPreference;
import com.yy.hiidostatis.inner.util.log.L;

public class InstallController {
    private IStatisAPI statisAPI;

    public InstallController(IStatisAPI statisAPI) {
        this.statisAPI = statisAPI;
    }

    public void sendInstallationReportIfNotYet(final Context context) {
        InstUtil.InstInfo ii = InstUtil.getInstInfo(context);
        if (!ii.isReport) {
            this.statisAPI.reportInstall(ii.type, new IStatisAPI.ReportResult(){

                @Override
                public void onReportResult(boolean suc) {
                    L.info(InstallController.class, "report Install %b", suc);
                    if (suc) {
                        InstUtil.save(context);
                    }
                }
            });
        }
    }

    private static class InstUtil {
        private static final String PREF_KEY_VERSION_NO = "PREF_KEY_VERSION_NO";
        private static final String PREF_KEY_VERSION_NAME = "PREF_KEY_VERSION_NAME";
        public static final int TYPE_INSTALL = 1;
        public static final int TYPE_UPDATE = 0;
        private static final int INVALID_VERSIONNO = -1;
        private static final String INVALID_VERSIONNAME = "";
        private static final Object KEY = InstUtil.class;
        private static InstInfo instInfo;

        private InstUtil() {
        }

        private static InstInfo init(Context context) {
            InstInfo instInfo = new InstInfo();
            try {
                int installedVersionNo = DefaultPreference.getPreference().getPrefInt(context, PREF_KEY_VERSION_NO, -1);
                String installedVersionName = DefaultPreference.getPreference().getPrefString(context, PREF_KEY_VERSION_NAME, INVALID_VERSIONNAME);
                int curVersionNo = ArdUtil.getVersionNo(context);
                String curVersionName = ArdUtil.getVersionName(context);
                instInfo.isReport = installedVersionNo != -1 && !installedVersionName.equals(INVALID_VERSIONNAME) && installedVersionNo == curVersionNo && installedVersionName.equals(curVersionName);
                instInfo.type = installedVersionNo == -1 && installedVersionName.equals(INVALID_VERSIONNAME) ? 1 : 0;
            }
            catch (Throwable e) {
                L.error(InstUtil.class, "init exception = %s", e);
            }
            return instInfo;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static InstInfo getInstInfo(Context c) {
            if (instInfo != null) {
                return instInfo;
            }
            Object object = KEY;
            synchronized (object) {
                if (instInfo != null) {
                    return instInfo;
                }
                instInfo = InstUtil.init(c);
            }
            return instInfo;
        }

        public static void save(Context c) {
            InstUtil.getInstInfo((Context)c).isReport = true;
            int curVersionNo = ArdUtil.getVersionNo(c);
            String curVersionName = ArdUtil.getVersionName(c);
            DefaultPreference.getPreference().setPrefInt(c, PREF_KEY_VERSION_NO, curVersionNo);
            DefaultPreference.getPreference().setPrefString(c, PREF_KEY_VERSION_NAME, curVersionName);
        }

        public static class InstInfo {
            public boolean isReport;
            public int type;
        }
    }
}

