/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiidostatis.inner;

import android.content.Context;
import com.yy.hiidostatis.inner.AbstractConfig;
import com.yy.hiidostatis.inner.BaseStatisContent;
import com.yy.hiidostatis.inner.implementation.CommonFiller;
import com.yy.hiidostatis.inner.implementation.ITaskManager;
import com.yy.hiidostatis.inner.implementation.TaskManagerNew;

public class GeneralStatisTool {
    private ITaskManager mTaskManager;
    private AbstractConfig mConfig;
    private Context mContext;

    public GeneralStatisTool(Context context, AbstractConfig config) {
        this.mConfig = config;
        this.mContext = context;
        this.mTaskManager = new TaskManagerNew(this.mContext, this.mConfig);
    }

    public AbstractConfig getConfig() {
        return this.mConfig;
    }

    public ITaskManager getTaskManager() {
        return this.mTaskManager;
    }

    public boolean reportCustom(Context context, String act, BaseStatisContent content, boolean fillCommon, boolean fillConcrete, boolean isCover, Long order) {
        BaseStatisContent newContent = this.fillComm(context, act, content, fillCommon, fillConcrete, isCover);
        return this.mTaskManager.send(context, newContent.getContent(), order);
    }

    public void reportCustomTemporary(Context context, String act, BaseStatisContent content, boolean fillCommon, boolean fillConcrete, boolean isCover) {
        BaseStatisContent newContent = this.fillComm(context, act, content, fillCommon, fillConcrete, isCover);
        this.mTaskManager.sendTemporary(context, newContent.getContent());
    }

    private BaseStatisContent fillComm(Context context, String act, BaseStatisContent content, boolean fillCommon, boolean fillConcrete, boolean isCover) {
        BaseStatisContent newContent = null;
        if (fillCommon || fillConcrete) {
            newContent = new BaseStatisContent();
            if (fillCommon) {
                CommonFiller.fillCommonNew(context, newContent, act, this.mConfig.getSdkVer());
            }
            if (fillConcrete) {
                CommonFiller.fillConcreteInfoNew(context, newContent);
            }
            newContent.putContent(content, isCover);
        } else {
            newContent = content;
        }
        newContent.put("act", act);
        return newContent;
    }
}

