/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiidostatis.api;

import android.content.Context;
import android.os.Build;
import com.yy.hiidostatis.api.StatisContent;
import com.yy.hiidostatis.defs.controller.HttpSendController;
import com.yy.hiidostatis.defs.interf.IMetricsAPI;
import com.yy.hiidostatis.defs.obj.ActionResult;
import com.yy.hiidostatis.defs.obj.Counter;
import com.yy.hiidostatis.defs.obj.MetricsPkg;
import com.yy.hiidostatis.defs.obj.MetricsValue;
import com.yy.hiidostatis.inner.implementation.CommonFiller;
import com.yy.hiidostatis.inner.util.ArdUtil;
import com.yy.hiidostatis.inner.util.Util;
import com.yy.hiidostatis.inner.util.hdid.DeviceProxy;
import com.yy.hiidostatis.inner.util.log.L;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.json.JSONArray;
import org.json.JSONObject;

public class MetricsWorker
implements IMetricsAPI {
    public static final String ACT = "mmetric";
    public int maxCount;
    private HttpSendController httpSendController;
    private MetricsPkg pkg;
    private AtomicInteger count = new AtomicInteger(0);
    private long expire;
    private String appKey;
    private String appVer;
    private Context context;
    private String sdkVer;
    @Deprecated
    private int period;
    @Deprecated
    private int periodCount;
    private String osVer;
    private String mac;

    @Deprecated
    public MetricsWorker(Context context, int maxCount, HttpSendController httpSendController, long expire, String appKey, String appVer, String sdkVer, int period) {
        this.maxCount = maxCount;
        this.httpSendController = httpSendController;
        this.expire = expire;
        this.appKey = appKey;
        this.appVer = appVer;
        this.context = context;
        this.sdkVer = sdkVer;
        this.period = period;
        this.pkg = new MetricsPkg(maxCount);
    }

    public MetricsWorker(Context context, int maxCount, HttpSendController httpSendController, long expire, String appKey, String appVer, String sdkVer) {
        this.maxCount = maxCount;
        this.httpSendController = httpSendController;
        this.expire = expire;
        this.appKey = appKey;
        this.appVer = appVer;
        this.context = context;
        this.sdkVer = sdkVer;
        this.pkg = new MetricsPkg(maxCount);
    }

    @Override
    public void reportReturnCode(int scode, String uri, long timeConsumption, String code) {
        MetricsPkg pkg;
        ActionResult result = new ActionResult(scode, uri, timeConsumption, code);
        this.pkg.addActionResult(result);
        int c = this.count.incrementAndGet();
        if (c > this.maxCount && (pkg = this.cutPiece()) != null) {
            this.sendPkg(pkg);
        }
    }

    @Override
    public void reportSrcData(int scode, String uri, String topic, long val, Map<String, String> extra) {
        MetricsPkg pkg;
        MetricsValue mv = new MetricsValue(scode, uri, topic, val, extra);
        this.pkg.addMetricsValue(mv);
        int c = this.count.incrementAndGet();
        if (c > this.maxCount && (pkg = this.cutPiece()) != null) {
            this.sendPkg(pkg);
        }
    }

    private void sendPkg(MetricsPkg pkg) {
        try {
            List<JSONObject> obj = pkg.toJson();
            for (JSONObject one : obj) {
                String str = this.toContent(one);
                if (str == null) continue;
                this.httpSendController.send(str, this.expire);
            }
        }
        catch (Throwable e) {
            L.error(this, e.getMessage(), new Object[0]);
        }
    }

    private String toContent(JSONObject param) {
        try {
            StatisContent content = new StatisContent();
            String timeStamp = String.valueOf(Util.wallTimeSec());
            content.put("act", ACT);
            content.put("time", timeStamp);
            content.put("key", CommonFiller.calKey(ACT, timeStamp));
            content.put("appkey", this.appKey);
            content.put("ver", this.notNull(this.appVer));
            content.put("sdkver", this.notNull(this.sdkVer));
            content.put("sys", 2);
            content.put("osver", this.notNull(this.osVer == null ? (this.osVer = ArdUtil.getOS()) : this.osVer));
            content.put("model", this.notNull(Build.MODEL));
            content.put("net", ArdUtil.getNetworkTypeNew(this.context));
            content.put("ntm", ArdUtil.getNtm(this.context));
            content.put("hdid", DeviceProxy.getHdid(this.context));
            content.put("imei", CommonFiller.getIMEI(this.context));
            content.put("mac", CommonFiller.getMacAddr(this.context));
            content.put("sjp", ArdUtil.getSjp(this.context));
            long l = System.currentTimeMillis();
            try {
                l = param.getLong("clienttime");
            }
            catch (Throwable e) {
                L.error(this, e.getMessage(), new Object[0]);
            }
            content.put("clienttime", String.valueOf(l / 1000L));
            JSONArray req = null;
            if (param.has("reqdata")) {
                req = param.getJSONArray("reqdata");
            }
            JSONArray counterdata = null;
            if (param.has("counterdata")) {
                counterdata = param.getJSONArray("counterdata");
            }
            JSONArray mv = null;
            if (param.has("flatdata")) {
                mv = param.getJSONArray("flatdata");
            }
            if (req != null) {
                content.put("reqdata", this.notNull(req.toString()));
            }
            if (counterdata != null) {
                content.put("counterdata", this.notNull(counterdata.toString()));
            }
            if (mv != null) {
                content.put("flatdata", this.notNull(mv.toString()));
            }
            return content.toString();
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    private String notNull(String str) {
        return str == null ? "" : str;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MetricsPkg cutPiece() {
        MetricsPkg p = null;
        MetricsWorker metricsWorker = this;
        synchronized (metricsWorker) {
            int c = this.count.get();
            if (c > this.maxCount) {
                p = this.pkg;
                this.pkg = new MetricsPkg(this.maxCount);
                this.count.set(0);
            }
        }
        return p;
    }

    @Override
    public void reportCount(int scode, String uri, String countName, long count) {
        this.reportCount(scode, uri, countName, count, 1);
    }

    @Override
    public void reportCount(int scode, String uri, String countName, long count, int times) {
        MetricsPkg pkg;
        int add;
        Counter c = new Counter(scode, uri, countName);
        c.count(count, times);
        if (this.pkg.addCounter(c) && (add = this.count.incrementAndGet()) > this.maxCount && (pkg = this.cutPiece()) != null) {
            this.sendPkg(pkg);
        }
    }

    @Deprecated
    public void onTimer() {
        ++this.periodCount;
        if (this.periodCount >= this.period) {
            this.periodCount = 0;
            this.sendNow();
        }
    }

    public void sendNow() {
        MetricsPkg p = this.pkg;
        this.pkg = new MetricsPkg(this.maxCount);
        this.count.set(0);
        if (!p.isEmpty()) {
            this.sendPkg(p);
        }
    }
}

