/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiidostatis.inner.util.cipher;

import com.yy.hiidostatis.inner.util.cipher.TextUtils;
import com.yy.hiidostatis.inner.util.log.L;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;

public class RsaCipher {
    private static final String RSA_PADDING = "RSA/ECB/PKCS1Padding";
    private PrivateKey privateKey;
    private int private_m_flen = 16;
    private int private_m_tail = 5;
    private PublicKey publicKey;
    private int public_m_flen = 16;
    private int public_m_tail = 5;
    private final ThreadLocal<Cipher> rsaCipher = new ThreadLocal<Cipher>(){

        @Override
        protected Cipher initialValue() {
            try {
                return Cipher.getInstance(RsaCipher.RSA_PADDING);
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
            catch (NoSuchPaddingException e) {
                throw new RuntimeException(e);
            }
        }
    };

    public void loadPublicKey(InputStream in) throws Exception {
        byte[] keyBytes = RsaCipher.readAllBytes(in);
        try {
            PublicKey publicKey;
            this.publicKey = publicKey = KeyFactory.getInstance("RSA").generatePublic(new X509EncodedKeySpec(keyBytes));
        }
        catch (Throwable e) {
            throw new Exception(e);
        }
    }

    public void loadPublicKey(String base64) throws Exception {
        byte[] keyBytes = TextUtils.decodeBase64(base64);
        ByteArrayInputStream bis = new ByteArrayInputStream(keyBytes);
        this.loadPublicKey(bis);
    }

    public String encryptTlogAesKey(byte[] keyContent) throws Exception {
        if (keyContent == null || keyContent.length == 0) {
            return null;
        }
        byte[] enBytes = this.encrypt(keyContent);
        StringBuilder builder = new StringBuilder(8 + enBytes.length * 2);
        builder.append(TextUtils.length2DecimalChar(keyContent.length));
        builder.append(TextUtils.bytes2hex(enBytes));
        return builder.toString();
    }

    public byte[] decryptTlogAesKey(String hex) throws Exception {
        int validLength = TextUtils.getDecimalCharLength(hex);
        byte[] encryptBytes = TextUtils.hex2Bytes(hex, 8);
        if (encryptBytes == null || encryptBytes.length == 0) {
            return null;
        }
        byte[] decryptBytes = this.decrypt(encryptBytes, validLength);
        if (decryptBytes.length != validLength) {
            throw new Exception(String.format("Head length [ %d ] != decrypt length [ %d ]", validLength, decryptBytes.length));
        }
        return decryptBytes;
    }

    public void loadPrivateKey(InputStream in) throws Exception {
        byte[] keyBytes = RsaCipher.readAllBytes(in);
        try {
            PrivateKey privKey;
            PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(keyBytes);
            KeyFactory kf = KeyFactory.getInstance("RSA");
            this.privateKey = privKey = kf.generatePrivate(keySpec);
        }
        catch (Throwable e) {
            throw new Exception(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadPrivateKey(File file) throws Exception {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            this.loadPrivateKey(fis);
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (Exception e) {
                L.error(this, e.getMessage(), new Object[0]);
            }
        }
    }

    public byte[] encrypt(byte[] content) throws Exception {
        int certif_size = content.length;
        int pad = certif_size % this.public_m_tail;
        int total = pad != 0 ? certif_size + this.public_m_tail - pad : certif_size;
        int buffer_end = content.length;
        if (pad != 0) {
            byte[] newContent = new byte[total];
            System.arraycopy(content, 0, newContent, 0, content.length);
            content = newContent;
        }
        int outlen = total / this.public_m_tail * this.public_m_flen;
        byte[] outByte = new byte[outlen];
        int contentStep = 0;
        int outStep = 0;
        int icount = 0;
        try {
            byte[] tempEncrypt;
            while (contentStep < content.length && (icount = buffer_end - contentStep) >= this.public_m_tail) {
                tempEncrypt = this.encrypt(content, contentStep, this.public_m_tail, this.publicKey);
                System.arraycopy(tempEncrypt, 0, outByte, outStep, tempEncrypt.length);
                contentStep += this.public_m_tail;
                outStep += this.public_m_flen;
            }
            if (icount > 0 && contentStep < content.length) {
                content[contentStep + this.public_m_tail - 1] = (byte)(this.public_m_tail - icount);
                tempEncrypt = this.encrypt(content, contentStep, this.public_m_tail, this.publicKey);
                System.arraycopy(tempEncrypt, 0, outByte, outStep, tempEncrypt.length);
            }
        }
        catch (Throwable e) {
            throw new Exception(e);
        }
        return outByte;
    }

    public byte[] decrypt(byte[] enContent, int validLength) throws Exception {
        int total = enContent.length;
        int outlen = total / this.private_m_flen * this.private_m_tail;
        byte[] outBytes = new byte[outlen];
        int outStep = 0;
        int tempLen = 0;
        try {
            for (int contentStep = 0; contentStep < enContent.length; contentStep += this.private_m_flen) {
                byte[] tempDecrypt = this.decrypt(enContent, contentStep, this.private_m_flen, this.privateKey);
                if (tempDecrypt == null) {
                    throw new Exception("Wrong rsa block ,decrypt result is null.");
                }
                if (tempDecrypt.length != this.private_m_tail) {
                    throw new Exception(String.format("Wrong rsa block, expect tail length [ %d ], get tail length [ %d ]", this.private_m_tail, tempDecrypt.length));
                }
                System.arraycopy(tempDecrypt, 0, outBytes, outStep, tempDecrypt.length);
                if (enContent.length - contentStep > this.private_m_flen) {
                    tempLen += tempDecrypt.length;
                } else if (validLength % this.private_m_tail != 0) {
                    byte tailLen = tempDecrypt[this.private_m_tail - 1];
                    int icount = 0;
                    for (icount = this.private_m_tail - tailLen; icount < this.private_m_tail && tempDecrypt[icount] == 0; ++icount) {
                    }
                    tempLen = icount == this.private_m_tail - 1 ? (tempLen += tempDecrypt.length - tailLen) : (tempLen += tempDecrypt.length);
                } else {
                    tempLen += tempDecrypt.length;
                }
                outStep += this.private_m_tail;
            }
        }
        catch (InvalidKeyException e) {
            throw new Exception(e);
        }
        byte[] ans = new byte[tempLen];
        System.arraycopy(outBytes, 0, ans, 0, tempLen);
        return ans;
    }

    private byte[] decrypt(byte[] input, int inputOffset, int inputLen, Key key) throws IllegalBlockSizeException, BadPaddingException, InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException {
        Cipher cipher = this.rsaCipher.get();
        cipher.init(2, key);
        return cipher.doFinal(input, inputOffset, inputLen);
    }

    private byte[] encrypt(byte[] input, int inputOffset, int inputLen, Key key) throws IllegalBlockSizeException, BadPaddingException, InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException {
        Cipher cipher = this.rsaCipher.get();
        cipher.init(1, key);
        byte[] en = cipher.doFinal(input, inputOffset, inputLen);
        return en;
    }

    private static byte[] readAllBytes(InputStream in) throws IOException {
        ArrayList<Byte> orig = new ArrayList<Byte>(512);
        DataInputStream dis = new DataInputStream(in);
        int b = -1;
        while ((b = dis.read()) != -1) {
            orig.add((byte)b);
        }
        byte[] keyBytes = new byte[orig.size()];
        for (int i = 0; i < keyBytes.length; ++i) {
            keyBytes[i] = (Byte)orig.get(i);
        }
        return keyBytes;
    }
}

