/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiidostatis.track;

import android.content.Context;
import com.yy.hiidostatis.api.HiidoSDK;
import com.yy.hiidostatis.api.StatisContent;
import com.yy.hiidostatis.api.StatisOption;
import com.yy.hiidostatis.defs.StatisAPI;
import com.yy.hiidostatis.inner.GeneralProxy;
import com.yy.hiidostatis.inner.implementation.CommonFiller;
import com.yy.hiidostatis.inner.implementation.TaskManagerNew;
import com.yy.hiidostatis.inner.util.ArdUtil;
import com.yy.hiidostatis.inner.util.ThreadPool;
import com.yy.hiidostatis.inner.util.log.ActLog;
import com.yy.hiidostatis.inner.util.log.L;
import com.yy.hiidostatis.pref.HdStatisConfig;
import org.json.JSONObject;

public enum DataTrack {
    instance;

    private IDataTrackListener mDataTrackListener = null;
    private Context mContext;
    private StatisOption mStatisOption;
    private StatisAPI mStatisAPI;
    private static final int INTERVAL = 600000;
    private volatile boolean mIsTrack = false;
    private volatile boolean mIsEnable = false;
    private volatile long mUid = -1L;
    private long reportTime = 0L;

    public void init(Context context, StatisOption option, IDataTrackListener dataTrackListener) {
        this.mDataTrackListener = dataTrackListener;
        this.mContext = context;
        this.mStatisOption = option;
        String tmp = ArdUtil.getMetaDataParam(context, "HIIDO_DATATRACK_ENABLE");
        L.brief("mIsEnable = %s", tmp);
        this.mIsEnable = Boolean.parseBoolean(tmp);
        L.brief("mIsEnable = %b", this.mIsEnable);
    }

    public void triggerTrack(final boolean isForce) {
        if (!this.mIsEnable) {
            return;
        }
        ThreadPool.getPool().execute(new Runnable(){

            @Override
            public void run() {
                DataTrack.this.trigger(isForce);
            }
        });
    }

    private synchronized void trigger(boolean isForce) {
        long tmpUid = HiidoSDK.instance().getOnStatisListener().getCurrentUid();
        if (this.mUid == -1L || this.mUid != tmpUid) {
            boolean isTrack = false;
            try {
                JSONObject json = this.mDataTrackListener.getConfig(this.mStatisOption.getAppkey(), tmpUid, CommonFiller.getIMEI(this.mContext));
                L.brief("json = %s", json);
                if (json != null) {
                    isTrack = 1 == json.getJSONObject("tzConfig").getInt("open");
                }
            }
            catch (Throwable e) {
                L.warn((Object)this, "parse getConfig json exception = %s", e);
            }
            this.mIsTrack = isTrack;
            this.mUid = tmpUid;
            L.brief("mUid = %d", this.mUid);
            L.brief("mIsTrack = %b", this.mIsTrack);
        }
        if (!this.mIsTrack) {
            ActLog.setActLogListener(null);
            this.mStatisAPI = null;
            return;
        }
        if (this.mStatisAPI == null) {
            ActLog.setActLogListener(new ActLog.ActLogListener(){

                @Override
                public void sendFail(String appkey, String guid, String smk, String act, Integer retry, String host, String errCode, String errMsg) {
                    DataTrack.this.reportFail(appkey, guid, smk, act, retry, host, errCode, errMsg);
                }
            });
            this.mStatisAPI = HiidoSDK.instance().createNewStatisApi();
            StatisOption s = new StatisOption();
            s.setAppkey("TZ-" + this.mStatisOption.getAppkey());
            s.setAppId(this.mStatisOption.getAppId());
            s.setFrom(this.mStatisOption.getFrom());
            s.setVer(this.mStatisOption.getVer());
            this.mStatisAPI.init(this.mContext, s);
        }
        if (isForce) {
            this.reportTotalForce();
        } else {
            this.reportTotalInterval();
        }
    }

    private void reportTotalInterval() {
        if (this.reportTime == 0L || System.currentTimeMillis() - this.reportTime >= 600000L) {
            this.reportTime = System.currentTimeMillis();
            this.reportTotalForce();
        }
    }

    private boolean isReport() {
        return this.mIsEnable && this.mIsTrack;
    }

    private void reportTotalForce() {
        if (!this.isReport()) {
            return;
        }
        ThreadPool.getPool().execute(new Runnable(){

            @Override
            public void run() {
                DataTrack.this.reportTotal();
            }
        });
    }

    private synchronized void reportTotal() {
        try {
            String monitorAppkey = this.mStatisOption.getAppkey();
            int buf = ((TaskManagerNew)GeneralProxy.getGeneralStatisInstance(this.mContext, HdStatisConfig.getConfig(monitorAppkey)).getTaskManager()).cacheSize(this.mContext);
            int[] total = ActLog.getTotal(this.mContext, monitorAppkey);
            this.sendLogTotal(buf, total[0], total[1], total[2], total[3], total[4]);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private synchronized void reportFail(String appkey, String guid, String smk, String act, Integer retry, String host, String errCode, String errMsg) {
        try {
            if (!this.isReport()) {
                return;
            }
            if (!this.mStatisOption.getAppkey().equals(appkey)) {
                return;
            }
            this.sendLogFail(appkey, guid, smk, act, retry, host, errCode, errMsg);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private void sendLogTotal(Integer buf, Integer cur, Integer fait, Integer suc, Integer del, Integer retry) {
        try {
            StatisContent sc = new StatisContent();
            if (buf != null) {
                sc.put("buf", buf);
            }
            sc.put("cur", cur);
            sc.put("fait", fait);
            sc.put("suc", suc);
            sc.put("del", del);
            sc.put("retry", retry);
            sc.put("uid", HiidoSDK.instance().getOnStatisListener().getCurrentUid());
            this.mStatisAPI.reportStatisticContent("zhlogtotal", sc, true, false, false);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private void sendLogFail(String appkey, String guid, String smk, String act, Integer retry, String host, String errCode, String errMsg) {
        try {
            StatisContent sc = new StatisContent();
            sc.put("fguid", guid);
            sc.put("smk", smk);
            sc.put("fact", act);
            sc.put("retry", retry);
            sc.put("host", host);
            sc.put("fcode", errCode);
            sc.put("fmsg", errMsg);
            sc.put("uid", HiidoSDK.instance().getOnStatisListener().getCurrentUid());
            this.mStatisAPI.reportStatisticContent("zhlogfail", sc, true, false, false);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public static interface IDataTrackListener {
        public JSONObject getConfig(String var1, long var2, String var4);
    }
}

