/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiidostatis.inner.util.log;

import android.util.Log;
import com.yy.hiidostatis.inner.util.log.IBaseStatisLogWriter;
import com.yy.hiidostatis.inner.util.log.L;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicLong;

public class BaseDefaultStatisLogWriter
implements IBaseStatisLogWriter {
    private static final int MIN_LOG_SIZE = 262144;
    private static final int MAX_LOG_SIZE = 0x2000000;
    public static final int DEFAULT_LEN = 0x400000;
    private String mFilePath;
    private int mLogMaxLen = 0x400000;
    private final boolean mWriteDebugLog;
    private boolean isFileExist = false;
    private FileWriter fileWriter = null;
    private AtomicLong length = new AtomicLong(0L);

    public BaseDefaultStatisLogWriter(String path, boolean writeDebugLog) {
        this(path, 0x400000, writeDebugLog);
    }

    public BaseDefaultStatisLogWriter(String path, int maxLogSize, boolean writeDebugLog) {
        this.mFilePath = path;
        this.mLogMaxLen = Math.min(maxLogSize, 0x2000000);
        this.mLogMaxLen = Math.max(this.mLogMaxLen, 262144);
        this.mWriteDebugLog = writeDebugLog;
        L.infoOn(this, "mFilePath = %s, mLogMaxLen = %d, mWriteDebugLog = %b", this.mFilePath, this.mLogMaxLen, this.mWriteDebugLog);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileWriter getFileWriter() {
        if (this.fileWriter != null && this.length.get() < (long)this.mLogMaxLen) {
            return this.fileWriter;
        }
        BaseDefaultStatisLogWriter baseDefaultStatisLogWriter = this;
        synchronized (baseDefaultStatisLogWriter) {
            if (this.fileWriter != null && this.length.get() < (long)this.mLogMaxLen) {
                return this.fileWriter;
            }
            if (this.fileWriter != null) {
                try {
                    this.fileWriter.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            try {
                File file = new File(this.mFilePath);
                if (file.length() > (long)this.mLogMaxLen) {
                    File preFile = new File(this.mFilePath + "_pre.txt");
                    preFile.delete();
                    boolean b = file.renameTo(preFile);
                    if (!b && !(b = file.delete())) {
                        return null;
                    }
                    file = new File(this.mFilePath);
                }
                this.length.set(file.length());
                if (!file.getParentFile().exists()) {
                    file.getParentFile().mkdirs();
                }
                if (!file.exists()) {
                    file.createNewFile();
                }
                if (!file.canWrite()) {
                    return null;
                }
                this.fileWriter = new FileWriter(file, true);
                return this.fileWriter;
            }
            catch (IOException e) {
                return null;
            }
        }
    }

    private boolean writeLogOrThrow(String s) {
        if (s == null || s.length() == 0) {
            return true;
        }
        try {
            this.fileWriter = this.getFileWriter();
            if (this.fileWriter != null) {
                this.fileWriter.write(s);
                this.fileWriter.write("\n");
                this.length.addAndGet(s.length() + 1);
                this.fileWriter.flush();
            }
        }
        catch (Throwable e) {
            Log.d((String)BaseDefaultStatisLogWriter.class.toString(), (String)("write exception=" + e));
        }
        return true;
    }

    @Override
    public void write(int type, String message) {
        this.writeLogOrThrow(message);
    }

    @Override
    public boolean outputDebug() {
        return this.mWriteDebugLog;
    }
}

