/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiidostatis.defs.monitor;

import android.content.Context;
import com.yy.hiidostatis.inner.util.ArdUtil;

public enum TrafficMonitor {
    instance;

    private int appUid;
    private long startAls;
    private long startAlr;
    private long startAps;
    private long startApr;
    private long endAls;
    private long endAlr;
    private long endAps;
    private long endApr;

    public void init(Context context) {
        this.appUid = ArdUtil.getCurrAppUid(context);
    }

    public void start() {
        this.startAls = ArdUtil.getTotalTxBytes();
        this.startAlr = ArdUtil.getTotalRxBytes();
        this.startAps = ArdUtil.getUidTxBytes(this.appUid);
        this.startApr = ArdUtil.getUidRxBytes(this.appUid);
        this.endAls = 0L;
        this.endAlr = 0L;
        this.endAps = 0L;
        this.endApr = 0L;
    }

    public void end() {
        this.endAls = ArdUtil.getTotalTxBytes();
        this.endAlr = ArdUtil.getTotalRxBytes();
        this.endAps = ArdUtil.getUidTxBytes(this.appUid);
        this.endApr = ArdUtil.getUidRxBytes(this.appUid);
    }

    public long getAls() {
        return this.endAls - this.startAls < 0L ? 0L : this.endAls - this.startAls;
    }

    public long getAlr() {
        return this.endAlr - this.startAlr < 0L ? 0L : this.endAlr - this.startAlr;
    }

    public long getAps() {
        return this.endAps - this.startAps < 0L ? 0L : this.endAps - this.startAps;
    }

    public long getApr() {
        return this.endApr - this.startApr < 0L ? 0L : this.endApr - this.startApr;
    }
}

