/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiidostatis.defs.controller;

import android.content.Context;
import com.yy.hiidostatis.defs.interf.IConfigAPI;
import com.yy.hiidostatis.defs.interf.IOnLineConfigListener;
import com.yy.hiidostatis.inner.util.Preference;
import com.yy.hiidostatis.inner.util.ThreadPool;
import com.yy.hiidostatis.inner.util.Util;
import com.yy.hiidostatis.inner.util.log.L;
import org.json.JSONException;
import org.json.JSONObject;

public class OnLineConfigController {
    private static Preference preference = new Preference("hd_online_config_pref", true);
    private static final String PREF_KEY_ONLINE_CONFIG_DATA = "PREF_KEY_ONLINE_CONFIG_DATA";
    private boolean isFinishUpdateConfig = false;
    private IOnLineConfigListener onLineConfigListener;
    private IConfigAPI mConfigAPI;

    public OnLineConfigController(IConfigAPI configAPI) {
        this.mConfigAPI = configAPI;
    }

    public void updateOnlineConfigs(final Context context, final String appKey) {
        this.isFinishUpdateConfig = false;
        Runnable r = new Runnable(){

            @Override
            public void run() {
                block16: {
                    block15: {
                        try {
                            String result = OnLineConfigController.this.mConfigAPI.getOnlineConfigs(context, appKey);
                            L.debug(OnLineConfigController.class, "the online config data is %s", result);
                            if (result == null || result.length() <= 0) break block15;
                            preference.setPrefString(context, OnLineConfigController.PREF_KEY_ONLINE_CONFIG_DATA, result);
                        }
                        catch (Throwable e) {
                            try {
                                L.error(OnLineConfigController.class, "updateOnlineConfigs error! %s", e);
                            }
                            catch (Throwable throwable) {
                                OnLineConfigController.this.isFinishUpdateConfig = true;
                                if (OnLineConfigController.this.onLineConfigListener != null) {
                                    JSONObject data = null;
                                    try {
                                        data = OnLineConfigController.this.getOnlineParamsJSON(context);
                                    }
                                    catch (JSONException e2) {
                                        L.error(this, "get getOnlineParamsJSON error! %s", new Object[]{e2});
                                    }
                                    if (data == null) {
                                        data = new JSONObject();
                                    }
                                    L.debug(OnLineConfigController.class, "call onLineConfigListener.onDataReceived(data)", new Object[0]);
                                    OnLineConfigController.this.onLineConfigListener.onDataReceived(data);
                                }
                                throw throwable;
                            }
                            OnLineConfigController.this.isFinishUpdateConfig = true;
                            if (OnLineConfigController.this.onLineConfigListener == null) break block16;
                            JSONObject data = null;
                            try {
                                data = OnLineConfigController.this.getOnlineParamsJSON(context);
                            }
                            catch (JSONException e3) {
                                L.error(this, "get getOnlineParamsJSON error! %s", new Object[]{e3});
                            }
                            if (data == null) {
                                data = new JSONObject();
                            }
                            L.debug(OnLineConfigController.class, "call onLineConfigListener.onDataReceived(data)", new Object[0]);
                            OnLineConfigController.this.onLineConfigListener.onDataReceived(data);
                        }
                    }
                    OnLineConfigController.this.isFinishUpdateConfig = true;
                    if (OnLineConfigController.this.onLineConfigListener != null) {
                        JSONObject data = null;
                        try {
                            data = OnLineConfigController.this.getOnlineParamsJSON(context);
                        }
                        catch (JSONException e) {
                            L.error(this, "get getOnlineParamsJSON error! %s", new Object[]{e});
                        }
                        if (data == null) {
                            data = new JSONObject();
                        }
                        L.debug(OnLineConfigController.class, "call onLineConfigListener.onDataReceived(data)", new Object[0]);
                        OnLineConfigController.this.onLineConfigListener.onDataReceived(data);
                    }
                }
            }
        };
        ThreadPool.getPool().execute(r);
    }

    public boolean isFinishUpdateConfig() {
        return this.isFinishUpdateConfig;
    }

    public void setOnLineConfigListener(IOnLineConfigListener onLineConfigListener) {
        this.onLineConfigListener = onLineConfigListener;
    }

    public String getOnlineConfigParams(Context context, String onlineKey) {
        String value = "";
        try {
            JSONObject onlineJson = this.getOnlineParamsJSON(context);
            if (onlineJson != null && onlineJson.has(onlineKey)) {
                value = onlineJson.getString(onlineKey);
            }
        }
        catch (Throwable e) {
            L.error(OnLineConfigController.class, "getOnlineConfigParams error! %s", e);
        }
        return value;
    }

    private JSONObject getOnlineParamsJSON(Context context) throws JSONException {
        JSONObject json;
        String configData = preference.getPrefString(context, PREF_KEY_ONLINE_CONFIG_DATA, "");
        if (!Util.empty(configData) && (json = new JSONObject(configData)) != null) {
            Object obj = json.get("onlineParams");
            JSONObject onlineParamsJson = null;
            if (obj instanceof JSONObject) {
                onlineParamsJson = json.getJSONObject("onlineParams");
            }
            return onlineParamsJson;
        }
        return null;
    }
}

