/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiidostatis.defs.controller;

import com.yy.hiidostatis.defs.obj.SendCell;
import com.yy.hiidostatis.inner.util.ThreadPool;
import com.yy.hiidostatis.inner.util.Util;
import com.yy.hiidostatis.inner.util.http.IStatisHttpUtil;
import com.yy.hiidostatis.inner.util.log.L;
import java.io.File;
import java.util.Map;
import java.util.TreeMap;

public class HttpSendController {
    private File cacheDir;
    private IStatisHttpUtil httpUtil;
    private TreeMap<Long, SendCell> waitForSend = new TreeMap();
    private int waitQueueCapacity = 20;
    private int delayStep = 2;

    public HttpSendController(IStatisHttpUtil httpUtil, File cacheDir, int waitQueueCapacity, int delayStep) {
        this.httpUtil = httpUtil;
        this.cacheDir = cacheDir;
        this.waitQueueCapacity = waitQueueCapacity;
        this.delayStep = delayStep;
        this.loadSendCellFromFile();
    }

    public void send(String content, long expire) {
        SendCell cell = new SendCell(content, expire);
        this.putTask(cell);
        this.sendHttp(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putTask(SendCell cell) {
        TreeMap<Long, SendCell> treeMap = this.waitForSend;
        synchronized (treeMap) {
            Map.Entry<Long, SendCell> first;
            this.waitForSend.put(cell.getId(), cell);
            if (this.waitForSend.size() > this.waitQueueCapacity && (first = this.waitForSend.pollFirstEntry()) != null && first.getValue() != null) {
                this.save(first.getValue());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SendCell pollTask() {
        TreeMap<Long, SendCell> treeMap = this.waitForSend;
        synchronized (treeMap) {
            Map.Entry<Long, SendCell> last = this.waitForSend.pollLastEntry();
            if (last != null) {
                return last.getValue();
            }
            return null;
        }
    }

    private void save(final SendCell cell) {
        ThreadPool.getPool().execute(new Runnable(){

            @Override
            public void run() {
                cell.saveToFile(HttpSendController.this.cacheDir);
            }
        });
    }

    private void loadSendCellFromFile() {
        ThreadPool.getPool().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    File[] files = HttpSendController.this.cacheDir.listFiles();
                    long cur = System.currentTimeMillis();
                    int count = HttpSendController.this.waitForSend.size();
                    for (File f : files) {
                        if (count >= HttpSendController.this.waitQueueCapacity) {
                            return;
                        }
                        try {
                            long id2 = SendCell.parseId(f.getName());
                            if (id2 <= 0L) continue;
                            if (id2 / 10000L <= cur) {
                                f.delete();
                                continue;
                            }
                            SendCell cell = SendCell.loadFromFile(f);
                            HttpSendController.this.putTask(cell);
                            ++count;
                        }
                        catch (Throwable e) {
                            L.error(this, e.getMessage(), new Object[0]);
                        }
                    }
                    if (count > 0) {
                        HttpSendController.this.sendHttp(0L);
                    }
                }
                catch (Throwable e) {
                    L.error(this, e.getMessage(), new Object[0]);
                }
            }
        });
    }

    private void sendHttp(long delay) {
        ThreadPool.getPool().execute(new Runnable(){

            @Override
            public void run() {
                SendCell cell = HttpSendController.this.pollTask();
                if (cell == null) {
                    HttpSendController.this.loadSendCellFromFile();
                    return;
                }
                try {
                    String content = cell.getContent();
                    content = String.format("%s&hd_stime=%d", content, Util.wallTimeMillis());
                    HttpSendController.this.httpUtil.setLastTryTimes(cell.getRetry());
                    boolean suc = HttpSendController.this.httpUtil.sendSync(content);
                    int tryTimes = HttpSendController.this.httpUtil.getLastTryTimes();
                    L.debug(this, "Return value: %B to send command %s. ", suc, content);
                    if (!suc) {
                        if (HttpSendController.this.httpUtil.getLastStatusCode() == 414 || HttpSendController.this.httpUtil.getLastStatusCode() == 400) {
                            cell.deleteFile(HttpSendController.this.cacheDir);
                            L.warn(this, "httpUtil.getLastStatusCode()=%d,removeInvalid:%s", HttpSendController.this.httpUtil.getLastStatusCode(), cell.getContent());
                            HttpSendController.this.sendHttp(0L);
                        } else {
                            L.debug(this, "data:%s ; all tryTimes:%d ; createTime:%d", cell.getId(), tryTimes, cell.getTimestamp());
                            cell.retryIncrease();
                            HttpSendController.this.save(cell);
                            HttpSendController.this.putTask(cell);
                            HttpSendController.this.sendHttp(cell.getRetry() * HttpSendController.this.delayStep);
                        }
                    } else {
                        cell.deleteFile(HttpSendController.this.cacheDir);
                        HttpSendController.this.sendHttp(0L);
                    }
                }
                catch (Throwable e) {
                    L.error(this, e.getMessage(), new Object[0]);
                }
            }
        }, delay * 1000L);
    }
}

