/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiidostatis.inner.util.hdid;

import android.content.ContentResolver;
import android.content.Context;
import android.os.Environment;
import android.provider.Settings;
import com.yy.hiidostatis.inner.util.ArdUtil;
import com.yy.hiidostatis.inner.util.FileUtil;
import com.yy.hiidostatis.inner.util.cipher.Coder;
import com.yy.hiidostatis.inner.util.log.L;
import java.io.File;
import java.io.FileFilter;
import java.util.UUID;

public class UuidManager {
    private static Object LOCK_KEY = FileFilter.class;
    private static String MAGIC_KEY = "!QAZXSW@#E";
    private static String SETTING_KEY = "HdSdkBBAUuid";
    private static String mSdCardPath;
    private static String mDataPath;
    private static String mUuid;
    private static String fileName;

    private static String getSdCardPath() {
        if (mSdCardPath == null) {
            mSdCardPath = String.format("%s%s%s%s%s", Environment.getExternalStorageDirectory().getAbsolutePath(), File.separator, ".android", File.separator, fileName);
        }
        L.verbose(UuidManager.class, "sdcard uuid path:%s", mDataPath);
        return mSdCardPath;
    }

    private static String getDataPath(Context context) {
        if (mDataPath == null) {
            mDataPath = String.format("%s%s%s", context.getFilesDir().getAbsolutePath(), File.separator, fileName);
        }
        L.verbose(UuidManager.class, "data uuid path:%s", mDataPath);
        return mDataPath;
    }

    private static String readUUid(String path) {
        try {
            return Coder.decryptDES(FileUtil.readFile(path), MAGIC_KEY);
        }
        catch (Throwable e) {
            e.printStackTrace();
            L.warn(UuidManager.class, "readUUid throwable %s", e);
            return null;
        }
    }

    private static void saveUUid(String path, String uuid) {
        try {
            FileUtil.saveFile(path, Coder.encryptDES(uuid, MAGIC_KEY));
        }
        catch (Throwable e) {
            L.warn(UuidManager.class, "saveUUid throwable %s", e);
        }
    }

    private static String getSetting(Context c) {
        try {
            String uuid = Settings.System.getString((ContentResolver)c.getApplicationContext().getContentResolver(), (String)SETTING_KEY);
            if (uuid != null) {
                return Coder.decryptDES(uuid, MAGIC_KEY);
            }
        }
        catch (Throwable e) {
            L.warn(UuidManager.class, "getSetting throwable %s", e);
        }
        return null;
    }

    private static void saveSetting(Context c, String uuid) {
        if (ArdUtil.checkPermissions(c, "android.permission.WRITE_SETTINGS")) {
            try {
                Settings.System.putString((ContentResolver)c.getApplicationContext().getContentResolver(), (String)SETTING_KEY, (String)Coder.encryptDES(uuid, MAGIC_KEY));
            }
            catch (Throwable e) {
                L.warn(UuidManager.class, "saveSetting throwable %s", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String fetchUUid(Context context) {
        if (mUuid != null) {
            return mUuid;
        }
        Object object = LOCK_KEY;
        synchronized (object) {
            if (mUuid != null) {
                return mUuid;
            }
            String dataUuid = UuidManager.readUUid(UuidManager.getDataPath(context));
            String sdCardUuid = UuidManager.readUUid(UuidManager.getSdCardPath());
            String settingUuid = UuidManager.getSetting(context);
            if (dataUuid != null) {
                L.debug(UuidManager.class, "uuid from data", new Object[0]);
                mUuid = dataUuid;
                if (sdCardUuid == null) {
                    UuidManager.saveUUid(UuidManager.getSdCardPath(), mUuid);
                }
                if (settingUuid == null) {
                    UuidManager.saveSetting(context, mUuid);
                }
                return mUuid;
            }
            if (sdCardUuid != null) {
                L.debug(UuidManager.class, "uuid from sdcard", new Object[0]);
                mUuid = sdCardUuid;
                UuidManager.saveUUid(UuidManager.getDataPath(context), mUuid);
                if (settingUuid == null) {
                    UuidManager.saveSetting(context, mUuid);
                }
                return mUuid;
            }
            if (settingUuid != null) {
                L.debug(UuidManager.class, "uuid from setting", new Object[0]);
                mUuid = settingUuid;
                UuidManager.saveUUid(UuidManager.getSdCardPath(), mUuid);
                UuidManager.saveUUid(UuidManager.getDataPath(context), mUuid);
                return mUuid;
            }
            L.debug(UuidManager.class, "uuid createNew", new Object[0]);
            mUuid = UUID.randomUUID().toString().replace("-", "");
            UuidManager.saveUUid(UuidManager.getDataPath(context), mUuid);
            UuidManager.saveUUid(UuidManager.getSdCardPath(), mUuid);
            UuidManager.saveSetting(context, mUuid);
            return mUuid;
        }
    }

    static {
        mUuid = null;
        fileName = "hduuid_v1";
    }
}

