/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiidostatis.inner.util.cipher;

import com.yy.hiidostatis.inner.util.cipher.Base64Util;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class TextUtils {
    private static final char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final ThreadLocal<MessageDigest> MD5_DIGEST = new ThreadLocal<MessageDigest>(){

        @Override
        protected MessageDigest initialValue() {
            try {
                return MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
        }
    };

    public static String encodeBase64(byte[] bs) {
        return Base64Util.encode(bs);
    }

    public static byte[] decodeBase64(String str) throws IOException {
        return Base64Util.decode(str);
    }

    public static String removeLN(String base64) {
        return base64.replace("\n", "");
    }

    public static String bytes2hex(byte[] data) {
        char[] str = new char[data.length * 2];
        int k = 0;
        for (int i = 0; i < data.length; ++i) {
            byte byte0 = data[i];
            str[k++] = hexDigits[byte0 >>> 4 & 0xF];
            str[k++] = hexDigits[byte0 & 0xF];
        }
        return new String(str);
    }

    public static byte[] hex2bytes(String hex) {
        return TextUtils.hex2Bytes(hex, 0);
    }

    public static byte[] hex2Bytes(String hex, int offset) {
        if (hex.length() % 2 != 0) {
            throw new IllegalArgumentException("Wrong hex size : " + hex.length());
        }
        if (hex.length() <= offset) {
            throw new IllegalArgumentException("Wrong hex size : " + hex.length() + " , expect larger than " + offset);
        }
        int strLen = hex.length() - offset;
        byte[] d = new byte[strLen / 2];
        int di = 0;
        for (int i = offset; i < hex.length(); i += 2) {
            byte v;
            char mi = hex.charAt(i);
            char ni = hex.charAt(i + 1);
            int m = mi < 'a' ? mi - 48 : mi + 10 - 97;
            int n = ni < 'a' ? ni - 48 : ni + 10 - 97;
            d[di] = v = (byte)(m << 4 | n);
            ++di;
        }
        return d;
    }

    public static String wrapDecimalLength(String hex, int validBytesLength) {
        String lenStr = TextUtils.format8length(validBytesLength);
        return String.format("%s%s", lenStr, hex);
    }

    public static String length2DecimalChar(int length) {
        String lenStr = TextUtils.format8length(length);
        return lenStr;
    }

    private static String format8length(int len) {
        StringBuffer sb = new StringBuffer(8);
        int r = 8 - (len + "").length();
        while (r-- > 0) {
            sb.append(0);
        }
        sb.append(len);
        return sb.toString();
    }

    public static int getDecimalCharLength(String input) {
        if (input.length() < 8) {
            throw new IllegalArgumentException("Wrong hex size : " + input.length() + ", at least 8 bytes");
        }
        int effective = 0;
        for (int i = 0; i < 8; ++i) {
            effective = effective * 10 + input.charAt(i) - 48;
        }
        return effective;
    }

    public static byte[] md5byte(byte[] source) {
        MessageDigest md = MD5_DIGEST.get();
        md.reset();
        md.update(source);
        byte[] tmp = md.digest();
        return tmp;
    }
}

