/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiidostatis.inner.util;

import com.yy.hiidostatis.inner.util.SharedTimerTask;
import com.yy.hiidostatis.inner.util.ThreadPool;
import com.yy.hiidostatis.inner.util.log.L;
import java.util.Date;

public class SharedThreadTimer {
    private boolean canceled = false;

    public void schedule(SharedTimerTask task, long delay) {
        if (delay < 0L) {
            throw new IllegalArgumentException("Negative delay.");
        }
        this.sched(task, delay, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sched(SharedTimerTask task, long delay, long period) {
        InnerRun ir = new InnerRun(task, period);
        Object object = task.lock;
        synchronized (object) {
            task.nextExecutionTime = System.currentTimeMillis() + delay;
            task.period = period;
        }
        ThreadPool.getPool().execute(ir, delay);
    }

    public void schedule(SharedTimerTask task, Date time) {
        long delay = time.getTime() - System.currentTimeMillis();
        if (delay < 0L) {
            delay = 0L;
        }
        this.sched(task, delay, 0L);
    }

    public void schedule(SharedTimerTask task, long delay, long period) {
        if (delay < 0L) {
            throw new IllegalArgumentException("Negative delay.");
        }
        if (period <= 0L) {
            throw new IllegalArgumentException("Non-positive period.");
        }
        this.sched(task, delay, period);
    }

    public void schedule(SharedTimerTask task, Date firstTime, long period) {
        if (period <= 0L) {
            throw new IllegalArgumentException("Non-positive period.");
        }
        long delay = firstTime.getTime() - System.currentTimeMillis();
        if (delay < 0L) {
            delay = 0L;
        }
        this.sched(task, delay, period);
    }

    public void cancel() {
        this.canceled = true;
    }

    class InnerRun
    implements Runnable {
        private SharedTimerTask task;
        private long period;

        public InnerRun(SharedTimerTask task, long period) {
            this.task = task;
            this.period = period;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (SharedThreadTimer.this.canceled) {
                return;
            }
            try {
                Object object = this.task.lock;
                synchronized (object) {
                    if (this.task.state == 3) {
                        return;
                    }
                    this.task.nextExecutionTime = System.currentTimeMillis() + this.period;
                    this.task.run();
                    this.task.nextExecutionTime = System.currentTimeMillis() + this.period;
                }
            }
            catch (Throwable e) {
                L.error(this, e.getMessage(), new Object[0]);
            }
            if (this.period > 0L) {
                ThreadPool.getPool().execute(this, this.period);
            }
        }
    }
}

