/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiidostatis.inner.implementation;

import com.yy.hiidostatis.inner.implementation.ITaskExecutor;
import com.yy.hiidostatis.inner.util.log.L;
import java.util.concurrent.RejectedExecutionException;

public abstract class AbstractTaskExecutor
implements ITaskExecutor {
    protected abstract void submitTask(Runnable var1);

    protected abstract void submitTask(Runnable var1, int var2);

    public abstract ITaskExecutor.OnTaskRejectedListener getOnTaskRejectedListener();

    @Override
    public void submit(Runnable runnable) {
        Task safeTask = new Task(runnable);
        this.submitTask(safeTask);
    }

    @Override
    public void submit(ITaskExecutor.ExecutorTask task) {
        Task safeTask = new Task(task);
        this.submitTask(safeTask);
    }

    @Override
    public void submit(Runnable runnable, int delay) {
        Task safeTask = new Task(runnable);
        this.submitTask(safeTask, delay);
    }

    @Override
    public void submit(ITaskExecutor.ExecutorTask task, int delay) {
        Task safeTask = new Task(task);
        this.submitTask(safeTask, delay);
    }

    public boolean isTerminated() {
        return false;
    }

    private class Task
    implements Runnable {
        private Runnable mRunnable;

        public Task(Runnable runnable) {
            this.mRunnable = runnable;
        }

        @Override
        public void run() {
            Runnable runnable = this.mRunnable;
            if (runnable == null) {
                return;
            }
            L.brief("Begin run task %s", runnable);
            try {
                runnable.run();
            }
            catch (RejectedExecutionException e) {
                if (runnable instanceof ITaskExecutor.ExecutorTask) {
                    AbstractTaskExecutor.this.getOnTaskRejectedListener().onRejectedTask((ITaskExecutor.ExecutorTask)runnable);
                }
            }
            catch (Throwable e) {
                L.error(this, "Exception when run task %s", e);
            }
            L.brief("End run task.", new Object[0]);
        }
    }
}

