/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiidostatis.defs.obj;

import com.yy.hiidostatis.defs.obj.PropertyPair;
import com.yy.hiidostatis.inner.util.Util;
import com.yy.hiidostatis.inner.util.log.L;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.LinkedHashMap;

public class Property
implements Serializable {
    private static final long serialVersionUID = -6839046473425691433L;
    private static final int MAX_SIZE = 30;
    private static final int MAX_EVENT_FIELD_BYTES = 256;
    private static final String DIVIDE_PROPERTY = ",";
    private LinkedHashMap<String, PropertyPair> mParams = new LinkedHashMap(30);

    public synchronized Property copy() {
        Property p = new Property();
        if (this.mParams != null) {
            p.mParams.putAll(this.mParams);
        }
        return p;
    }

    public synchronized void putString(String key, String value) {
        if (this.isOverSize()) {
            L.warn(this, "Property max size is %d,now is %d,so get up this inParam:key=[%s],value=[%s]", 30, this.size(), key + "", value + "");
            return;
        }
        if (Util.empty(key)) {
            L.error(this, "key is not allow null.", new Object[0]);
            return;
        }
        if (key.getBytes().length > 256) {
            L.warn(this, "key[%s] bytes[%d] must under %d bytes", key, key.getBytes().length, 256);
            return;
        }
        if (!Util.empty(value) && value.length() > 256) {
            int oldLen = value.length();
            value = value.substring(0, 256);
            L.warn(this, "value length is %d, max length is %d,substring(0,%d)=%s", oldLen, 256, 256, value);
        }
        this.mParams.put(key, new PropertyPair(key, value));
    }

    public synchronized void putDouble(String key, double value) {
        if (this.isOverSize()) {
            L.warn(this, "Property max size is %d,now is %d,so get up this inParam:key=[%s],value=[%s]", 30, this.size(), key + "", value + "");
            return;
        }
        if (Util.empty(key)) {
            L.error(this, "key is not allow null.", new Object[0]);
            return;
        }
        if (key.getBytes().length > 256) {
            L.warn(this, "key[%s] bytes[%d] must under %d bytes", key, key.getBytes().length, 256);
            return;
        }
        this.mParams.put(key, new PropertyPair(key, value));
    }

    public synchronized boolean containsKey(String key) {
        return this.mParams.containsKey(key);
    }

    public synchronized boolean removeProperty(String key) {
        return this.mParams.remove(key) != null;
    }

    public synchronized String getConnectedPropertys() {
        LinkedHashMap<String, PropertyPair> params = this.mParams;
        if (params == null || params.size() == 0) {
            return null;
        }
        if (params.size() == 1) {
            return Util.replaceEncode(params.values().iterator().next().getConnectedPair(), DIVIDE_PROPERTY);
        }
        StringBuilder sb = new StringBuilder();
        for (PropertyPair e : params.values()) {
            sb.append(Util.replaceEncode(e.getConnectedPair(), DIVIDE_PROPERTY));
            sb.append(DIVIDE_PROPERTY);
        }
        sb.replace(sb.length() - 1, sb.length(), "");
        return sb.toString();
    }

    public synchronized void clear() {
        this.mParams.clear();
    }

    public synchronized int size() {
        return this.mParams.size();
    }

    private boolean isOverSize() {
        return this.mParams.size() >= 30;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.writeObject(this.mParams);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        this.mParams = (LinkedHashMap)s.readObject();
        if (this.mParams == null) {
            this.mParams = new LinkedHashMap();
        }
    }
}

