/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiidostatis.defs.controller;

import android.content.Context;
import com.yy.hiidostatis.api.OnStatisListener;
import com.yy.hiidostatis.defs.interf.IStatisAPI;
import com.yy.hiidostatis.inner.util.Util;
import java.util.concurrent.ConcurrentLinkedQueue;

public class PageStateController {
    private volatile long periodTime;
    private volatile IStatisAPI statisAPI;
    private volatile Context context;
    private volatile OnStatisListener listener;
    private volatile ConcurrentLinkedQueue<PageBean> pages = new ConcurrentLinkedQueue();
    private volatile StringBuffer record = new StringBuffer(512);

    public PageStateController(IStatisAPI statisAPI, Context context, OnStatisListener listener) {
        this.statisAPI = statisAPI;
        this.context = context;
        this.listener = listener;
    }

    public void onStart(String page) {
        if (page == null || page.isEmpty()) {
            return;
        }
        this.pages.add(new PageBean(page, System.currentTimeMillis()));
        if (this.periodTime == 0L) {
            this.periodTime = System.currentTimeMillis();
        }
    }

    public boolean onStop(String page) {
        int index = 0;
        for (PageBean p : this.pages) {
            if (p.getPage().equals(page)) {
                this.pages.remove(p);
                this.record.append(String.format("%s:%d:%d|", Util.replaceEncode(p.getPage(), ":"), p.getStime(), System.currentTimeMillis() - p.getStime()));
                break;
            }
            ++index;
        }
        if (this.pages.isEmpty() || this.record.length() > 3000) {
            this.sendToServer(this.pages.isEmpty());
        }
        return this.pages.isEmpty();
    }

    private void sendToServer(boolean isBg) {
        String sub = this.record.toString();
        this.record.setLength(0);
        long dur = System.currentTimeMillis() - this.periodTime;
        long l = this.periodTime = isBg ? 0L : System.currentTimeMillis();
        if (sub.length() == 0) {
            return;
        }
        String msg = sub.substring(0, sub.length() - 1);
        long uid = 0L;
        if (this.listener != null) {
            uid = this.listener.getCurrentUid();
        }
        this.statisAPI.reportPageState(uid, msg, dur);
    }

    private static class PageBean {
        private String page;
        private long stime;

        public PageBean(String page, long stime) {
            this.page = page;
            this.stime = stime;
        }

        public String getPage() {
            return this.page;
        }

        public void setPage(String page) {
            this.page = page;
        }

        public long getStime() {
            return this.stime;
        }

        public void setStime(long stime) {
            this.stime = stime;
        }
    }
}

