/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiidostatis.defs.controller;

import android.content.Context;
import android.os.Build;
import android.util.Log;
import com.bun.miitmdid.core.IIdentifierListener;
import com.bun.miitmdid.core.JLibrary;
import com.bun.miitmdid.core.MdidSdkHelper;
import com.bun.miitmdid.supplier.IdSupplier;
import com.yy.hiidostatis.inner.util.ThreadPool;
import com.yy.hiidostatis.inner.util.log.L;

public enum OaidController {
    INSTANCE;

    private OaidHelper oaidHelper = new OaidHelper();

    public static void loadLib(Context context) {
        try {
            if (OaidController.ignore(context)) {
                return;
            }
            JLibrary.InitEntry((Context)context);
        }
        catch (Throwable e) {
            Log.e((String)"OaidController", (String)"JLibrary.InitEntry(context)", (Throwable)e);
        }
    }

    public static boolean ignore(Context context) {
        return Build.VERSION.SDK_INT < 28;
    }

    public void initOaidAsyn(Context ctx, OaidInitListener listener) {
        this.oaidHelper.initOaid(ctx, listener);
    }

    public boolean isLoaded() {
        return this.oaidHelper.isInit();
    }

    public String oaid() {
        return this.oaidHelper.getOaid();
    }

    public static interface OaidInitListener {
        public void initFinish(boolean var1, String var2, String var3);
    }

    private final class OaidHelper {
        private static final long TIME_OUT = 20000L;
        private volatile boolean init;
        private volatile String oaid = "";
        private volatile int beginTime;

        private OaidHelper() {
        }

        private synchronized void initFinish(boolean success, String oaid, String error, OaidInitListener listener) {
            try {
                if (this.init) {
                    if (success && (this.oaid == null || this.oaid.isEmpty()) && oaid != null && !oaid.isEmpty()) {
                        this.oaid = oaid;
                    }
                    return;
                }
                if (error != null && !error.isEmpty()) {
                    Log.e((String)"OAID", (String)error);
                }
                this.init = true;
                this.oaid = oaid;
                if (listener != null) {
                    listener.initFinish(success, oaid, error);
                }
            }
            catch (Throwable e) {
                L.error(this, e.getMessage(), new Object[0]);
            }
        }

        public void initOaid(Context cxt, OaidInitListener listener) {
            try {
                if (OaidController.ignore(cxt)) {
                    this.init = true;
                    return;
                }
                this.beginTime = (int)(System.currentTimeMillis() / 1000L);
                this.timeOut(listener);
                int nres = this.callFromReflect(cxt, listener);
                if (nres == 1008612) {
                    throw new Exception("\u4e0d\u652f\u6301\u7684\u8bbe\u5907");
                }
                if (nres == 1008613) {
                    throw new Exception("\u52a0\u8f7d\u914d\u7f6e\u6587\u4ef6\u51fa\u9519");
                }
                if (nres == 1008611) {
                    throw new Exception("\u4e0d\u652f\u6301\u7684\u8bbe\u5907\u5382\u5546");
                }
                if (nres != 1008614 && nres == 1008615) {
                    throw new Exception("\u53cd\u5c04\u8c03\u7528\u51fa\u9519");
                }
            }
            catch (Throwable e) {
                this.initFinish(false, "", e.getMessage(), listener);
            }
        }

        private void timeOut(final OaidInitListener listener) {
            ThreadPool.getPool().execute(new Runnable(){

                @Override
                public void run() {
                    int ct = (int)(System.currentTimeMillis() / 1000L);
                    if ((long)(ct - OaidHelper.this.beginTime) < 20L && ct - OaidHelper.this.beginTime > 0) {
                        Log.e((String)"OAID", (String)("\u5b9a\u65f6\u5668\u65f6\u95f4\u9519\u8bef:" + OaidHelper.this.beginTime + "-" + ct + "-" + (ct - OaidHelper.this.beginTime)));
                        OaidHelper.this.timeOut(listener);
                        return;
                    }
                    if (OaidHelper.this.init) {
                        return;
                    }
                    OaidHelper.this.initFinish(false, "", "\u83b7\u53d6OAID\u8d85\u65f6", listener);
                }
            }, 20000L);
        }

        public boolean isInit() {
            return this.init;
        }

        public String getOaid() {
            return this.oaid == null ? "" : this.oaid;
        }

        private int callFromReflect(Context cxt, final OaidInitListener listener) {
            return MdidSdkHelper.InitSdk((Context)cxt, (boolean)true, (IIdentifierListener)new IIdentifierListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void OnSupport(boolean b, IdSupplier idSupplier) {
                    try {
                        if (idSupplier == null) {
                            OaidHelper.this.initFinish(false, "", "\u83b7\u53d6OAID\u5931\u8d25", listener);
                            return;
                        }
                        String oaid = idSupplier.getOAID();
                        OaidHelper.this.initFinish(true, oaid, null, listener);
                    }
                    catch (Throwable e) {
                        L.error(this, e.getMessage(), new Object[0]);
                    }
                    finally {
                        if (idSupplier != null) {
                            try {
                                idSupplier.shutDown();
                            }
                            catch (Throwable e) {
                                L.error(this, e.getMessage(), new Object[0]);
                            }
                        }
                    }
                }
            });
        }
    }
}

