/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiidostatis.api;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.view.MotionEvent;
import android.widget.Toast;
import com.yy.hiido.autoviewtrack.AutoTrack;
import com.yy.hiidostatis.api.ExecutorProvider;
import com.yy.hiidostatis.api.MetricsWorker;
import com.yy.hiidostatis.api.OnLineConfigListener;
import com.yy.hiidostatis.api.OnStatisListener;
import com.yy.hiidostatis.api.ReportFailedCallback;
import com.yy.hiidostatis.api.StatisContent;
import com.yy.hiidostatis.api.StatisLogWriter;
import com.yy.hiidostatis.api.StatisOption;
import com.yy.hiidostatis.defs.ConfigAPI;
import com.yy.hiidostatis.defs.StatisAPI;
import com.yy.hiidostatis.defs.controller.ActivityLifecycleController;
import com.yy.hiidostatis.defs.controller.AppAnalyzeController;
import com.yy.hiidostatis.defs.controller.BasicBehaviorController;
import com.yy.hiidostatis.defs.controller.BindTestPhoneController;
import com.yy.hiidostatis.defs.controller.CrashController;
import com.yy.hiidostatis.defs.controller.DeviceController;
import com.yy.hiidostatis.defs.controller.InstallController;
import com.yy.hiidostatis.defs.controller.OaidController;
import com.yy.hiidostatis.defs.controller.OnLineConfigController;
import com.yy.hiidostatis.defs.controller.PageStateController;
import com.yy.hiidostatis.defs.controller.SdkAnalyzeController;
import com.yy.hiidostatis.defs.controller.SdkVerController;
import com.yy.hiidostatis.defs.controller.SensorController;
import com.yy.hiidostatis.defs.handler.MetricsHandler;
import com.yy.hiidostatis.defs.listener.ActListener;
import com.yy.hiidostatis.defs.listener.HiidoSdkAdditionDelegate;
import com.yy.hiidostatis.defs.monitor.ScreenMonitor;
import com.yy.hiidostatis.defs.monitor.TrafficMonitor;
import com.yy.hiidostatis.defs.obj.Property;
import com.yy.hiidostatis.defs.obj.ShareType;
import com.yy.hiidostatis.inner.AbstractConfig;
import com.yy.hiidostatis.inner.AppInfo;
import com.yy.hiidostatis.inner.GeneralProxy;
import com.yy.hiidostatis.inner.implementation.CommonFiller;
import com.yy.hiidostatis.inner.util.ArdUtil;
import com.yy.hiidostatis.inner.util.Counter;
import com.yy.hiidostatis.inner.util.DefaultPreference;
import com.yy.hiidostatis.inner.util.InsideMode;
import com.yy.hiidostatis.inner.util.ThreadPool;
import com.yy.hiidostatis.inner.util.Util;
import com.yy.hiidostatis.inner.util.cipher.Coder;
import com.yy.hiidostatis.inner.util.hdid.DeviceProxy;
import com.yy.hiidostatis.inner.util.log.ActLog;
import com.yy.hiidostatis.inner.util.log.L;
import com.yy.hiidostatis.pref.HdStatisConfig;
import com.yy.hiidostatis.testui.FloatingService;
import com.yy.hiidostatis.track.DataTrack;
import com.yy.hiidostatis.track.HStaticApi;
import com.yy.mobile.perf.taskexecutor.IYYTaskExecutor;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import org.json.JSONObject;

public class HiidoSDK {
    private static final int INTERVAL_HEART_BEAT = 900000;
    private static final int STATE_STARTED = 1;
    private static final int STATE_QUITED = 2;
    private static final int STATE_INVALID = -1;
    private static final int METRICS_TIMER_INTERVAL = 30;
    public static final int SDK_SCODE = 50000;
    private static final int SDK_METRICS_TIMER_INTERVAL = 900;
    public static boolean isDebugMode = false;
    private int mState = -1;
    private boolean appRunIsCalled = false;
    private static final HiidoSDK sApi = new HiidoSDK();
    private static final String DEFAULT_METRICS_NAME = "DEFAULT_METRICS";
    public static final String SDK_METRICS_NAME = "SDK_METRICS";
    public static final String SDK_SUCCESS_COUNTER_NAME = "SDK_SUC";
    public static final String SDK_FAILED_COUNTER_NAME = "SDK_FAIL";
    public static final String SDK_DURATION_COUNTER_NAME = "SDK_DUR";
    private static OnStatisListener nullListener = new OnStatisListener(){

        @Override
        public long getCurrentUid() {
            return 0L;
        }
    };
    private volatile StatisOption mStatisOption = new StatisOption();
    private volatile Context mContext;
    private volatile Options mOptions = new Options();
    private final Handler mHandler = new Handler(Looper.getMainLooper());
    private final Counter mHeartbeatInvoker = new Counter(this.mHandler, 0, 900000L, true);
    private volatile Counter.Callback mHeartbeatReportExecutor;
    private final Counter mHeartbeatInvokerShort = new Counter(this.mHandler, 0, 60000L, true);
    private volatile Counter.Callback mHeartbeatReportExecutorShort;
    private volatile OnStatisListener mOnStatisListener = nullListener;
    private volatile QuitTimer mQuittimer = new QuitTimer();
    private static volatile boolean isResumeCall = false;
    private static StatisAPI mStatisAPI = new StatisAPI();
    private static ConfigAPI mConfigApi;
    private static BasicBehaviorController mBasicBehaviorController;
    private static AppAnalyzeController mAppAnalyzeController;
    private static SdkAnalyzeController mSdkAnalyzeController;
    private static SdkVerController mSdkVerController;
    private static InstallController mInstallController;
    private static DeviceController mDeviceController;
    private CrashController mCrashController;
    private SensorController sensorController;
    private MetricsHandler metricsHandler;
    private static OnLineConfigController mOnLineConfigController;
    private PageStateController pageStateController;
    private static volatile boolean mIsInit;
    private Map<String, String> mDoShortProp = new HashMap<String, String>();
    private boolean isAppRunning;
    private volatile boolean userAgreed = true;
    private ActivityLifecycleController mActivityLifecycleController = new ActivityLifecycleController();
    private boolean isFrontground = false;

    private HiidoSDK() {
    }

    public static HiidoSDK instance() {
        return sApi;
    }

    public void setOptions(Options options) {
        if (options == null) {
            this.mOptions = new Options();
            return;
        }
        this.mOptions = options;
    }

    public Options getOptions() {
        return this.mOptions;
    }

    public void appStartLaunchWithAppKey(Context context, String appKey, String appId, String from, OnStatisListener listener) {
        StatisOption sOption = new StatisOption();
        sOption.setAppId(appId);
        sOption.setAppkey(appKey);
        sOption.setFrom(from);
        this.appStartLaunchWithAppKey(context, sOption, listener);
    }

    public void appStartLaunchWithAppKey(final Context context, final StatisOption sOption, final OnStatisListener listener) {
        if (mIsInit) {
            L.warn(this, "sdk only be init once", new Object[0]);
            return;
        }
        AppInfo.INSTANCE.init(context);
        L.initLogConfig(context);
        this.sensorController = new SensorController(context, this.mOptions.gyroscopeThreshold, this.mOptions.accelerometerThreshold, this.mOptions.lightThreshold, this.mOptions.openSensorMonitor);
        FloatingService.INSTANCT.setFilterAppkey(sOption.getAppkey());
        mIsInit = true;
        Application app = (Application)context.getApplicationContext();
        this.mContext = context == null ? this.mContext : app;
        this.pageStateController = new PageStateController(mStatisAPI, context, listener);
        app.registerActivityLifecycleCallbacks(new Application.ActivityLifecycleCallbacks(){

            public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
            }

            public void onActivityStarted(Activity activity) {
                final String cn = activity.getClass().getName();
                ThreadPool.getPool().executeQueue(new Runnable(){

                    @Override
                    public void run() {
                        HiidoSDK.this.pageStateController.onStart(cn);
                        HiidoSDK.this.sensorController.onStart(context);
                    }
                });
                if (activity.getIntent() != null) {
                    Uri uri;
                    try {
                        uri = activity.getIntent().getData();
                        HiidoSDK.this.reportUrlScheme(uri);
                    }
                    catch (Throwable e) {
                        L.error(this, e.getMessage(), new Object[0]);
                    }
                    try {
                        uri = activity.getIntent().getData();
                        if (uri.getScheme().toLowerCase().startsWith("hiidodct.")) {
                            BindTestPhoneController.bind(uri.toString(), (Context)activity);
                            Toast.makeText((Context)activity.getApplicationContext(), (CharSequence)"\u53ef\u4ee5\u6d4b\u8bd5\u4e86", (int)1).show();
                        }
                    }
                    catch (Throwable e) {
                        L.error(this, e.getMessage(), new Object[0]);
                    }
                }
            }

            public void onActivityResumed(Activity activity) {
                if (FloatingService.INSTANCT.isDebug() && !FloatingService.INSTANCT.isInit()) {
                    FloatingService.INSTANCT.showFloatingWindow(activity);
                }
            }

            public void onActivityPaused(Activity activity) {
            }

            public void onActivityStopped(final Activity activity) {
                final String cn = activity.getClass().getName();
                ThreadPool.getPool().executeQueue(new Runnable(){

                    @Override
                    public void run() {
                        boolean isBackground = HiidoSDK.this.pageStateController.onStop(cn);
                        if (isBackground) {
                            HiidoSDK.this.metricsHandler.onBackground();
                            HiidoSDK.this.sensorController.onStop((Context)activity);
                        }
                    }
                });
            }

            public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
            }

            public void onActivityDestroyed(Activity activity) {
            }
        });
        if (listener == null) {
            L.brief("the Input listener is null ,so get the default listener instead", new Object[0]);
            this.mOnStatisListener = nullListener;
        } else {
            this.mOnStatisListener = listener;
        }
        if (sOption == null) {
            L.brief("the Input sOption is null ,so get the default sOption instead", new Object[0]);
        } else {
            this.mStatisOption = sOption;
        }
        if (Util.empty(this.mStatisOption.getAppkey())) {
            String appKey = ArdUtil.getMetaDataParam(this.mContext, "HIIDO_APPKEY");
            this.mStatisOption.setAppkey(appKey);
        }
        if (Util.empty(this.mStatisOption.getFrom())) {
            String from = ArdUtil.getMetaDataParam(this.mContext, "HIIDO_CHANNEL");
            this.mStatisOption.setFrom(from);
        }
        if (Util.empty(this.mStatisOption.getVer())) {
            this.mStatisOption.setVer(ArdUtil.getVersionName(this.mContext));
        }
        AbstractConfig config = HdStatisConfig.getConfig(this.mStatisOption.getAppkey());
        if (this.getOptions().openAutoTrack) {
            AutoTrack.startAutoTrack(context, this.mStatisOption.getAppkey(), this.mStatisOption.getVer(), config.getSdkVer(), config.getUrlHost(), config.getUrlAddress(), config.getTestServer());
        }
        ThreadPool.getPool().executeQueue(new Runnable(){

            @Override
            public void run() {
                if (HiidoSDK.this.mOptions.useOaid) {
                    OaidController.loadLib(context.getApplicationContext());
                    OaidController.INSTANCE.initOaidAsyn(context, new OaidController.OaidInitListener(){

                        @Override
                        public void initFinish(boolean success, String oaid, String error) {
                            HiidoSDK.this.oaidInitFinish();
                        }
                    });
                }
                L.setLogOn(HiidoSDK.this.getOptions().isLogOn);
                HiidoSDK.this.initData(context, sOption, listener);
                HiidoSDK.this.startCrashMonitor();
                L.infoOn(this, "testServer = %s", HiidoSDK.this.getOptions().testServer);
                L.infoOn(this, "isAbroad = %b", HiidoSDK.this.getOptions().isAbroad);
                L.infoOn(this, "isGp = %b", HiidoSDK.this.getOptions().isGp);
                L.infoOn(this, "isLogOn = %b", HiidoSDK.this.getOptions().isLogOn);
            }
        });
        this.initMetricsHandler(this.getStatisOption().getAppkey(), this.getStatisOption().getVer());
    }

    private boolean checkSDKInit() {
        if (!mIsInit) {
            L.warnOn(this, "The SDK is NOT init", new Object[0]);
        }
        return mIsInit;
    }

    private void initData(Context context, StatisOption sOption, OnStatisListener listener) {
        mStatisAPI.setTestServer(this.getOptions().testServer);
        mStatisAPI.setAbroad(this.getOptions().isAbroad);
        mStatisAPI.setBusinessType(this.getOptions().businessType);
        mStatisAPI.init(this.mContext, this.mStatisOption);
        mConfigApi = new ConfigAPI(this.mContext, this.mStatisOption.getAppkey());
        if (this.getOptions().isAbroad) {
            HStaticApi.instante.init(this.mContext, this.mStatisOption, this.getOptions().testServer);
        }
        DataTrack.instance.init(this.mContext, this.mStatisOption, new DataTrack.IDataTrackListener(){

            @Override
            public JSONObject getConfig(String appkey, long uid, String deviceid) {
                return mConfigApi.getDeviceConfig(HiidoSDK.this.mContext, appkey, deviceid, uid, true);
            }
        });
        mSdkAnalyzeController = new SdkAnalyzeController(mStatisAPI, mConfigApi);
        mSdkVerController = new SdkVerController(mConfigApi);
        mAppAnalyzeController = new AppAnalyzeController(mStatisAPI, mConfigApi);
        mInstallController = new InstallController(mStatisAPI);
        mDeviceController = new DeviceController(mStatisAPI, context);
        mOnLineConfigController = new OnLineConfigController(mConfigApi);
    }

    private void reportOnAppStartLaunch(Context context, OnStatisListener listener) {
        try {
            TrafficMonitor.instance.init(this.mContext);
            TrafficMonitor.instance.start();
            ScreenMonitor.instance.reset();
            mSdkVerController.startSdkVerCheck(context);
            mStatisAPI.generateSession();
            this.getAppActionReporter().onStartApp();
            this.sendInstallationReportIfNotYet(context);
            this.reportDo(context, listener.getCurrentUid());
            this.reportRun(context, listener.getCurrentUid());
            mDeviceController.reportDeviceOnLaunch(context, listener.getCurrentUid());
            this.sensorController.reset(context);
            mSdkAnalyzeController.reportSdkAnalyze(context, listener.getCurrentUid());
            this.startHeartbeatReport();
            if (this.getOptions().isOpenDoShort) {
                this.reportDoShort(context, listener.getCurrentUid());
                this.startHeartbeatReportShort();
            }
            GeneralProxy.start(context);
            GeneralProxy.stopTimer(context);
            DataTrack.instance.triggerTrack(true);
            ActLog.uploadLog(this.mContext, new ActLog.ILogConfigListener(){

                @Override
                public JSONObject getLogConfig() {
                    return mConfigApi.getAppListConfig(HiidoSDK.this.mContext, true);
                }
            });
        }
        catch (Throwable e) {
            L.error(this, "reportOnAppStartLaunch exception =%s", e);
        }
    }

    private void initMetricsHandler(String appkey, String ver) {
        this.metricsHandler = new MetricsHandler(this.mContext, appkey, ver, this.mOptions.defaultMetricsExpire);
        this.metricsHandler.addMetricsWorker(SDK_METRICS_NAME, 900L);
    }

    private void quitApp(boolean isNormal) {
        try {
            if (this.mState == 1) {
                BasicBehaviorController.PageActionReporter rpt = this.getPageActionReporter();
                if (rpt != null) {
                    if (!isNormal) {
                        rpt.onLeavingUI(null, null);
                        isResumeCall = false;
                    }
                    rpt.onFinishGotoUI(this.mOnStatisListener == null ? 0L : this.mOnStatisListener.getCurrentUid(), null, true);
                }
                this.metricsHandler.onExit();
                this.onQuitApp(isNormal);
                this.mState = 2;
                L.infoOn(this, "app quit. it is one appa finish. isNormal quit is [%b]\u3002", isNormal);
            }
        }
        catch (Throwable e) {
            L.error(this, "quitApp exception =%s", e);
        }
    }

    public void reportApplist() {
        ThreadPool.getPool().executeQueue(new Runnable(){

            @Override
            public void run() {
                try {
                    mAppAnalyzeController.reportAppAnalyze(HiidoSDK.this.mContext, HiidoSDK.this.mOnStatisListener.getCurrentUid());
                }
                catch (Throwable e) {
                    L.error(this, e.getMessage(), new Object[0]);
                }
            }
        });
    }

    public boolean registerActivityLifecycleMonitor(Context context) {
        this.mActivityLifecycleController.registerActivityLifecycleCallbacks(context, new ActivityLifecycleController.ActivityLifecycleCallback(){

            @Override
            public void onActivityResumed(Activity activity) {
                long uid = 0L;
                OnStatisListener listener = HiidoSDK.this.getOnStatisListener();
                if (listener != null) {
                    uid = listener.getCurrentUid();
                }
                HiidoSDK.this.onResumeInner(uid, HiidoSDK.this.getPageId(activity));
            }

            @Override
            public void onActivityPaused(Activity activity) {
                HiidoSDK.this.onPauseInner(HiidoSDK.this.getPageId(activity), PageActionReportOption.REPORT_ON_FUTURE_RESUME);
            }
        });
        L.infoOn(this, "registerActivityLifecycleMonitor = %b", this.mActivityLifecycleController.isRegister());
        return this.mActivityLifecycleController.isRegister();
    }

    private void reportUrlScheme(final Uri uri) {
        if (uri == null) {
            return;
        }
        ThreadPool.getPool().executeQueue(new Runnable(){

            @Override
            public void run() {
                if (!HiidoSDK.this.checkSDKInit()) {
                    return;
                }
                try {
                    String scheme = uri.getScheme();
                    String host = uri.getHost();
                    int port = uri.getPort();
                    String path = uri.getPath();
                    String query = uri.getQuery();
                    L.info(this, "URL SCHEME:%s://%s:%d/%s?%s", scheme, host, port, path, query);
                    mStatisAPI.reportUrlScheme(scheme, host, port, path, query);
                }
                catch (Throwable e) {
                    L.error(this, e.getMessage(), new Object[0]);
                }
            }
        });
    }

    private boolean oaidPrepared() {
        return !this.mOptions.useOaid || OaidController.ignore(this.mContext) || OaidController.INSTANCE.isLoaded();
    }

    private boolean imeiPrepared() {
        return !this.mOptions.waitGrant || Build.VERSION.SDK_INT > 28 || this.appRunIsCalled || ArdUtil.checkPermissions(this.mContext, "android.permission.READ_PHONE_STATE");
    }

    private void onResumeInner(final long uid, final String pageId) {
        this.isFrontground = true;
        ThreadPool.getPool().executeQueue(new Runnable(){

            @Override
            public void run() {
                if (!HiidoSDK.this.checkSDKInit()) {
                    return;
                }
                if (HiidoSDK.this.mOptions.ignoreActivity != null && HiidoSDK.this.mOptions.ignoreActivity.contains(pageId)) {
                    return;
                }
                try {
                    L.verbose(this, "clearQuitTimer in onResume", new Object[0]);
                    HiidoSDK.this.mQuittimer.clearQuitTimer();
                    isResumeCall = true;
                    if (HiidoSDK.this.imeiPrepared() && HiidoSDK.this.oaidPrepared()) {
                        HiidoSDK.this.appInitRun();
                    } else if (HiidoSDK.this.mState == 2 || HiidoSDK.this.mState == -1) {
                        HiidoSDK.this.reportDo(HiidoSDK.this.mContext, HiidoSDK.this.getOnStatisListener() != null ? HiidoSDK.this.getOnStatisListener().getCurrentUid() : 0L);
                    }
                    BasicBehaviorController.PageActionReporter reporter = HiidoSDK.this.getPageActionReporter();
                    if (reporter != null) {
                        reporter.onResumeUI(uid, pageId);
                    }
                    String tmpPageId = pageId;
                    try {
                        DefaultPreference.getPreference().setPrefString(HiidoSDK.this.mContext, "PREF_CPAGE", tmpPageId);
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                }
                catch (Throwable e) {
                    L.error(this, "onResume exception =%s", e);
                }
            }
        });
    }

    private void onPauseInner(final String pageId, final PageActionReportOption reportOption) {
        ThreadPool.getPool().executeQueue(new Runnable(){

            @Override
            public void run() {
                if (!HiidoSDK.this.checkSDKInit()) {
                    return;
                }
                if (HiidoSDK.this.mOptions.ignoreActivity != null && HiidoSDK.this.mOptions.ignoreActivity.contains(pageId)) {
                    return;
                }
                try {
                    if (isResumeCall) {
                        if (reportOption == PageActionReportOption.DO_NOT_REPORT_ON_FUTURE_RESUME) {
                            L.info(this, " DO_NOT_REPORT_ON_FUTURE_RESUME,Clear current page element on page %s", pageId);
                            HiidoSDK.this.getPageActionReporter().clearCurPageElement();
                        } else {
                            HiidoSDK.this.getPageActionReporter().onLeavingUI(pageId, null);
                        }
                        L.verbose(this, "startQuitTimer in onPause", new Object[0]);
                        HiidoSDK.this.mQuittimer.startQuitTimer();
                        isResumeCall = false;
                        HiidoSDK.this.getBehaviorCollector(HiidoSDK.this.getCtx(HiidoSDK.this.mContext)).saveLastOnPauseTime(Util.wallTimeMillis());
                    } else {
                        L.error(this, "call onPause() must call onResume() first", new Object[0]);
                    }
                }
                catch (Throwable e) {
                    L.error(this, "onPause exception =%s", e);
                }
            }
        });
    }

    private synchronized void appInitRun() {
        if (this.isFrontground && (this.mState == 2 || this.mState == -1)) {
            L.infoOn(this, "app enter. it is a new appa begin", new Object[0]);
            this.reportOnAppStartLaunch(this.mContext, this.mOnStatisListener);
            BasicBehaviorController.AppActionReporter reporter = this.getAppActionReporter();
            this.metricsHandler.onForeground();
            if (reporter != null) {
                reporter.onAppStarted();
            }
            this.mState = 1;
        }
    }

    public synchronized void appRun() {
        this.appRunIsCalled = true;
        if (this.oaidPrepared()) {
            ThreadPool.getPool().executeQueue(new Runnable(){

                @Override
                public void run() {
                    HiidoSDK.this.appInitRun();
                }
            });
        }
    }

    private synchronized void oaidInitFinish() {
        if (this.imeiPrepared()) {
            ThreadPool.getPool().executeQueue(new Runnable(){

                @Override
                public void run() {
                    HiidoSDK.this.appInitRun();
                }
            });
        }
    }

    public void onResume(long uid, String pageId) {
        if (this.mActivityLifecycleController.isRegister()) {
            return;
        }
        this.onResumeInner(uid, pageId);
    }

    public void onPause(String pageId, PageActionReportOption reportOption) {
        if (this.mActivityLifecycleController.isRegister()) {
            return;
        }
        this.onPauseInner(pageId, reportOption);
    }

    public void onResume(long uid, Activity activity) {
        if (this.mActivityLifecycleController.isRegister()) {
            return;
        }
        String pageId = this.getPageId(activity);
        this.onResume(uid, pageId);
    }

    public void onPause(Activity activity, PageActionReportOption reportOption) {
        if (this.mActivityLifecycleController.isRegister()) {
            return;
        }
        String pageId = this.getPageId(activity);
        this.onPause(pageId, reportOption);
    }

    public void onScreenResume(final String screen) {
        ThreadPool.getPool().executeQueue(new Runnable(){

            @Override
            public void run() {
                if (!HiidoSDK.this.checkSDKInit()) {
                    return;
                }
                try {
                    BasicBehaviorController.PageActionReporter reporter = HiidoSDK.this.getPageActionReporter();
                    long uid = 0L;
                    if (HiidoSDK.this.mOnStatisListener != null) {
                        uid = HiidoSDK.this.mOnStatisListener.getCurrentUid();
                    }
                    if (reporter != null) {
                        reporter.onResumeUI(uid, screen);
                    }
                    ThreadPool.getPool().executeQueue(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                DefaultPreference.getPreference().setPrefString(HiidoSDK.this.mContext, "PREF_CPAGE", screen);
                            }
                            catch (Throwable e) {
                                e.printStackTrace();
                            }
                        }
                    });
                }
                catch (Throwable e) {
                    L.error(this, "onScreenResume exception =%s", e);
                }
            }
        });
    }

    public void onScreenPause(final String screen) {
        ThreadPool.getPool().executeQueue(new Runnable(){

            @Override
            public void run() {
                try {
                    HiidoSDK.this.getPageActionReporter().onLeavingUI(screen, null);
                }
                catch (Throwable e) {
                    L.error(this, "onScreenPause exception =%s", e);
                }
            }
        });
    }

    public void setCurPageParam(String param) {
        if (this.getPageActionReporter() != null) {
            this.getPageActionReporter().setCurPageParam(param);
        }
    }

    public void onScreenMonitor(MotionEvent event) {
        ScreenMonitor.instance.onTouchEvent(event);
    }

    public Context getContext() {
        return this.mContext;
    }

    public HiidoSDK setLogWriter(StatisLogWriter logWriter) {
        L.setLogSetting(logWriter);
        return this;
    }

    private void onQuitApp(boolean isNormal) {
        Context c = this.mContext;
        if (c == null) {
            L.error(this, "No context, cannot do quit things properly, data lost.", new Object[0]);
            return;
        }
        Counter heartBeatInvoker = this.mHeartbeatInvoker;
        Counter heartBeatInvokerShort = this.mHeartbeatInvokerShort;
        if (heartBeatInvoker != null) {
            heartBeatInvoker.stop();
        }
        if (heartBeatInvokerShort != null) {
            heartBeatInvokerShort.stop();
        }
        this.mHeartbeatReportExecutor = null;
        this.mHeartbeatReportExecutorShort = null;
        TrafficMonitor.instance.end();
        BasicBehaviorController.AppActionReporter reporter = this.peekAppaActionReporter();
        if (reporter != null) {
            reporter.onExitApp(false, isNormal);
        } else {
            L.error(this, "No behavior reporter to report app action, sdk not initialized.", new Object[0]);
        }
        mStatisAPI.exit();
        GeneralProxy.exit(this.getContext(), isNormal);
        if (isNormal) {
            Context ctx = this.getContext();
            if (ctx != null) {
                GeneralProxy.startTimer(this.getContext(), 1800000L);
            }
            ThreadPool.getPool().execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    DataTrack.instance.triggerTrack(true);
                }
            });
        }
    }

    private BasicBehaviorController.AppActionReporter getAppActionReporter() {
        BasicBehaviorController collector = this.getBehaviorCollector(this.getCtx(this.mContext));
        return collector == null ? null : collector.getAppActionCollector();
    }

    private BasicBehaviorController.PageActionReporter getPageActionReporter() {
        BasicBehaviorController collector = this.getBehaviorCollector(this.getCtx(this.mContext));
        return collector == null ? null : collector.getPageActionCollector();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BasicBehaviorController getBehaviorCollector(Context context) {
        if ((context = this.getCtx(context)) == null) {
            L.error(this, "Input context is null when getBehaviorCollector", new Object[0]);
            return null;
        }
        BasicBehaviorController collector = mBasicBehaviorController;
        if (collector != null) {
            return collector;
        }
        HiidoSDK hiidoSDK = this;
        synchronized (hiidoSDK) {
            collector = mBasicBehaviorController;
            if (collector == null) {
                L.brief("mOnStatisListener is %s", this.mOnStatisListener);
                mBasicBehaviorController = collector = new BasicBehaviorController(context, this.mHandler, this.mOnStatisListener, mStatisAPI, this.getOptions().backgroundDurationMillisAsQuit, this.getOptions().behaviorSendThreshold, 10);
            }
            return collector;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BasicBehaviorController.AppActionReporter peekAppaActionReporter() {
        BasicBehaviorController collector = mBasicBehaviorController;
        if (collector != null) {
            return collector.getAppActionCollector();
        }
        HiidoSDK hiidoSDK = this;
        synchronized (hiidoSDK) {
            collector = mBasicBehaviorController;
            return collector == null ? null : collector.getAppActionCollector();
        }
    }

    public void reportLogin(final long uid) {
        ThreadPool.getPool().executeQueue(new Runnable(){

            @Override
            public void run() {
                mStatisAPI.reportLogin(uid);
                if (HiidoSDK.this.mState == 1) {
                    mStatisAPI.reportDo(uid);
                }
            }
        });
    }

    public void reportAppsflyer(final String data) {
        ThreadPool.getPool().executeQueue(new Runnable(){

            @Override
            public void run() {
                mStatisAPI.reportAppsflyer(data);
                if (HiidoSDK.this.mState == 1) {
                    HiidoSDK.this.reportDo(HiidoSDK.this.mContext, HiidoSDK.this.mOnStatisListener == null ? 0L : HiidoSDK.this.mOnStatisListener.getCurrentUid());
                }
            }
        });
    }

    public void reportShare(final String platform, final int mediaType, final String content, final ShareType stype, final String errmsg, final String screen, final String userData) {
        ThreadPool.getPool().executeQueue(new Runnable(){

            @Override
            public void run() {
                if (HiidoSDK.this.checkSDKInit()) {
                    mStatisAPI.reportShare(platform, mediaType, content, stype, errmsg, screen, userData);
                }
            }
        });
    }

    public void reportIM(final String sender, final String receiver, final String content, final Date editTime, final Date sendTime, final String errormsg, final int mediaType, final String userData) {
        ThreadPool.getPool().executeQueue(new Runnable(){

            @Override
            public void run() {
                if (HiidoSDK.this.checkSDKInit()) {
                    mStatisAPI.reportIM(sender, receiver, content, editTime, sendTime, errormsg, mediaType, userData);
                }
            }
        });
    }

    public void reportReg(final String uid, final String name, final String type, final Map<String, String> prop) {
        ThreadPool.getPool().executeQueue(new Runnable(){

            @Override
            public void run() {
                mStatisAPI.reportReg(uid, name, type, prop);
                HStaticApi.instante.reportReg(uid, name, type, prop);
            }
        });
    }

    private void reportRun(Context context, long uid) {
        try {
            if (this.mState == -1 || this.mState == 2) {
                mStatisAPI.reportRun(uid);
                L.info(this, "reportRun call", new Object[0]);
            } else {
                L.warn(this, "reportRun has been called, one launch only one call!", new Object[0]);
            }
        }
        catch (Throwable e) {
            L.error(this, "reportRun exception=%s", e);
        }
    }

    private void reportDo(Context context, long uid) {
        try {
            mStatisAPI.reportDo(uid);
            L.info(this, "report heart beat for %d", uid);
        }
        catch (Throwable e) {
            L.error(this, "report heart beat for %d.exception=%s", uid, e);
        }
    }

    private void reportDoShort(Context context, long uid) {
        try {
            if (this.mDoShortProp.size() == 0) {
                L.brief("report heart beat short for %d do nothing , mDoShortProp size  = 0", uid);
                return;
            }
            mStatisAPI.reportDoShort(uid, this.mDoShortProp);
            L.info(this, "report heart beat short for %d", uid);
        }
        catch (Throwable e) {
            L.error(this, "report heart beat short for %d.exception=%s", uid, e);
        }
    }

    private void flushCache(Context context) {
        if (new Random().nextInt(2) % 2 == 0) {
            if (context != null) {
                GeneralProxy.flushCache(context);
            }
            if (this.mCrashController != null) {
                this.mCrashController.flushCache();
            }
        }
    }

    public void setHeartbeatField(String key, String value) {
        String sid = this.mDoShortProp.get("sid");
        String subsid = this.mDoShortProp.get("subsid");
        String auid = this.mDoShortProp.get("auid");
        if (value == null) {
            this.mDoShortProp.remove(key);
        } else {
            this.mDoShortProp.put(key, value);
        }
        boolean isChange = false;
        if ("sid".equals(key) && (value != null && !value.equals(sid) || sid != null && !sid.equals(value))) {
            isChange = true;
        }
        if ("subsid".equals(key) && (value != null && !value.equals(subsid) || subsid != null && !subsid.equals(value))) {
            isChange = true;
        }
        if ("auid".equals(key) && (value != null && !value.equals(auid) || auid != null && !auid.equals(value))) {
            isChange = true;
        }
        if (isChange) {
            this.resetHeartbeatReportShort(1000L);
        }
    }

    public void reportErrorEvent(final long uid, final String errorId, final String errorMessage, final String param) {
        ThreadPool.getPool().executeQueue(new Runnable(){

            @Override
            public void run() {
                mStatisAPI.reportError(uid, errorId, errorMessage, param);
            }
        });
    }

    public void reportStatisticContentTemporary(final String act, final StatisContent content) {
        ThreadPool.getPool().executeQueue(new Runnable(){

            @Override
            public void run() {
                mStatisAPI.reportStatisticContentTemporary(act, content, true, true);
            }
        });
    }

    public void reportStatisticContent(final String act, final StatisContent content) {
        ThreadPool.getPool().executeQueue(new Runnable(){

            @Override
            public void run() {
                mStatisAPI.reportStatisticContent(act, content, true, true);
            }
        });
    }

    public void reportStatisticContent(final String act, final StatisContent content, final boolean isPriority) {
        ThreadPool.getPool().executeQueue(new Runnable(){

            @Override
            public void run() {
                mStatisAPI.reportStatisticContent(act, content, true, true, isPriority);
            }
        });
    }

    public void reportStatisticContentWithNoComm(final Context context, final String act, final StatisContent content) {
        ThreadPool.getPool().executeQueue(new Runnable(){

            @Override
            public void run() {
                mStatisAPI.reportStatisticContentWithNoComm(HiidoSDK.this.getCtx(context), act, content);
            }
        });
    }

    public void reportStatisticContentWithNoComm(final Context context, final String act, final StatisContent content, final boolean isPriority) {
        ThreadPool.getPool().executeQueue(new Runnable(){

            @Override
            public void run() {
                mStatisAPI.reportStatisticContentWithNoComm(HiidoSDK.this.getCtx(context), act, content, isPriority);
            }
        });
    }

    public void reportCustomContent(final long uid, final String type, final String content) {
        ThreadPool.getPool().executeQueue(new Runnable(){

            @Override
            public void run() {
                Context context = HiidoSDK.this.mContext;
                if (context == null) {
                    L.error(this, "Input context is null,sdk is not init?", new Object[0]);
                    return;
                }
                mStatisAPI.reportCustomContent(uid, type, content);
            }
        });
    }

    public void reportCrash(final long uid, final String crashMsg) {
        ThreadPool.getPool().executeQueue(new Runnable(){

            @Override
            public void run() {
                mStatisAPI.reportCrash(uid, crashMsg);
            }
        });
    }

    public void reportCrash(final long uid, final Throwable throwable) {
        ThreadPool.getPool().executeQueue(new Runnable(){

            @Override
            public void run() {
                mStatisAPI.reportCrash(uid, throwable);
            }
        });
    }

    public void reportTimesEvent(final long uid, final String eid) {
        ThreadPool.getPool().executeQueue(new Runnable(){

            @Override
            public void run() {
                HiidoSDK.this.reportTimesEvent(uid, eid, null);
            }
        });
    }

    public void reportTimesEvent(final long uid, final String eid, final String label) {
        ThreadPool.getPool().executeQueue(new Runnable(){

            @Override
            public void run() {
                HiidoSDK.this.reportTimesEvent(uid, eid, label, null);
            }
        });
    }

    public void reportTimesEvent(final long uid, final String eid, final String label, Property property) {
        final Property pro = property == null ? null : property.copy();
        ThreadPool.getPool().executeQueue(new Runnable(){

            @Override
            public void run() {
                mStatisAPI.reportTimesEvent(uid, eid, label, pro);
            }
        });
    }

    public void reportCountEvent(final long uid, final String eid, final double evalue) {
        ThreadPool.getPool().executeQueue(new Runnable(){

            @Override
            public void run() {
                HiidoSDK.this.reportCountEvent(uid, eid, evalue, null);
            }
        });
    }

    public void reportCountEvent(final long uid, final String eid, final double evalue, final String label) {
        ThreadPool.getPool().executeQueue(new Runnable(){

            @Override
            public void run() {
                HiidoSDK.this.reportCountEvent(uid, eid, evalue, label, null);
            }
        });
    }

    public void reportCountEvent(final long uid, final String eid, final double evalue, final String label, Property property) {
        final Property pro = property == null ? null : property.copy();
        ThreadPool.getPool().executeQueue(new Runnable(){

            @Override
            public void run() {
                mStatisAPI.reportCountEvent(uid, eid, evalue, label, pro);
            }
        });
    }

    public void reportSuccess(final long uid, final String aid, final String type, final long duration, final String parm) {
        ThreadPool.getPool().executeQueue(new Runnable(){

            @Override
            public void run() {
                Context context = HiidoSDK.this.mContext;
                if (context == null) {
                    L.error(this, "Input context is null,sdk is not init?", new Object[0]);
                    return;
                }
                mStatisAPI.reportSuccess(uid, aid, type, duration, parm);
            }
        });
    }

    public void reportFailure(final long uid, final String aid, final String type, final String failCode, final String failMsg, final String parm) {
        ThreadPool.getPool().executeQueue(new Runnable(){

            @Override
            public void run() {
                Context context = HiidoSDK.this.mContext;
                if (context == null) {
                    L.error(this, "Input context is null,sdk is not init?", new Object[0]);
                    return;
                }
                mStatisAPI.reportFailure(uid, aid, type, failCode, failMsg, parm);
            }
        });
    }

    private Context getCtx(Context context) {
        return context == null ? this.mContext : context;
    }

    private void sendInstallationReportIfNotYet(Context context) {
        Context ctx = this.getCtx(context);
        if (ctx == null || mInstallController == null) {
            L.error(this, "Input context is null,sdk is not init?", new Object[0]);
            return;
        }
        mInstallController.sendInstallationReportIfNotYet(ctx);
    }

    private void startHeartbeatReport() {
        Counter.Callback executor = this.mHeartbeatReportExecutor;
        if (executor != null) {
            L.warn(this, "heart beat as for mbsdkdo has been started.", new Object[0]);
            return;
        }
        this.mHeartbeatReportExecutor = executor = new Counter.Callback(){

            @Override
            public void onCount(int counter) {
                long uid = HiidoSDK.this.mOnStatisListener.getCurrentUid();
                HiidoSDK.this.reportDo(HiidoSDK.this.mContext, uid);
            }
        };
        this.mHeartbeatInvoker.setCallback(executor);
        this.mHeartbeatInvoker.start(this.mHeartbeatInvoker.getInterval());
        L.info(this, "start heart beat invoker for mbsdkdo.", new Object[0]);
    }

    private void startHeartbeatReportShort() {
        Counter.Callback executor = this.mHeartbeatReportExecutorShort;
        if (executor != null) {
            L.warn(this, "heart beat as for mbsdkdo short has been started.", new Object[0]);
            return;
        }
        this.mHeartbeatReportExecutorShort = executor = new Counter.Callback(){

            @Override
            public void onCount(int counter) {
                long uid = HiidoSDK.this.mOnStatisListener.getCurrentUid();
                HiidoSDK.this.reportDoShort(HiidoSDK.this.mContext, uid);
                HiidoSDK.this.flushCache(HiidoSDK.this.mContext);
                DataTrack.instance.triggerTrack(false);
            }
        };
        this.mHeartbeatInvokerShort.setCallback(executor);
        this.mHeartbeatInvokerShort.start(this.mHeartbeatInvokerShort.getInterval());
        L.info(this, "start heart beat invoker for mbsdkdo short.", new Object[0]);
    }

    private void resetHeartbeatReportShort(long delayMs) {
        try {
            if (this.mHeartbeatInvokerShort != null && this.mHeartbeatInvokerShort.running()) {
                this.mHeartbeatInvokerShort.stop();
                this.mHeartbeatInvokerShort.start(delayMs);
            }
        }
        catch (Throwable e) {
            L.error(this, "resetHeartbeatReportShort exception = %s", e);
        }
    }

    public void updateOnlineConfigs(final Context context) {
        ThreadPool.getPool().executeQueue(new Runnable(){

            @Override
            public void run() {
                Context c;
                Context context2 = c = context == null ? HiidoSDK.this.mContext : context;
                if (c == null || mOnLineConfigController == null) {
                    L.warn(this, "updateOnlineConfigs error,Input context is null", new Object[0]);
                    return;
                }
                mOnLineConfigController.updateOnlineConfigs(c, HiidoSDK.this.getAppKey());
            }
        });
    }

    public String getOnlineConfigParams(Context context, String onlineKey) {
        Context c;
        Context context2 = c = context == null ? this.mContext : context;
        if (c == null) {
            L.warn(this, "getOnlineConfigParams error,Input context is null", new Object[0]);
            return null;
        }
        if (!mIsInit) {
            L.warn(this, "getOnlineConfigParams error,not init sdk?", new Object[0]);
            return null;
        }
        return mOnLineConfigController.getOnlineConfigParams(c, onlineKey);
    }

    public void setOnLineConfigListener(final OnLineConfigListener onLineConfigListener) {
        ThreadPool.getPool().executeQueue(new Runnable(){

            @Override
            public void run() {
                if (!HiidoSDK.this.checkSDKInit()) {
                    return;
                }
                mOnLineConfigController.setOnLineConfigListener(onLineConfigListener);
            }
        });
    }

    public String getAppId() {
        return this.mStatisOption.getAppId();
    }

    public String getAppKey() {
        return this.mStatisOption.getAppkey();
    }

    public String getFrom() {
        return this.mStatisOption.getFrom();
    }

    private void startCrashMonitor() {
        ThreadPool.getPool().executeQueue(new Runnable(){

            @Override
            public void run() {
                L.info(this, "isOpenCrashMonitor is %b", HiidoSDK.this.getOptions().isOpenCrashMonitor);
                if (HiidoSDK.this.getOptions().isOpenCrashMonitor) {
                    if (HiidoSDK.this.mCrashController != null) {
                        L.warn(this, "crash monitor has been started.", new Object[0]);
                        return;
                    }
                    HiidoSDK.this.mCrashController = new CrashController(HiidoSDK.this.getContext(), mStatisAPI, HiidoSDK.this.mOnStatisListener, new CrashController.OnCrashListener(){

                        @Override
                        public void handler(JSONObject json) {
                            ThreadPool.getPool().execute(new Runnable(){

                                @Override
                                public void run() {
                                    HiidoSDK.this.quitApp(false);
                                }
                            });
                        }
                    });
                    HiidoSDK.this.mCrashController.startCrashMonitor();
                }
            }
        });
    }

    private String getPageId(Activity activity) {
        if (activity != null) {
            return activity.getClass().getName();
        }
        return "";
    }

    public StatisAPI createNewStatisApi() {
        StatisAPI sApi = new StatisAPI();
        sApi.setAbroad(this.getOptions().isAbroad);
        sApi.setTestServer(this.getOptions().testServer);
        sApi.setBusinessType(this.getOptions().businessType);
        return sApi;
    }

    public void addActAdditionListener(final ActListener listener) {
        ThreadPool.getPool().executeQueue(new Runnable(){

            @Override
            public void run() {
                mStatisAPI.addActAdditionListener(listener);
            }
        });
    }

    public void setAdditionParamsDelegate(final HiidoSdkAdditionDelegate hiidoSdkAdditionDelegate) {
        ThreadPool.getPool().executeQueue(new Runnable(){

            @Override
            public void run() {
                mStatisAPI.setAdditionParamsDelegate(hiidoSdkAdditionDelegate);
            }
        });
    }

    public void removeActAdditionListerner(final ActListener listener) {
        ThreadPool.getPool().executeQueue(new Runnable(){

            @Override
            public void run() {
                mStatisAPI.removeActAdditionListener(listener);
            }
        });
    }

    public StatisOption getStatisOption() {
        return this.mStatisOption;
    }

    public OnStatisListener getOnStatisListener() {
        return this.mOnStatisListener;
    }

    public String getDeviceId(Context context) {
        return CommonFiller.getIMEI(context);
    }

    public String getMac(Context context) {
        return CommonFiller.getMacAddr(context);
    }

    @Deprecated
    public String getHdid(Context context) {
        return DeviceProxy.getHdid(context);
    }

    public void getHdid(final Context context, final HdidReceiver receiver) {
        ThreadPool.getPool().execute(new Runnable(){

            @Override
            public void run() {
                String hdid = DeviceProxy.getHdid(context);
                if (receiver != null) {
                    receiver.onHdidReceived(hdid);
                }
            }
        });
    }

    public boolean reportFeedBack(final String cont, final String link, final String remk) {
        ThreadPool.getPool().executeQueue(new Runnable(){

            @Override
            public void run() {
                String fbId = null;
                try {
                    fbId = Coder.encryptMD5(UUID.randomUUID().toString());
                }
                catch (Throwable e) {
                    L.error(this, e.getMessage(), new Object[0]);
                }
                mStatisAPI.reportFeedback(HiidoSDK.this.mOnStatisListener.getCurrentUid(), fbId, cont, link, remk, null);
            }
        });
        return true;
    }

    public void reportLocation(final double longitude, final double latitude, final double altitude) {
        ThreadPool.getPool().executeQueue(new Runnable(){

            @Override
            public void run() {
                mStatisAPI.reportLocation(HiidoSDK.this.mOnStatisListener.getCurrentUid(), longitude, latitude, altitude, null);
            }
        });
    }

    public void reportPushToken(final String token) {
        ThreadPool.getPool().executeQueue(new Runnable(){

            @Override
            public void run() {
                mStatisAPI.reportPushToken(HiidoSDK.this.mOnStatisListener.getCurrentUid(), token);
            }
        });
    }

    public MetricsWorker addMetricsWorker(String workName, long interval) {
        if (!this.checkSDKInit()) {
            return null;
        }
        return this.metricsHandler.addMetricsWorker(workName, interval);
    }

    public void reportReturnCode(int scode, String uri, long timeConsumption, String code) {
        if (!this.checkSDKInit()) {
            return;
        }
        if (!this.metricsHandler.containMetric(DEFAULT_METRICS_NAME)) {
            this.metricsHandler.addMetricsWorker(DEFAULT_METRICS_NAME, this.mOptions.defaultMetricsInterval);
        }
        this.metricsHandler.reportReturnCode(DEFAULT_METRICS_NAME, scode, uri, timeConsumption, code);
    }

    public void reportCount(int scode, String uri, String countName, long count) {
        if (!this.checkSDKInit()) {
            return;
        }
        if (!this.metricsHandler.containMetric(DEFAULT_METRICS_NAME)) {
            this.metricsHandler.addMetricsWorker(DEFAULT_METRICS_NAME, this.mOptions.defaultMetricsInterval);
        }
        this.metricsHandler.reportCount(DEFAULT_METRICS_NAME, scode, uri, countName, count);
    }

    public void reportCount(int scode, String uri, String countName, long count, int times) {
        if (!this.checkSDKInit()) {
            return;
        }
        if (!this.metricsHandler.containMetric(DEFAULT_METRICS_NAME)) {
            this.metricsHandler.addMetricsWorker(DEFAULT_METRICS_NAME, this.mOptions.defaultMetricsInterval);
        }
        this.metricsHandler.reportCount(DEFAULT_METRICS_NAME, scode, uri, countName, count, times);
    }

    public void reportReturnCode(String metricsName, int scode, String uri, long timeConsumption, String code) {
        if (!this.checkSDKInit()) {
            return;
        }
        this.metricsHandler.reportReturnCode(metricsName, scode, uri, timeConsumption, code);
    }

    public void reportCount(String metricsName, int scode, String uri, String countName, long count) {
        if (!this.checkSDKInit()) {
            return;
        }
        this.metricsHandler.reportCount(metricsName, scode, uri, countName, count);
    }

    public void reportCount(String metricsName, int scode, String uri, String countName, long count, int times) {
        if (!this.checkSDKInit()) {
            return;
        }
        this.metricsHandler.reportCount(metricsName, scode, uri, countName, count, times);
    }

    public void setUserAgreed(boolean agreed) {
        this.userAgreed = agreed;
    }

    public boolean isUserAgreed() {
        if (Build.VERSION.SDK_INT >= 23 || this.userAgreed) {
            return true;
        }
        String sjp = null;
        try {
            sjp = ArdUtil.getSjp(this.mContext);
            sjp.trim();
        }
        catch (Throwable e) {
            L.error(this, e.toString(), new Object[0]);
        }
        return sjp != null && (sjp.equalsIgnoreCase("OPPO") || sjp.equalsIgnoreCase("VIVO"));
    }

    public void reportSrcData(int scode, String uri, String topic, long val, Map<String, String> extra) {
        if (!this.checkSDKInit()) {
            return;
        }
        if (!this.metricsHandler.containMetric(DEFAULT_METRICS_NAME)) {
            this.metricsHandler.addMetricsWorker(DEFAULT_METRICS_NAME, this.mOptions.defaultMetricsInterval);
        }
        this.metricsHandler.reportSrcData(DEFAULT_METRICS_NAME, scode, uri, topic, val, extra);
    }

    public void reportSrcData(String metricsName, int scode, String uri, String topic, long val, Map<String, String> extra) {
        if (!this.checkSDKInit()) {
            return;
        }
        this.metricsHandler.reportSrcData(metricsName, scode, uri, topic, val, extra);
    }

    static {
        mIsInit = false;
    }

    public static interface HdidReceiver {
        public void onHdidReceived(String var1);
    }

    private class QuitTimer {
        private final Runnable mQuitTimer = new Runnable(){

            @Override
            public void run() {
                HiidoSDK.this.quitApp(true);
            }
        };

        private QuitTimer() {
        }

        public void startQuitTimer() {
            HiidoSDK.this.mHandler.postDelayed(this.mQuitTimer, HiidoSDK.this.getOptions().backgroundDurationMillisAsQuit);
        }

        public void clearQuitTimer() {
            HiidoSDK.this.mHandler.removeCallbacks(this.mQuitTimer);
        }
    }

    public static enum PageActionReportOption {
        REPORT_ON_FUTURE_RESUME,
        DO_NOT_REPORT_ON_FUTURE_RESUME;

    }

    public static class Options {
        public static final int BEHAVIOR_SEND_THRESHOLD_MAX = 100;
        public static final int BEHAVIOR_SEND_THRESHOLD_DEFAULT = 10;
        public static final int DEFAULT_BASIC_BEHAVIOR_SEND_INTERVAL = 600000;
        public static final int MIN_BASIC_BEHAVIOR_SEND_INTERVAL = 60000;
        public static final int MAX_BASIC_BEHAVIOR_SEND_INTERVAL = 1800000;
        public int behaviorSendThreshold = 10;
        public int behaviorSendIntervalMillis = 600000;
        public static final int DEFAULT_BACKGROUND_DURATION_MILLIS_AS_QUIT = 30000;
        public long backgroundDurationMillisAsQuit = 30000L;
        public volatile String testServer;
        public boolean isOpenCrashMonitor = true;
        public boolean isLogOn = false;
        public boolean isOpenDo5 = true;
        private boolean isOpenDoShort = true;
        @Deprecated
        public boolean isAbroad = false;
        public int businessType = 100;
        private Set<String> ignoreActivity;
        @Deprecated
        public boolean isGp = false;
        public boolean isNewMac = true;
        private int defaultMetricsExpire = 1800;
        public int defaultMetricsInterval = 60;
        private boolean openSDKMetrics = true;
        public boolean openAutoTrack = false;
        private boolean waitGrant = false;
        private ReportFailedCallback reportFailedCallback = null;
        private float gyroscopeThreshold = 0.5f;
        private float accelerometerThreshold = 0.6f;
        private float lightThreshold = 15.0f;
        private boolean openSensorMonitor = false;
        private boolean useOaid = true;

        public boolean isUseOaid() {
            return this.useOaid;
        }

        public Options setUseOaid(boolean useOaid) {
            this.useOaid = useOaid;
            return this;
        }

        public Options setSensorThreshold(float gyroscope, float accelerometer, float light) {
            this.gyroscopeThreshold = gyroscope;
            this.accelerometerThreshold = accelerometer;
            this.lightThreshold = light;
            return this;
        }

        public boolean isOpenSensorMonitor() {
            return this.openSensorMonitor;
        }

        public Options setOpenSensorMonitor(boolean openSensorMonitor) {
            this.openSensorMonitor = openSensorMonitor;
            return this;
        }

        public Options setActLogEnable(boolean b) {
            ActLog.setLogEnable(b);
            return this;
        }

        public Options setHostApp(InsideMode.HostApp hostApp) {
            InsideMode.initHostApp(hostApp);
            return this;
        }

        public Options setTaskExecutor(IYYTaskExecutor executor) {
            ExecutorProvider.setIyyTaskExecutor(executor);
            return this;
        }

        public Options setMaxDataRetryTimes(int maxTimes) {
            AbstractConfig.MAX_DATA_RETRY_TIME = maxTimes > 10000 ? maxTimes : 10000;
            return this;
        }

        public boolean isAbroad() {
            return this.isAbroad;
        }

        @Deprecated
        public Options setAbroad(boolean abroad) {
            this.isAbroad = abroad;
            return this;
        }

        public Options setMaxDataCacheDay(int maxDay) {
            AbstractConfig.MAX_DATA_CACHE_DAY = maxDay > 5 ? maxDay : 5;
            return this;
        }

        public Set<String> getIgnoreActivity() {
            return this.ignoreActivity;
        }

        public Options setIgnoreActivity(String ... activitys) {
            if (activitys == null) {
                return this;
            }
            if (this.ignoreActivity == null) {
                this.ignoreActivity = new HashSet<String>(activitys.length);
            } else {
                this.ignoreActivity.clear();
            }
            this.ignoreActivity.addAll(Arrays.asList(activitys));
            return this;
        }

        public boolean isWaitGrant() {
            return this.waitGrant;
        }

        public Options setWaitGrant(boolean waitGrant) {
            this.waitGrant = waitGrant;
            return this;
        }

        public int getBehaviorSendThreshold() {
            return this.behaviorSendThreshold;
        }

        public Options setBehaviorSendThreshold(int behaviorSendThreshold) {
            this.behaviorSendThreshold = behaviorSendThreshold;
            return this;
        }

        public long getBackgroundDurationMillisAsQuit() {
            return this.backgroundDurationMillisAsQuit;
        }

        public Options setBackgroundDurationMillisAsQuit(long backgroundDurationMillisAsQuit) {
            this.backgroundDurationMillisAsQuit = backgroundDurationMillisAsQuit;
            return this;
        }

        public boolean isOpenCrashMonitor() {
            return this.isOpenCrashMonitor;
        }

        public Options setOpenCrashMonitor(boolean openCrashMonitor) {
            this.isOpenCrashMonitor = openCrashMonitor;
            return this;
        }

        public boolean isLogOn() {
            return this.isLogOn;
        }

        public Options setLogOn(boolean logOn) {
            this.isLogOn = logOn;
            return this;
        }

        public boolean isOpenDoShort() {
            return this.isOpenDoShort;
        }

        public Options setOpenDoShort(boolean openDoShort) {
            this.isOpenDoShort = openDoShort;
            return this;
        }

        public int getBusinessType() {
            return this.businessType;
        }

        public Options setBusinessType(int businessType) {
            this.businessType = businessType;
            return this;
        }

        @Deprecated
        public boolean isGp() {
            return this.isGp;
        }

        @Deprecated
        public Options setGp(boolean gp) {
            this.isGp = gp;
            return this;
        }

        public int getDefaultMetricsExpire() {
            return this.defaultMetricsExpire;
        }

        public Options setDefaultMetricsExpire(int defaultMetricsExpire) {
            this.defaultMetricsExpire = defaultMetricsExpire;
            return this;
        }

        public int getDefaultMetricsInterval() {
            return this.defaultMetricsInterval;
        }

        public Options setDefaultMetricsInterval(int defaultMetricsInterval) {
            this.defaultMetricsInterval = defaultMetricsInterval;
            return this;
        }

        public boolean isOpenSDKMetrics() {
            return this.openSDKMetrics;
        }

        public Options setOpenSDKMetrics(boolean openSDKMetrics) {
            this.openSDKMetrics = openSDKMetrics;
            return this;
        }

        public boolean isOpenAutoTrack() {
            return this.openAutoTrack;
        }

        public Options setOpenAutoTrack(boolean openAutoTrack) {
            this.openAutoTrack = openAutoTrack;
            return this;
        }

        public ReportFailedCallback getReportFailedCallback() {
            return this.reportFailedCallback;
        }

        public Options setReportFailedCallback(ReportFailedCallback reportFailedCallback) {
            this.reportFailedCallback = reportFailedCallback;
            return this;
        }

        public boolean isShowFloatingDialog() {
            return FloatingService.INSTANCT.isDebug();
        }

        public Options setShowFloatingDialog(boolean showFloatingDialog) {
            FloatingService.INSTANCT.setDebug(showFloatingDialog);
            return this;
        }

        public Options needUserAgree() {
            HiidoSDK.instance().setUserAgreed(false);
            return this;
        }
    }
}

