/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiidostatis.inner.util.hdid;

import android.content.ContentResolver;
import android.content.Context;
import android.os.Build;
import android.os.Environment;
import android.provider.Settings;
import com.yy.hiidostatis.inner.util.ArdUtil;
import com.yy.hiidostatis.inner.util.FileUtil;
import com.yy.hiidostatis.inner.util.cipher.Coder;
import com.yy.hiidostatis.inner.util.hdid.Device;
import com.yy.hiidostatis.inner.util.hdid.DeviceManager;
import com.yy.hiidostatis.inner.util.hdid.DeviceProxy;
import com.yy.hiidostatis.inner.util.log.L;
import java.io.File;
import java.io.FilenameFilter;
import org.json.JSONException;
import org.json.JSONObject;

public enum DeviceManagerV2 {
    instance;

    private static final Object LOCK;
    private Device mDi = null;
    private static final String KEY_MAGIC1 = "!qazxsw@v2";
    private static final String KEY_MAGIC2 = "#edcvfr$v2";
    private static final String SETTING_KEY = "HdSdkBBAVip";

    private String getInnerPath(Context c) {
        StringBuffer sb = new StringBuffer();
        try {
            sb.append(c.getFilesDir().getAbsolutePath());
        }
        catch (Throwable ex) {
            return "";
        }
        sb.append(File.separator);
        sb.append("hdid_v2");
        String local = sb.toString();
        sb.setLength(0);
        sb = null;
        return local;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Device getDevice(Context c) {
        if (this.mDi != null) {
            return this.mDi;
        }
        Object object = LOCK;
        synchronized (object) {
            if (this.mDi != null) {
                return this.mDi;
            }
            this.mDi = this.initDevice(c);
            this.mDi.sdPermission = this.getSdpm(c);
        }
        return this.mDi;
    }

    private Device initDevice(Context c) {
        Device inner = this.getInner(c);
        Device out1 = this.getOut1(c);
        Device setting = this.getSetting(c);
        if (inner != null) {
            inner.hFrom = 4;
            if (out1 == null) {
                this.saveOut1(c, inner);
                L.debug((Object)this, "saveOut1", new Object[0]);
            }
            if (setting == null) {
                this.saveSetting(c, inner);
                L.debug((Object)this, "saveSetting", new Object[0]);
            }
            DeviceManager.instance.syncAll(c, inner);
            return inner;
        }
        if (out1 != null) {
            out1.hFrom = 5;
            L.debug((Object)this, "saveInner", new Object[0]);
            this.saveInner(c, out1);
            if (setting == null) {
                this.saveSetting(c, out1);
                L.debug((Object)this, "saveSetting", new Object[0]);
            }
            DeviceManager.instance.syncAll(c, out1);
            return out1;
        }
        if (setting != null) {
            setting.hFrom = 6;
            this.saveInner(c, setting);
            L.debug((Object)this, "saveInner", new Object[0]);
            this.saveOut1(c, setting);
            L.debug((Object)this, "saveOut1", new Object[0]);
            DeviceManager.instance.syncAll(c, setting);
            return setting;
        }
        L.debug((Object)this, "saveInner,saveOut1,saveSetting", new Object[0]);
        Device v1 = DeviceManager.instance.getDevice(c);
        this.saveInner(c, v1);
        this.saveOut1(c, v1);
        this.saveSetting(c, v1);
        return v1;
    }

    private Device getInner(Context c) {
        try {
            String s = FileUtil.readFile(this.getInnerPath(c));
            if (s != null) {
                return this.s2d(Coder.decryptDES(s, "!qazxsw@v2#edcvfr$v2"));
            }
        }
        catch (Throwable e) {
            L.warn((Object)this, "getInner exception = %s", e);
        }
        return null;
    }

    private Device getOut1(Context c) {
        if (Build.VERSION.SDK_INT > 22) {
            return null;
        }
        try {
            String OUT1_PATH = Environment.getExternalStorageDirectory().getAbsolutePath() + File.separator + ".hiidosdk" + File.separator + "Device_v2";
            String s = FileUtil.readFile(OUT1_PATH);
            if (s != null) {
                return this.s2d(Coder.decryptDES(s, KEY_MAGIC1));
            }
        }
        catch (Throwable e) {
            L.warn((Object)this, "getOut1 exception = %s", e);
        }
        return null;
    }

    private Device getSetting(Context c) {
        try {
            String s = Settings.System.getString((ContentResolver)c.getApplicationContext().getContentResolver(), (String)SETTING_KEY);
            if (s != null) {
                return this.s2d(Coder.decryptDES(s, KEY_MAGIC2));
            }
        }
        catch (Throwable e) {
            L.warn((Object)this, "getSetting exception = %s", e);
        }
        return null;
    }

    private void saveInner(Context c, Device di) {
        try {
            FileUtil.saveFile(this.getInnerPath(c), Coder.encryptDES(this.d2s(di), "!qazxsw@v2#edcvfr$v2"));
        }
        catch (Throwable e) {
            L.warn((Object)this, "saveInner exception = %s", e);
        }
    }

    private void saveOut1(Context c, Device di) {
        if (Build.VERSION.SDK_INT > 22) {
            return;
        }
        try {
            String OUT1_PATH = Environment.getExternalStorageDirectory().getAbsolutePath() + File.separator + ".hiidosdk" + File.separator + "Device_v2";
            FileUtil.saveFile(OUT1_PATH, Coder.encryptDES(this.d2s(di), KEY_MAGIC1));
        }
        catch (Throwable e) {
            L.warn((Object)this, "saveOut1 exception = %s", e);
        }
    }

    private void saveSetting(Context c, Device di) {
        if (ArdUtil.checkPermissions(c, "android.permission.WRITE_SETTINGS")) {
            try {
                Settings.System.putString((ContentResolver)c.getApplicationContext().getContentResolver(), (String)SETTING_KEY, (String)Coder.encryptDES(this.d2s(di), KEY_MAGIC2));
            }
            catch (Throwable e) {
                L.warn((Object)this, "saveSetting exception = %s", e);
            }
        }
    }

    private String d2s(Device di) {
        if (di.json == null) {
            di.json = new JSONObject();
        }
        this.putString(di.json, "hdid", di.hdid);
        this.putString(di.json, "type", di.type);
        this.putString(di.json, "imei", di.imei);
        this.putString(di.json, "mac", di.mac);
        this.putString(di.json, "arid", di.arid);
        this.putString(di.json, "key", this.key(di.hdid + di.imei + di.mac));
        this.putLong(di.json, "crtTime", di.crtTime);
        return di.json.toString();
    }

    private Device s2d(String s) {
        if (s == null) {
            return null;
        }
        JSONObject json = null;
        try {
            json = new JSONObject(s);
        }
        catch (JSONException e) {
            L.error((Object)this, e.getMessage(), new Object[0]);
        }
        if (json == null) {
            return null;
        }
        String hdid = this.getString(json, "hdid");
        String type = this.getString(json, "type");
        String imei = this.getString(json, "imei");
        String mac = this.getString(json, "mac");
        String key = this.getString(json, "key");
        if (this.key(hdid + imei + mac).equals(key)) {
            Device di = new Device();
            di.json = json;
            di.hdid = hdid;
            di.imei = imei;
            di.mac = mac;
            di.type = type;
            di.arid = this.getString(json, "arid");
            di.crtTime = this.getLong(json, "crtTime", 0L);
            return di;
        }
        L.warn(DeviceProxy.class, "verify fail. %s", s + "");
        return null;
    }

    private String getString(JSONObject json, String key) {
        String val = null;
        if (json != null && json.has(key)) {
            try {
                val = json.getString(key);
            }
            catch (JSONException e) {
                L.error((Object)this, e.getMessage(), new Object[0]);
            }
        }
        return val;
    }

    private boolean putString(JSONObject json, String key, String value) {
        try {
            json.put(key, (Object)value);
            return true;
        }
        catch (JSONException e) {
            return false;
        }
    }

    private long getLong(JSONObject json, String key, long def) {
        long val = def;
        if (json != null && json.has(key)) {
            try {
                val = json.getLong(key);
            }
            catch (JSONException e) {
                L.error((Object)this, e.getMessage(), new Object[0]);
            }
        }
        return val;
    }

    private boolean putLong(JSONObject json, String key, long value) {
        try {
            json.put(key, value);
            return true;
        }
        catch (JSONException e) {
            return false;
        }
    }

    private String key(String s) {
        try {
            return Coder.encryptMD5(s + KEY_MAGIC1 + KEY_MAGIC2);
        }
        catch (Throwable e) {
            L.error((Object)this, e.getMessage(), new Object[0]);
            return "";
        }
    }

    private String getSdpm(Context context) {
        boolean isWriteSetting = ArdUtil.checkPermissions(context, "android.permission.WRITE_SETTINGS");
        boolean isWrite = ArdUtil.checkPermissions(context, "android.permission.WRITE_EXTERNAL_STORAGE");
        boolean isRead = ArdUtil.checkPermissions(context, "android.permission.READ_EXTERNAL_STORAGE");
        return ((isWriteSetting ? 4 : 0) | (isRead ? 2 : 0) | (isWrite ? 1 : 0)) + "";
    }

    static {
        LOCK = FilenameFilter.class;
    }
}

