/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiidostatis.inner.util;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.SystemClock;
import java.util.HashMap;
import java.util.Map;

public class UiThreadExecutor {
    private static final Handler HANDLER = new Handler(Looper.getMainLooper()){

        public void handleMessage(Message msg) {
            Runnable callback = msg.getCallback();
            if (callback != null) {
                callback.run();
                UiThreadExecutor.decrementToken((Token)msg.obj);
            } else {
                super.handleMessage(msg);
            }
        }
    };
    private static final Map<String, Token> TOKENS = new HashMap<String, Token>();

    private UiThreadExecutor() {
    }

    public static void runTask(Runnable task) {
        UiThreadExecutor.runTask(task, 0L);
    }

    public static void runTask(Runnable task, long delay) {
        UiThreadExecutor.runTask("", task, delay);
    }

    public static void runTask(String id2, Runnable task, long delay) {
        if ("".equals(id2)) {
            HANDLER.postDelayed(task, delay);
            return;
        }
        long time = SystemClock.uptimeMillis() + delay;
        HANDLER.postAtTime(task, (Object)UiThreadExecutor.nextToken(id2), time);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Token nextToken(String id2) {
        Map<String, Token> map = TOKENS;
        synchronized (map) {
            Token token = TOKENS.get(id2);
            if (token == null) {
                token = new Token(id2);
                TOKENS.put(id2, token);
            }
            ++token.runnablesCount;
            return token;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void decrementToken(Token token) {
        Map<String, Token> map = TOKENS;
        synchronized (map) {
            String id2;
            Token old;
            if (--token.runnablesCount == 0 && (old = TOKENS.remove(id2 = token.id)) != token) {
                TOKENS.put(id2, old);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cancelAll(String id2) {
        Token token;
        Map<String, Token> map = TOKENS;
        synchronized (map) {
            token = TOKENS.remove(id2);
        }
        if (token == null) {
            return;
        }
        HANDLER.removeCallbacksAndMessages((Object)token);
    }

    private static final class Token {
        int runnablesCount = 0;
        final String id;

        private Token(String id2) {
            this.id = id2;
        }
    }
}

