/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiidostatis.inner.util;

import android.app.ActivityManager;
import android.content.Context;
import android.os.Process;
import com.yy.hiidostatis.inner.util.cipher.Coder;
import com.yy.hiidostatis.inner.util.log.L;
import java.util.List;

public final class ProcessUtil {
    private static String mCurProcessName = null;

    public static String getFileNameBindProcess(Context context, String fileName) {
        try {
            if (!ProcessUtil.isMainProcess(context)) {
                fileName = String.format("%s_%s", fileName, Coder.encryptMD5(ProcessUtil.getCurProcessName(context)).hashCode());
            }
        }
        catch (Throwable e) {
            L.error(ProcessUtil.class, "fileName[%s] instead of it,exception on getFileNameBindProcess: %s ", fileName, e);
        }
        return fileName;
    }

    public static String getCurProcessName(Context context) {
        if (mCurProcessName != null) {
            return mCurProcessName;
        }
        if (context == null) {
            return null;
        }
        try {
            int pid = Process.myPid();
            ActivityManager mActivityManager = (ActivityManager)context.getSystemService("activity");
            if (mActivityManager == null) {
                return null;
            }
            List list = mActivityManager.getRunningAppProcesses();
            if (list != null) {
                for (ActivityManager.RunningAppProcessInfo appProcess : list) {
                    if (appProcess.pid != pid) continue;
                    mCurProcessName = appProcess.processName;
                    return mCurProcessName;
                }
                Object var3_4 = null;
            }
        }
        catch (Throwable e) {
            L.error(ProcessUtil.class, "getCurProcessName exceptioon: %s", e);
        }
        return null;
    }

    public static boolean isMainProcess(Context context) {
        if (context == null) {
            return false;
        }
        try {
            String curProcessName = ProcessUtil.getCurProcessName(context);
            String processName = context.getApplicationInfo().processName;
            return processName.equals(curProcessName);
        }
        catch (Throwable e) {
            L.error(ProcessUtil.class, "isMainProcess exceptioon: %s", e);
            return false;
        }
    }

    public static boolean isBackground(Context context) {
        try {
            ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
            List appProcesses = activityManager.getRunningAppProcesses();
            String packageName = context.getPackageName();
            for (ActivityManager.RunningAppProcessInfo appProcess : appProcesses) {
                if (!appProcess.processName.equals(packageName)) continue;
                return appProcess.importance == 400;
            }
            appProcesses = null;
            return false;
        }
        catch (Throwable e) {
            L.error(ProcessUtil.class, "isBackground exceptioon: %s", e);
            return false;
        }
    }
}

