/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiidostatis.defs.obj;

import com.yy.hiidostatis.defs.obj.Elem;
import com.yy.hiidostatis.inner.util.Util;
import com.yy.hiidostatis.inner.util.log.L;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class Info<T extends Elem>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private List<T> elems = new CopyOnWriteArrayList<T>();
    private static final String DIVIDE_ELEM = "|";

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        try {
            this.elems = (List)s.readObject();
        }
        catch (Throwable e) {
            L.error(this, "Failed to read object from stream for %s", e);
            this.elems = new CopyOnWriteArrayList<T>();
        }
        if (this.elems == null) {
            L.brief("read elements is null, create an empty array list.", new Object[0]);
            this.elems = new ArrayList<T>();
        }
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.writeObject(this.elems);
    }

    public void addElem(T elem) {
        if (elem == null) {
            return;
        }
        this.elems.add(elem);
    }

    public void removeElem(T elem) {
        if (elem == null) {
            return;
        }
        this.elems.remove(elem);
    }

    public int getElemsCount() {
        return this.elems.size();
    }

    public T getElem(int index) {
        return (T)((Elem)this.elems.get(index));
    }

    public void clear() {
        this.elems.clear();
    }

    public Iterator<T> iterator() {
        return this.elems.iterator();
    }

    public void add(Info<T> added) {
        Iterator<T> iterator = added.iterator();
        while (iterator.hasNext()) {
            Elem e = (Elem)iterator.next();
            this.addElem(e);
        }
    }

    public String getResult() {
        if (Util.empty(this.elems)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (Elem e : this.elems) {
            sb.append(Util.replaceEncode(e.getStringRep(), DIVIDE_ELEM));
            sb.append(DIVIDE_ELEM);
        }
        String string = sb.toString();
        if (string.length() <= 1) {
            return string;
        }
        return string.substring(0, string.length() - 1);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (Elem e : this.elems) {
            sb.append(e.toString());
            sb.append(" ");
        }
        sb.append("]");
        return sb.toString();
    }
}

