/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiidostatis.inner.util;

import android.annotation.SuppressLint;
import android.app.ActivityManager;
import android.bluetooth.BluetoothAdapter;
import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.res.Configuration;
import android.graphics.Point;
import android.media.AudioManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.TrafficStats;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.os.Bundle;
import android.os.Environment;
import android.os.LocaleList;
import android.os.StatFs;
import android.provider.Settings;
import android.telephony.CellLocation;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.WindowManager;
import com.yy.hiidostatis.api.HiidoSDK;
import com.yy.hiidostatis.inner.util.InsideMode;
import com.yy.hiidostatis.inner.util.Util;
import com.yy.hiidostatis.inner.util.log.L;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.Socket;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ArdUtil {
    private static int mVer = -1;
    private static String mVersionName = null;
    private static String mLang;
    private static String mImsi;
    private static String mAndroidId;
    private static String mNtm;
    private static String mMacAddress;
    private static String mMacAddressV23;
    private static String mImei;
    private static String mOS;
    private static String mScreenResolution;
    private static long mTotal;
    private static String mMaxpuFreq;
    private static String mCpuName;
    private static int mCpuNum;
    private static final int NET_UNKNOWN = 0;
    private static final int NET_2G = 1;
    private static final int NET_3G = 2;
    private static final int NET_WIFI = 3;
    private static final int NET_4G = 4;
    private static String mCpuAbi;
    private static long mTotalMem;
    private static long mTotalInternalStorgeSize;
    private static long mTotalExternalStorgeSize;

    public static boolean isExistExternalStorage() {
        try {
            return Environment.getExternalStorageState().equals("mounted");
        }
        catch (Throwable e) {
            L.warn(ArdUtil.class, "isExistSdCard Exception: %s", e);
            return false;
        }
    }

    public static boolean checkPermissions(Context context, String permission2) {
        boolean result = false;
        try {
            if (Build.VERSION.SDK_INT >= 23) {
                result = context.checkSelfPermission(permission2) == 0;
            } else {
                PackageManager pm = context.getPackageManager();
                if (pm.checkPermission(permission2, context.getPackageName()) == 0) {
                    result = true;
                }
            }
        }
        catch (Throwable e) {
            L.warn(ArdUtil.class, "checkPermissions Throwable: %s", e);
        }
        return result;
    }

    public static boolean isNetworkAvailable(Context c) {
        try {
            ConnectivityManager connectivityManager = (ConnectivityManager)c.getSystemService("connectivity");
            NetworkInfo ni = null;
            if (connectivityManager != null) {
                ni = connectivityManager.getActiveNetworkInfo();
            }
            return ni != null && ni.isConnected() && ni.isAvailable();
        }
        catch (Throwable e) {
            L.warn(ArdUtil.class, "isNetworkAvailable Exception: %s", e);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isNetworkReach() {
        boolean bl;
        Socket socket = new Socket();
        try {
            socket.connect(new InetSocketAddress("www.baidu.com", 80), 5000);
            bl = socket.isConnected();
        }
        catch (Throwable e) {
            try {
                L.warn(ArdUtil.class, "isNetworkReach Exception: %s", e);
                boolean bl2 = false;
                return bl2;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                try {
                    if (socket != null) {
                        socket.close();
                    }
                }
                catch (Throwable throwable) {}
            }
        }
        try {
            if (socket == null) return bl;
            socket.close();
            return bl;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return bl;
    }

    public static boolean isWifiActive(Context c) {
        if (c == null) {
            L.warn(ArdUtil.class, "the Input context is null!", new Object[0]);
            return false;
        }
        try {
            ConnectivityManager mgr = (ConnectivityManager)c.getSystemService("connectivity");
            NetworkInfo networkInfo = null;
            if (mgr != null) {
                networkInfo = mgr.getActiveNetworkInfo();
            }
            return networkInfo != null && networkInfo.getType() == 1;
        }
        catch (Throwable e) {
            L.warn(ArdUtil.class, "isWifiActive Exception: %s", e);
            return true;
        }
    }

    public static int getVersionNo(Context c) {
        try {
            if (mVer != -1) {
                return mVer;
            }
            mVer = c.getPackageManager().getPackageInfo((String)c.getPackageName(), (int)0).versionCode;
            return mVer;
        }
        catch (Throwable e) {
            L.warn(ArdUtil.class, "Failed to read version No.", new Object[0]);
            mVer = -1;
            return -1;
        }
    }

    public static String getVersionName(Context c) {
        try {
            if (mVersionName != null) {
                return mVersionName;
            }
            mVersionName = c.getPackageManager().getPackageInfo((String)c.getPackageName(), (int)0).versionName;
            return mVersionName;
        }
        catch (Throwable e) {
            L.warn(ArdUtil.class, "Failed to read version Name.", new Object[0]);
            mVersionName = "";
            return "";
        }
    }

    public static String getPackageName(Context context) {
        try {
            return context.getPackageName();
        }
        catch (Throwable e) {
            L.warn(ArdUtil.class, "Failed to read package Name.", new Object[0]);
            return "";
        }
    }

    public static String getLang() {
        if (mLang != null) {
            return mLang;
        }
        Locale locale = null;
        if (Build.VERSION.SDK_INT >= 24) {
            try {
                locale = LocaleList.getDefault().get(0);
            }
            catch (Throwable e) {
                locale = Locale.getDefault();
            }
        } else {
            locale = Locale.getDefault();
        }
        mLang = String.format("%s-%s", locale.getLanguage(), locale.getCountry());
        return mLang;
    }

    public static String getImsi(Context c) {
        if (mImsi != null) {
            return mImsi;
        }
        try {
            if (ArdUtil.checkPermissions(c, "android.permission.READ_PHONE_STATE")) {
                TelephonyManager telManager = (TelephonyManager)c.getSystemService("phone");
                mImsi = InsideMode.safeIMSI(telManager.getSubscriberId());
            }
        }
        catch (Throwable e) {
            L.warn(ArdUtil.class, "Exception when getImsi %s", e);
        }
        return mImsi;
    }

    public static String getAndroidId(Context c) {
        try {
            if (mAndroidId != null) {
                return mAndroidId;
            }
            mAndroidId = Settings.Secure.getString((ContentResolver)c.getContentResolver(), (String)"android_id");
        }
        catch (Throwable e) {
            L.warn(ArdUtil.class, "Exception when getAndroidId %s", e);
        }
        return mAndroidId;
    }

    public static String getNtm(Context c) {
        if (mNtm != null) {
            return mNtm;
        }
        String sim = null;
        try {
            TelephonyManager tm = (TelephonyManager)c.getSystemService("phone");
            if (tm != null && !Util.empty(sim = tm.getSimOperator())) {
                String[] s = sim.split(",");
                if (s.length > 0 && !Util.empty(s[0])) {
                    sim = s[0];
                } else if (s.length == 2 && !Util.empty(s[1])) {
                    sim = s[1];
                }
                if (sim.length() == 5 || sim.length() == 6) {
                    sim = String.format("%s:%s", sim.substring(0, 3), sim.substring(3));
                }
            }
        }
        catch (Throwable e) {
            L.warn(ArdUtil.class, "Exception when getNtm %s", e);
        }
        mNtm = sim;
        return mNtm;
    }

    public static String getMacAddr(Context c) {
        if (mMacAddress != null) {
            return mMacAddress;
        }
        try {
            WifiManager wifiMgr = (WifiManager)c.getSystemService("wifi");
            if (wifiMgr != null) {
                WifiInfo connectionInfo = wifiMgr.getConnectionInfo();
                mMacAddress = connectionInfo == null ? null : connectionInfo.getMacAddress();
            }
        }
        catch (Throwable e) {
            L.warn(ArdUtil.class, "exception on getMacAddr : %s", e);
        }
        return mMacAddress;
    }

    public static String getMacAddrV23(Context c) {
        String mac2;
        if (ArdUtil.isValidMac(mMacAddressV23)) {
            return mMacAddressV23;
        }
        mMacAddressV23 = ArdUtil.getMacAddr(c);
        if (!ArdUtil.isValidMac(mMacAddressV23) && ArdUtil.isValidMac(mac2 = ArdUtil.getMacAddr2())) {
            mMacAddressV23 = mac2;
        }
        return mMacAddressV23;
    }

    public static String getSafeMacAddr(Context c) {
        String mac = ArdUtil.getMacAddrV23(c);
        if (ArdUtil.isValidMac(mac)) {
            return InsideMode.safeMac(mac);
        }
        return null;
    }

    public static boolean isValidMac(String mac) {
        return !TextUtils.isEmpty((CharSequence)mac) && !mac.equalsIgnoreCase("02:00:00:00:00:00");
    }

    @SuppressLint(value={"NewApi"})
    private static String getMacAddr2() {
        String address = null;
        try {
            if (Build.VERSION.SDK_INT >= 9) {
                Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
                while (interfaces.hasMoreElements()) {
                    String mac;
                    byte[] by;
                    NetworkInterface netWork = interfaces.nextElement();
                    if (!netWork.getName().equalsIgnoreCase("wlan0") || (by = netWork.getHardwareAddress()) == null || by.length == 0) continue;
                    StringBuilder builder = new StringBuilder();
                    for (byte b : by) {
                        builder.append(String.format("%02X:", b));
                    }
                    if (builder.length() > 0) {
                        builder.deleteCharAt(builder.length() - 1);
                    }
                    address = mac = builder.toString();
                }
            }
        }
        catch (Throwable e) {
            L.warn(ArdUtil.class, "exception on getMacAddr2 : %s", e);
        }
        return address;
    }

    public static String getImei(Context c) {
        if (mImei != null) {
            return mImei;
        }
        try {
            TelephonyManager manager;
            if (!HiidoSDK.instance().getOptions().isGp && ArdUtil.checkPermissions(c, "android.permission.READ_PHONE_STATE") && (manager = (TelephonyManager)c.getSystemService("phone")) != null) {
                mImei = InsideMode.safeIMEI(manager.getDeviceId());
                return mImei;
            }
        }
        catch (Throwable e) {
            L.warn(ArdUtil.class, "exception on getIMEI : %s", e);
        }
        return null;
    }

    public static String getSjp(Context c) {
        return Build.MANUFACTURER;
    }

    public static String getSjm(Context c) {
        return Build.MODEL;
    }

    public static String getOS() {
        if (mOS != null) {
            return mOS;
        }
        mOS = String.format("Android%s", Build.VERSION.RELEASE);
        return mOS;
    }

    public static String getScreenResolution(Context c) {
        if (mScreenResolution != null) {
            return mScreenResolution;
        }
        try {
            WindowManager wm = (WindowManager)c.getSystemService("window");
            if (wm == null) {
                mScreenResolution = "";
                return mScreenResolution;
            }
            Point ret = new Point();
            Display defaultDisplay = wm.getDefaultDisplay();
            if (Build.VERSION.SDK_INT >= 17) {
                DisplayMetrics metrics = new DisplayMetrics();
                defaultDisplay.getRealMetrics(metrics);
                mScreenResolution = metrics.widthPixels + "x" + metrics.heightPixels;
            } else {
                mScreenResolution = defaultDisplay.getWidth() + "x" + defaultDisplay.getHeight();
            }
        }
        catch (Throwable e) {
            L.warn(ArdUtil.class, "exception on getScreenResolution info: %s", e);
        }
        return mScreenResolution;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getTotalMemory() {
        if (mTotal != 0L) {
            return mTotal;
        }
        String path = "/proc/meminfo";
        String content = null;
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader(path), 8);
            String line = br.readLine();
            if (line != null) {
                content = line;
            }
            if (!Util.empty(content)) {
                int begin = content.indexOf(58);
                int end = content.indexOf(107);
                content = content.substring(begin + 1, end).trim();
                mTotal = Long.parseLong(content.trim());
            }
        }
        catch (Throwable e) {
            L.warn(ArdUtil.class, "getTotalMemory exception: %s", e);
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException line) {}
            }
        }
        return mTotal;
    }

    public static String getMaxCpuFreq() {
        if (!TextUtils.isEmpty((CharSequence)mMaxpuFreq)) {
            return mMaxpuFreq;
        }
        StringBuilder result = new StringBuilder("");
        try {
            FileInputStream in = new FileInputStream("/sys/devices/system/cpu/cpu0/cpufreq/cpuinfo_max_freq");
            byte[] re = new byte[24];
            while (((InputStream)in).read(re) != -1) {
                result.append(new String(re));
            }
            ((InputStream)in).close();
            in = null;
        }
        catch (Throwable e) {
            L.warn(ArdUtil.class, "getMaxCpuFreq exception: %s", e);
        }
        mMaxpuFreq = result.toString().trim();
        return mMaxpuFreq;
    }

    public static String getCpuName() {
        if (!TextUtils.isEmpty((CharSequence)mCpuName)) {
            return mCpuName;
        }
        try {
            FileReader fr = new FileReader("/proc/cpuinfo");
            BufferedReader br = new BufferedReader(fr);
            String text = br.readLine();
            String[] array = text.split(":\\s+", 2);
            br.close();
            br = null;
            mCpuName = array[1];
            return mCpuName;
        }
        catch (Throwable e) {
            L.warn(ArdUtil.class, "getCpuName exception: %s", e);
            return null;
        }
    }

    public static int getCpuNum() {
        if (mCpuNum != 0) {
            return mCpuNum;
        }
        try {
            File dir = new File("/sys/devices/system/cpu/");
            class CpuFilter
            implements FileFilter {
                CpuFilter() {
                }

                @Override
                public boolean accept(File pathname) {
                    return Pattern.matches("cpu[0-9]", pathname.getName());
                }
            }
            File[] files = dir.listFiles(new CpuFilter());
            mCpuNum = files.length;
            return mCpuNum;
        }
        catch (Throwable e) {
            L.warn(ArdUtil.class, "getCpuNum exception: %s", e);
            mCpuNum = 1;
            return 1;
        }
    }

    public static int getNetworkType(Context c) {
        NetworkInfo netInfo = null;
        try {
            ConnectivityManager cm = (ConnectivityManager)c.getSystemService("connectivity");
            netInfo = cm.getActiveNetworkInfo();
        }
        catch (Throwable e) {
            L.warn(ArdUtil.class, "exception on get network info: %s", e);
            return 0;
        }
        if (netInfo == null) {
            return 0;
        }
        int type = netInfo.getType();
        if (type == 1) {
            return 3;
        }
        if (type == 0) {
            int subType = netInfo.getSubtype();
            if (subType == 7 || subType == 3 || subType == 5 || subType == 6 || subType == 8 || subType == 10 || subType == 9) {
                return 2;
            }
            return subType >= 12 && subType <= 15 ? 4 : 1;
        }
        return 0;
    }

    public static int getNetworkTypeNew(Context c) {
        NetworkInfo netInfo = null;
        try {
            ConnectivityManager cm = (ConnectivityManager)c.getSystemService("connectivity");
            netInfo = cm.getActiveNetworkInfo();
        }
        catch (Throwable e) {
            L.warn(ArdUtil.class, "exception on get network info: %s", e);
            return 0;
        }
        if (netInfo == null) {
            return 0;
        }
        int type = netInfo.getType();
        if (type == 1) {
            return 3;
        }
        if (type == 0) {
            int subType = netInfo.getSubtype();
            switch (subType) {
                case 1: 
                case 2: 
                case 4: 
                case 7: 
                case 11: 
                case 16: {
                    return 1;
                }
                case 3: 
                case 5: 
                case 6: 
                case 8: 
                case 9: 
                case 10: 
                case 12: 
                case 14: 
                case 15: 
                case 17: 
                case 18: {
                    return 2;
                }
                case 13: {
                    return 4;
                }
            }
            return 0;
        }
        return 0;
    }

    public static String getMetaDataParam(Context context, String key) {
        if (context == null || Util.empty(key)) {
            return "";
        }
        try {
            Object obj;
            Bundle b;
            PackageManager localPackageManager = context.getPackageManager();
            ApplicationInfo localApplicationInfo = localPackageManager.getApplicationInfo(context.getPackageName(), 128);
            if (localApplicationInfo != null && (b = localApplicationInfo.metaData) != null && (obj = b.get(key)) != null) {
                L.debug(ArdUtil.class, "meta data key[%s] value is %s", key, obj);
                return obj + "";
            }
        }
        catch (Throwable localException) {
            L.warn(ArdUtil.class, "read meta-data key[%s] from AndroidManifest.xml Exception.%s", key, localException);
        }
        return "";
    }

    public static String getWifiName(Context context) {
        try {
            WifiManager wifiMgr = (WifiManager)context.getSystemService("wifi");
            WifiInfo info = wifiMgr.getConnectionInfo();
            return info != null ? info.getSSID() : null;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static int getCurrAppUid(Context context) {
        int uid = -1;
        try {
            PackageManager pm = context.getPackageManager();
            List infos = pm.getInstalledApplications(0);
            for (ApplicationInfo info : infos) {
                if (!info.packageName.equals(context.getPackageName())) continue;
                uid = info.uid;
                break;
            }
        }
        catch (Throwable e) {
            L.warn(ArdUtil.class, "getCurrAppUid exception: %s", e);
        }
        return uid;
    }

    @SuppressLint(value={"NewApi"})
    public static long getTotalTxBytes() {
        if (Build.VERSION.SDK_INT >= 8) {
            return TrafficStats.getTotalTxBytes();
        }
        return 0L;
    }

    @SuppressLint(value={"NewApi"})
    public static long getTotalRxBytes() {
        if (Build.VERSION.SDK_INT >= 8) {
            return TrafficStats.getTotalRxBytes();
        }
        return 0L;
    }

    @SuppressLint(value={"NewApi"})
    public static long getUidTxBytes(int uid) {
        if (Build.VERSION.SDK_INT >= 8) {
            return TrafficStats.getUidTxBytes((int)uid);
        }
        return 0L;
    }

    @SuppressLint(value={"NewApi"})
    public static long getUidRxBytes(int uid) {
        if (Build.VERSION.SDK_INT >= 8) {
            return TrafficStats.getUidRxBytes((int)uid);
        }
        return 0L;
    }

    public static boolean isRoot() {
        String binPath = "/system/bin/su";
        String xBinPath = "/system/xbin/su";
        return new File(binPath).exists() || new File(xBinPath).exists();
    }

    public static WifiInfo getWifiInfo(Context context) {
        WifiInfo wi = null;
        try {
            WifiManager wifiManager = (WifiManager)context.getSystemService("wifi");
            if (wifiManager != null) {
                wi = wifiManager.getConnectionInfo();
            }
        }
        catch (Throwable e) {
            L.warn(ArdUtil.class, "getWifiInfo exception . %s", e);
        }
        return wi;
    }

    public static CellLocation getCellId(Context context) {
        CellLocation c = null;
        try {
            TelephonyManager tm = (TelephonyManager)context.getSystemService("phone");
            c = tm.getCellLocation();
        }
        catch (Throwable e) {
            L.warn(ArdUtil.class, "getCellId exception . %s", e);
        }
        return c;
    }

    public static int getScreenBrightness(Context context) {
        int value = 0;
        try {
            ContentResolver cr = context.getContentResolver();
            value = Settings.System.getInt((ContentResolver)cr, (String)"screen_brightness");
        }
        catch (Throwable e) {
            L.warn(ArdUtil.class, "getScreenBrightness exception . %s", e);
        }
        return value;
    }

    public static boolean isDebugEnable(Context context) {
        return Settings.Secure.getInt((ContentResolver)context.getContentResolver(), (String)"adb_enabled", (int)0) > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getCpuAbi() {
        if (!TextUtils.isEmpty((CharSequence)mCpuAbi)) {
            return mCpuAbi;
        }
        if (Build.VERSION.SDK_INT < 21) {
            mCpuAbi = Build.CPU_ABI;
            return mCpuAbi;
        }
        BufferedReader br = null;
        FileReader fr = null;
        try {
            String str2;
            fr = new FileReader("/proc/cpuinfo");
            br = new BufferedReader(fr);
            String str1 = br.readLine();
            String[] localObject1 = str1.split(":\\s+", 2);
            String string = mCpuAbi = (str2 = localObject1[1]);
            return string;
        }
        catch (Throwable e) {
            L.warn(ArdUtil.class, "getCpuAbi exception . %s", e);
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
                if (fr != null) {
                    fr.close();
                }
            }
            catch (IOException iOException) {}
        }
        return null;
    }

    public static boolean isHeadphone(Context c) {
        try {
            if (ArdUtil.checkPermissions(c, "android.permission.MODIFY_AUDIO_SETTINGS")) {
                AudioManager localAudioManager = (AudioManager)c.getSystemService("audio");
                return localAudioManager.isWiredHeadsetOn();
            }
        }
        catch (Throwable e) {
            L.warn(ArdUtil.class, "isHeadphone exception . %s", e);
        }
        return false;
    }

    public static int getDeviceOrientation(Context c) {
        try {
            Configuration localConfiguration = c.getResources().getConfiguration();
            int i = localConfiguration.orientation;
            if (i == 2) {
                return 1;
            }
            if (i == 1) {
                return 0;
            }
        }
        catch (Throwable e) {
            L.warn(ArdUtil.class, "getDeviceOrientation exception . %s", e);
        }
        return 0;
    }

    public static String getTimeZone() {
        int i = TimeZone.getDefault().getRawOffset();
        int j = i / 60000;
        char c1 = '+';
        if (j < 0) {
            c1 = '-';
            j = -j;
        }
        return "GMT" + c1 + j / 60;
    }

    public static String getCellIp() {
        try {
            Enumeration<NetworkInterface> localEnumeration1 = NetworkInterface.getNetworkInterfaces();
            while (localEnumeration1.hasMoreElements()) {
                NetworkInterface localNetworkInterface = localEnumeration1.nextElement();
                Enumeration<InetAddress> localEnumeration2 = localNetworkInterface.getInetAddresses();
                while (localEnumeration2.hasMoreElements()) {
                    InetAddress localInetAddress = localEnumeration2.nextElement();
                    if (localInetAddress.isLoopbackAddress()) continue;
                    return localInetAddress.getHostAddress();
                }
            }
        }
        catch (Throwable e) {
            L.warn(ArdUtil.class, "getCellIp exception . %s", e);
        }
        return null;
    }

    @SuppressLint(value={"NewApi"})
    public static long getTotalMemory(Context context) {
        if (mTotalMem != 0L) {
            return mTotalMem;
        }
        if (Build.VERSION.SDK_INT >= 16 && context != null) {
            try {
                ActivityManager.MemoryInfo mem = new ActivityManager.MemoryInfo();
                ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
                activityManager.getMemoryInfo(mem);
                mTotalMem = mem.totalMem / 1024L;
            }
            catch (Throwable e) {
                L.warn(ArdUtil.class, "getTotalMemory exception . %s", e);
                mTotalMem = ArdUtil.getTotalMemory();
            }
        } else {
            mTotalMem = ArdUtil.getTotalMemory();
        }
        return mTotalMem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long getTotalMemoryFromFile() {
        RandomAccessFile reader = null;
        long totalMem = 0L;
        try {
            reader = new RandomAccessFile("/proc/meminfo", "r");
            String load = reader.readLine();
            Pattern p = Pattern.compile("(\\d+)");
            Matcher m = p.matcher(load);
            String value = "";
            while (m.find()) {
                value = m.group(1);
            }
            totalMem = Long.parseLong(value);
        }
        catch (Throwable e) {
            L.warn(ArdUtil.class, "getTotalMemoryFromFile exception . %s", e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Throwable load) {}
            }
        }
        return totalMem;
    }

    public static long getAvailMemory(Context context) {
        long availMem = 0L;
        try {
            ActivityManager.MemoryInfo mem = new ActivityManager.MemoryInfo();
            ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
            activityManager.getMemoryInfo(mem);
            availMem = mem.availMem / 1024L;
        }
        catch (Throwable e) {
            L.warn(ArdUtil.class, "getAvailMemory exception . %s", e);
        }
        return availMem;
    }

    public static long getTotalInternalStorgeSize() {
        if (mTotalInternalStorgeSize != 0L) {
            return mTotalInternalStorgeSize;
        }
        try {
            File path = Environment.getDataDirectory();
            StatFs mStatFs = new StatFs(path.getPath());
            long blockSize = mStatFs.getBlockSize();
            long totalBlocks = mStatFs.getBlockCount();
            mTotalInternalStorgeSize = totalBlocks * blockSize / 1024L;
        }
        catch (Throwable e) {
            L.warn(ArdUtil.class, "getTotalInternalStorgeSize exception . %s", e);
        }
        return mTotalInternalStorgeSize;
    }

    public static long getAvailInternalStorgeSize() {
        long ailSize = 0L;
        try {
            File path = Environment.getDataDirectory();
            StatFs mStatFs = new StatFs(path.getPath());
            long blockSize = mStatFs.getBlockSize();
            long availableBlocks = mStatFs.getAvailableBlocks();
            ailSize = availableBlocks * blockSize / 1024L;
        }
        catch (Throwable e) {
            L.warn(ArdUtil.class, "getAvailInternalStorgeSize exception . %s", e);
        }
        return ailSize;
    }

    public static long getTotalExternalStorgeSize() {
        if (mTotalExternalStorgeSize != 0L) {
            return mTotalExternalStorgeSize;
        }
        try {
            if (Environment.getExternalStorageState().equals("mounted")) {
                File path = Environment.getExternalStorageDirectory();
                StatFs mStatFs = new StatFs(path.getPath());
                long blockSize = mStatFs.getBlockSize();
                long totalBlocks = mStatFs.getBlockCount();
                mTotalExternalStorgeSize = totalBlocks * blockSize / 1024L;
            } else {
                mTotalExternalStorgeSize = 0L;
            }
        }
        catch (Throwable e) {
            L.warn(ArdUtil.class, "getTotalExternalStorgeSize exception . %s", e);
        }
        return mTotalExternalStorgeSize;
    }

    public static long getAvailExternalStorgeSize() {
        long telSize = 0L;
        try {
            if (Environment.getExternalStorageState().equals("mounted")) {
                File path = Environment.getExternalStorageDirectory();
                StatFs mStatFs = new StatFs(path.getPath());
                long blockSize = mStatFs.getBlockSize();
                long availableBlocks = mStatFs.getAvailableBlocks();
                return availableBlocks * blockSize / 1024L;
            }
            return 0L;
        }
        catch (Throwable e) {
            L.warn(ArdUtil.class, "getAvailExternalStorgeSize exception . %s", e);
            return telSize;
        }
    }

    public static int getVolume(Context context, int type) {
        try {
            AudioManager mAudioManager = (AudioManager)context.getSystemService("audio");
            return mAudioManager.getStreamVolume(type);
        }
        catch (Throwable e) {
            L.warn(ArdUtil.class, "getVolume exception . %s", e);
            return -1;
        }
    }

    public static String getSceneMode(Context context) {
        String str = "";
        try {
            AudioManager localAudioManager = (AudioManager)context.getSystemService("audio");
            int i = -1;
            if (localAudioManager != null) {
                i = localAudioManager.getRingerMode();
            }
            switch (i) {
                case 0: {
                    str = "silent";
                    break;
                }
                case 1: {
                    str = "vibrate";
                    break;
                }
                case 2: {
                    str = "normal";
                }
            }
        }
        catch (Throwable e) {
            L.warn(ArdUtil.class, "getSceneMode exception . %s", e);
        }
        return str;
    }

    public static String getBluetoothMac(Context context) {
        BluetoothAdapter localBluetoothAdapter = null;
        try {
            if (ArdUtil.checkPermissions(context, "android.permission.BLUETOOTH")) {
                localBluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
                return localBluetoothAdapter != null ? localBluetoothAdapter.getAddress() : "";
            }
        }
        catch (Throwable e) {
            L.warn(ArdUtil.class, "getBluetoothMac exception . %s", e);
        }
        return "";
    }

    public static int getAvailableProcessors() {
        try {
            return Runtime.getRuntime().availableProcessors();
        }
        catch (Throwable e) {
            L.warn(ArdUtil.class, "getAvailableProcessors exception . %s", e);
            return -1;
        }
    }

    static {
        mAndroidId = null;
        mMacAddress = null;
        mMacAddressV23 = null;
        mImei = null;
        mOS = null;
        mScreenResolution = null;
        mTotal = 0L;
        mMaxpuFreq = null;
        mCpuNum = 0;
        mCpuAbi = null;
        mTotalMem = 0L;
        mTotalInternalStorgeSize = 0L;
        mTotalExternalStorgeSize = 0L;
    }
}

