/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiidostatis.defs.handler;

import android.content.Context;
import com.yy.hiidostatis.defs.interf.IOnStatisListener;
import com.yy.hiidostatis.defs.interf.IStatisAPI;
import com.yy.hiidostatis.inner.util.FileUtil;
import com.yy.hiidostatis.inner.util.ThreadPool;
import com.yy.hiidostatis.inner.util.log.L;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.UUID;

public class CrashHandler
implements Thread.UncaughtExceptionHandler {
    private static Thread.UncaughtExceptionHandler mDefaultHandler;
    private static IStatisAPI mStatisAPI;
    private static IOnStatisListener mOnStatisListener;
    private static OnHandlerListener mOnHandlerListener;
    private static Context mContext;

    public CrashHandler(Context context, IStatisAPI statisAPI, IOnStatisListener onStatisListener, OnHandlerListener onHandlerListener) {
        mContext = context;
        mStatisAPI = statisAPI;
        mOnStatisListener = onStatisListener;
        mOnHandlerListener = onHandlerListener;
    }

    public void init() {
        mDefaultHandler = Thread.getDefaultUncaughtExceptionHandler();
        String old = "null";
        if (mDefaultHandler != null) {
            old = mDefaultHandler.getClass().getSimpleName();
        }
        L.debug(this, "old DefaultUncaughtExceptionHandler is %s,new DefaultUncaughtExceptionHandler is %s", old, this.getClass().getSimpleName());
        Thread.setDefaultUncaughtExceptionHandler(this);
        L.infoOn(this, "init java crash handler", new Object[0]);
        if (this.loadLibrary()) {
            try {
                this.initNativeHandler(this.getDmpPath());
                L.infoOn(this, "init native crash handler", new Object[0]);
            }
            catch (Throwable e) {
                L.warnOn(this, "initNativeHandler error:%e", e);
            }
        }
    }

    @Override
    public void uncaughtException(Thread thread, Throwable ex) {
        try {
            this.handleException(ex);
            Thread.sleep(800L);
        }
        catch (Throwable e) {
            L.error(this, "deal crash uncaughtException happen another exception=%s", e);
        }
        if (mDefaultHandler != null) {
            mDefaultHandler.uncaughtException(thread, ex);
        }
    }

    private void handleException(Throwable ex) {
        final Throwable t = ex;
        Thread r = new Thread(){

            @Override
            public void run() {
                mStatisAPI.reportCrashInner(mOnStatisListener.getCurrentUid(), t);
            }
        };
        ThreadPool.getPool().execute(r);
    }

    public boolean loadLibrary() {
        boolean isLoad = false;
        try {
            System.loadLibrary("hiidostatisjni");
            isLoad = true;
        }
        catch (Throwable e) {
            L.warnOn(this, "loadLibrary failure. %s", e);
        }
        return isLoad;
    }

    public String getDmpPath() {
        String path = mContext.getFilesDir().getAbsolutePath() + File.separator + "hdsdkDump";
        File file = new File(path);
        if (!file.exists()) {
            file.mkdirs();
        }
        return path;
    }

    private void dealJavaException(Throwable ex) {
        String dmpFilePath = this.getDmpPath() + File.separator + "J-" + UUID.randomUUID().toString() + ".dmp";
        FileUtil.writeFile(dmpFilePath, CrashHandler.getStackTrace(ex));
        CrashHandler.crashCallBack(1, dmpFilePath);
    }

    public static void crashCallBack(int crashType, String dmpFilePath) {
        L.warnOn(CrashHandler.class, "%s crash occur.", crashType == 1 ? "java" : "native");
        String logFilePath = dmpFilePath.replace(".dmp", ".log");
        L.brief("crashCallBack,dmpFilePath=%s,logFilePath=%s", dmpFilePath, logFilePath);
        FileUtil.writeFile(logFilePath, CrashHandler.generateCrashLog());
        if (mOnHandlerListener != null) {
            mOnHandlerListener.handler(crashType, dmpFilePath, logFilePath);
        }
    }

    private static String getStackTrace(Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        return sw.toString();
    }

    private static String generateCrashLog() {
        try {
            StringBuffer tmpMsg = new StringBuffer();
            tmpMsg.append("LOGCAT STACK:\n");
            Process process = Runtime.getRuntime().exec(new String[]{"logcat", "-v", "threadtime", "-t", "500", "-d", "*:V"});
            InputStreamReader ios = new InputStreamReader(process.getInputStream());
            BufferedReader bufferedReader = new BufferedReader(ios, 1024);
            String line = null;
            while ((line = bufferedReader.readLine()) != null) {
                if (line.contains(L.getTag())) continue;
                tmpMsg.append(line).append("\n");
            }
            bufferedReader.close();
            return tmpMsg.toString();
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    private static String getCurrentStack() {
        StackTraceElement[] traceElements;
        StringBuilder ret = new StringBuilder("");
        Throwable th = new Throwable("");
        for (StackTraceElement element : traceElements = th.getStackTrace()) {
            ret.append(element.toString()).append("\n");
        }
        return ret.toString();
    }

    public native int initNativeHandler(String var1);

    public static native void testNativeCrash();

    public static native void testNativeCrashThread();

    public static void testJavaCrash() {
        int i = 0;
        int d = 10 / i;
        System.out.println(d);
    }

    public static interface OnHandlerListener {
        public void handler(int var1, String var2, String var3);
    }
}

