/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiidostatis.defs.controller;

import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorListener;
import android.hardware.SensorManager;
import android.os.Build;
import com.yy.hiidostatis.api.StatisContent;
import com.yy.hiidostatis.inner.util.DefaultPreference;
import java.util.LinkedList;
import java.util.List;

public class SensorController
implements SensorEventListener,
SensorListener {
    private static final int CACHE_LENGTH = 10;
    private static final int CACHE_HEAD_LENGTH = 5;
    private static final String KEY_GYRO = "gyro";
    private static final String KEY_ACCEL = "accel";
    private static final String KEY_LIGHT = "light";
    private static final String KEY_BATLV = "batlv";
    private float gyroscopeThreshold;
    private float accelerometerThreshold;
    private float lightThreshold;
    private int countGvroscope;
    private int countAccelerometer;
    private int countLight;
    private LinkedList<SensorRecord> gyroscopeCache = new LinkedList();
    private LinkedList<SensorRecord> accelerometerCache = new LinkedList();
    private LinkedList<SensorRecord> lightCache = new LinkedList();
    private Sensor gyroscope;
    private Sensor accelerometer;
    private Sensor light;
    private boolean register;
    private BatteryInfo initiateBattery;
    private BatteryInfo endBattery;
    private SensorManager sensorManager;
    private final boolean enable;

    public SensorController(Context context, float gyroscopeThreshold, float accelerometerThreshold, float lightThreshold, boolean enable) {
        this.gyroscopeThreshold = gyroscopeThreshold;
        this.accelerometerThreshold = accelerometerThreshold;
        this.lightThreshold = lightThreshold;
        this.enable = enable;
        if (!enable) {
            return;
        }
        try {
            this.sensorManager = (SensorManager)context.getSystemService("sensor");
            this.gyroscope = this.sensorManager.getDefaultSensor(4);
            this.accelerometer = this.sensorManager.getDefaultSensor(1);
            this.light = this.sensorManager.getDefaultSensor(5);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void onStart(Context context) {
        if (!this.enable) {
            return;
        }
        if (this.initiateBattery == null) {
            this.initiateBattery = BatteryInfo.getCurrentBatttery(context);
        }
        this.register(context);
    }

    private void register(Context context) {
        if (this.register) {
            return;
        }
        if (this.gyroscope != null) {
            if (Build.VERSION.SDK_INT >= 24) {
                this.sensorManager.registerListener((SensorEventListener)this, this.gyroscope, 3);
            } else {
                this.sensorManager.registerListener((SensorListener)this, 4, 3);
            }
            this.register = true;
        }
        if (this.accelerometer != null) {
            if (Build.VERSION.SDK_INT >= 24) {
                this.sensorManager.registerListener((SensorEventListener)this, this.accelerometer, 3);
            } else {
                this.sensorManager.registerListener((SensorListener)this, 1, 3);
            }
            this.register = true;
        }
        if (this.light != null) {
            if (Build.VERSION.SDK_INT >= 24) {
                this.sensorManager.registerListener((SensorEventListener)this, this.light, 3);
            } else {
                this.sensorManager.registerListener((SensorListener)this, 5);
            }
            this.register = true;
        }
    }

    private void unregister(Context context) {
        if (this.register) {
            if (Build.VERSION.SDK_INT >= 24) {
                this.sensorManager.unregisterListener((SensorEventListener)this, this.gyroscope);
                this.sensorManager.unregisterListener((SensorEventListener)this, this.accelerometer);
                this.sensorManager.unregisterListener((SensorEventListener)this, this.light);
            } else {
                this.sensorManager.unregisterListener((SensorListener)this, 2);
                this.sensorManager.unregisterListener((SensorListener)this, 16);
                this.sensorManager.unregisterListener((SensorListener)this, 127);
            }
            this.register = false;
        }
    }

    public void onStop(Context context) {
        if (!this.enable) {
            return;
        }
        this.unregister(context);
        this.endBattery = BatteryInfo.getCurrentBatttery(context);
        this.save(context);
    }

    private void valueChanged(int sensor, float[] values) {
        switch (sensor) {
            case 4: {
                if (this.gyroscopeCache.isEmpty()) {
                    this.gyroscopeCache.add(new SensorRecord(SensorController.copyFloatArray(values), System.currentTimeMillis()));
                    ++this.countGvroscope;
                    break;
                }
                boolean b = this.compareFloats(this.gyroscopeCache.getLast().value, values, this.gyroscopeThreshold);
                if (!b) break;
                this.addCache(values, this.gyroscopeCache);
                ++this.countGvroscope;
                break;
            }
            case 1: {
                if (this.accelerometerCache.isEmpty()) {
                    this.accelerometerCache.add(new SensorRecord(SensorController.copyFloatArray(values), System.currentTimeMillis()));
                    ++this.countAccelerometer;
                    break;
                }
                boolean b = this.compareFloats(this.accelerometerCache.getLast().value, values, this.accelerometerThreshold);
                if (!b) break;
                this.addCache(values, this.accelerometerCache);
                ++this.countAccelerometer;
                break;
            }
            case 5: {
                if (this.lightCache.isEmpty()) {
                    this.lightCache.add(new SensorRecord(SensorController.copyFloatArray(values), System.currentTimeMillis()));
                    ++this.countLight;
                    break;
                }
                boolean b = this.compareFloats(this.lightCache.getLast().value, values, this.lightThreshold);
                if (!b) break;
                this.addCache(values, this.lightCache);
                ++this.countLight;
                break;
            }
        }
    }

    private boolean compareFloats(float[] one, float[] two, float threshold) {
        if (one.length != two.length) {
            return true;
        }
        boolean w = false;
        for (int i = 0; i < one.length; ++i) {
            if (threshold > 0.0f) {
                if (!(Math.abs(one[i] - two[i]) > threshold)) continue;
                w = true;
                break;
            }
            if (one[i] != 0.0f) {
                if (!(Math.abs(two[i] - one[i]) * 100.0f / Math.abs(one[i]) > -threshold)) continue;
                w = true;
                break;
            }
            if (two[i] == 0.0f) continue;
            w = true;
            break;
        }
        return w;
    }

    private void addCache(float[] b, LinkedList<SensorRecord> cache) {
        if (cache.size() < 10) {
            cache.add(new SensorRecord(SensorController.copyFloatArray(b), System.currentTimeMillis()));
        } else {
            SensorRecord one = cache.remove(5);
            one.value = SensorController.copyFloatArray(b);
            one.time = System.currentTimeMillis();
            cache.add(one);
            while (cache.size() > 10) {
                cache.remove(5);
            }
        }
    }

    private static float[] copyFloatArray(float[] b) {
        float[] ret = new float[b.length];
        System.arraycopy(b, 0, ret, 0, b.length);
        return ret;
    }

    public void onSensorChanged(SensorEvent event) {
        if (!this.enable) {
            return;
        }
        try {
            this.valueChanged(event.sensor.getType(), event.values);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void onAccuracyChanged(Sensor sensor, int accuracy) {
    }

    private void save(Context context) {
        try {
            StatisContent content = this.toParams();
            String g = content.get(KEY_GYRO);
            String a = content.get(KEY_ACCEL);
            String l = content.get(KEY_LIGHT);
            String b = content.get(KEY_BATLV);
            if (g != null && !g.isEmpty()) {
                DefaultPreference.getPreference().setPrefString(context, "SENSOR_gyro", g);
            }
            if (a != null && !a.isEmpty()) {
                DefaultPreference.getPreference().setPrefString(context, "SENSOR_accel", a);
            }
            if (l != null && !l.isEmpty()) {
                DefaultPreference.getPreference().setPrefString(context, "SENSOR_light", l);
            }
            if (b != null && !b.isEmpty()) {
                DefaultPreference.getPreference().setPrefString(context, "SENSOR_batlv", b);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void reset(Context context) {
        if (!this.enable) {
            return;
        }
        this.countLight = 0;
        this.countAccelerometer = 0;
        this.countGvroscope = 0;
        this.gyroscopeCache.clear();
        this.accelerometerCache.clear();
        this.lightCache.clear();
        this.initiateBattery = BatteryInfo.getCurrentBatttery(context);
        this.endBattery = null;
    }

    public static StatisContent loadFileAndClear(Context context) {
        StatisContent content = new StatisContent();
        try {
            String g = DefaultPreference.getPreference().getPrefString(context, "SENSOR_gyro", null);
            String a = DefaultPreference.getPreference().getPrefString(context, "SENSOR_accel", null);
            String l = DefaultPreference.getPreference().getPrefString(context, "SENSOR_light", null);
            String b = DefaultPreference.getPreference().getPrefString(context, "SENSOR_batlv", null);
            if (g != null && !g.isEmpty()) {
                content.put(KEY_GYRO, g);
            }
            if (a != null && !a.isEmpty()) {
                content.put(KEY_ACCEL, a);
            }
            if (l != null && !l.isEmpty()) {
                content.put(KEY_LIGHT, l);
            }
            if (b != null && !b.isEmpty()) {
                content.put(KEY_BATLV, b);
            }
            DefaultPreference.getPreference().clearKey(context, "SENSOR_gyro");
            DefaultPreference.getPreference().clearKey(context, "SENSOR_accel");
            DefaultPreference.getPreference().clearKey(context, "SENSOR_light");
            DefaultPreference.getPreference().clearKey(context, "SENSOR_batlv");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return content;
    }

    public void onSensorChanged(int sensor, float[] values) {
        if (!this.enable) {
            return;
        }
        try {
            this.valueChanged(sensor, values);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void onAccuracyChanged(int sensor, int accuracy) {
    }

    private void recordToString(int count, List<SensorRecord> records, StringBuilder out) {
        out.append(count);
        if (count > 0) {
            out.append("|");
            for (SensorRecord r : records) {
                for (float f : r.value) {
                    out.append(f);
                    out.append(',');
                }
                out.append(r.time);
                out.append(':');
            }
            out.setLength(out.length() - 1);
        }
    }

    private StatisContent toParams() {
        StatisContent content = new StatisContent();
        StringBuilder sb = new StringBuilder();
        this.recordToString(this.countGvroscope, this.gyroscopeCache, sb);
        content.put(KEY_GYRO, sb.toString());
        sb.setLength(0);
        this.recordToString(this.countAccelerometer, this.accelerometerCache, sb);
        content.put(KEY_ACCEL, sb.toString());
        sb.setLength(0);
        this.recordToString(this.countLight, this.lightCache, sb);
        content.put(KEY_LIGHT, sb.toString());
        if (this.initiateBattery != null && this.endBattery != null) {
            content.put(KEY_BATLV, this.initiateBattery.toString() + "|" + this.endBattery.toString());
        }
        return content;
    }

    private static class BatteryInfo {
        public int status;
        int level;
        private float pecent;
        private int chargePlugged;

        public String toString() {
            return String.format("%d,%d,%f,%d", this.status, this.level, Float.valueOf(this.pecent), this.chargePlugged);
        }

        public static BatteryInfo getCurrentBatttery(Context context) {
            try {
                IntentFilter ifilter = new IntentFilter("android.intent.action.BATTERY_CHANGED");
                Intent batteryStatus = context.registerReceiver(null, ifilter);
                int status = batteryStatus.getIntExtra("status", -1);
                int level = batteryStatus.getIntExtra("level", -1);
                int scale = batteryStatus.getIntExtra("scale", -1);
                float batteryPct = (float)(100 * level) / (float)scale;
                int chargePlug = batteryStatus.getIntExtra("plugged", -1);
                BatteryInfo info = new BatteryInfo();
                info.level = level;
                info.status = status;
                info.pecent = batteryPct;
                info.chargePlugged = chargePlug;
                return info;
            }
            catch (Throwable throwable) {
                return null;
            }
        }
    }

    private static class SensorRecord {
        public float[] value;
        public long time;

        public SensorRecord(float[] value, long time) {
            this.value = value;
            this.time = time;
        }
    }
}

