/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiidostatis.inner.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class ZipUtil {
    public static void zipFolder(String srcFilePath, String zipFilePath) throws Exception {
        ZipOutputStream outZip = new ZipOutputStream(new FileOutputStream(zipFilePath));
        File file = new File(srcFilePath);
        ZipUtil.zipFiles(file.getParent() + File.separator, file.getName(), outZip);
        outZip.finish();
        outZip.close();
        outZip = null;
    }

    public static void zipFiles(String[] srcFilePaths, String zipFilePath) throws Exception {
        ZipOutputStream outZip = new ZipOutputStream(new FileOutputStream(zipFilePath));
        for (String srcFilePath : srcFilePaths) {
            try {
                File file = new File(srcFilePath);
                ZipUtil.zipFiles(file.getParent() + File.separator, file.getName(), outZip);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        outZip.finish();
        outZip.close();
        outZip = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void zipFiles(String folderPath, String filePath, ZipOutputStream zipOut) throws Exception {
        if (zipOut == null) {
            return;
        }
        File file = new File(folderPath + filePath);
        FileInputStream inputStream = null;
        try {
            if (file.isFile()) {
                int len;
                ZipEntry zipEntry = new ZipEntry(filePath);
                inputStream = new FileInputStream(file);
                zipOut.putNextEntry(zipEntry);
                byte[] buffer = new byte[100000];
                while ((len = inputStream.read(buffer)) != -1) {
                    zipOut.write(buffer, 0, len);
                }
                inputStream.close();
                zipOut.closeEntry();
            } else {
                String[] fileList = file.list();
                if (fileList.length <= 0) {
                    ZipEntry zipEntry = new ZipEntry(filePath + File.separator);
                    zipOut.putNextEntry(zipEntry);
                    zipOut.closeEntry();
                }
                for (int i = 0; i < fileList.length; ++i) {
                    ZipUtil.zipFiles(folderPath, filePath + File.separator + fileList[i], zipOut);
                }
            }
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                    inputStream = null;
                }
            }
            catch (Throwable throwable) {}
        }
    }
}

