/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiidostatis.inner.implementation;

import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import com.yy.hiidostatis.inner.implementation.TaskData;
import com.yy.hiidostatis.inner.implementation.TaskDataSet;
import com.yy.hiidostatis.inner.implementation.TaskDataSqLiteDBHelper;
import java.util.Iterator;

public class TaskDataSqLiteDBManager {
    private TaskDataSqLiteDBHelper helper;
    private SQLiteDatabase db;

    public TaskDataSqLiteDBManager(Context context, String name) {
        this.helper = new TaskDataSqLiteDBHelper(context, name);
        this.db = this.helper.getWritableDatabase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveAll(TaskDataSet tds) {
        this.db.beginTransaction();
        try {
            TaskData td = null;
            Iterator<TaskData> it = tds.iterator();
            String sql = "INSERT INTO TASK_DATA(_DATAID , _CONTENT , _TRYTIMES , _TIME, _ORDER , _VERIFYMD5 , _TYPE) VALUES(?,?,?,?,?,?,?)";
            while (it.hasNext()) {
                td = it.next();
                this.db.execSQL(sql, new Object[]{td.getDataId(), td.getContent(), td.getTryTimes(), td.getTime(), td.getOrder(), td.getVerifyMd5(), null});
            }
            this.db.setTransactionSuccessful();
        }
        finally {
            this.db.endTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll(TaskDataSet tds) {
        this.db.beginTransaction();
        try {
            TaskData td = null;
            Iterator<TaskData> it = tds.iterator();
            while (it.hasNext()) {
                td = it.next();
                this.db.execSQL("DELETE FROM TASK_DATA WHERE _DATAID = ?", new Object[]{td.getDataId()});
            }
            this.db.setTransactionSuccessful();
        }
        finally {
            this.db.endTransaction();
        }
    }

    public TaskDataSet getAll() {
        TaskDataSet tds = null;
        Cursor c = this.db.rawQuery("SELECT _DATAID , _CONTENT , _TRYTIMES , _TIME, _ORDER , _VERIFYMD5 , _TYPE FROM TASK_DATA ORDER BY _ORDER", null);
        if (c != null) {
            tds = new TaskDataSet();
            TaskData td = null;
            while (c.moveToNext()) {
                td = new TaskData();
                td.setDataId(c.getString(0));
                td.setContent(c.getString(1));
                td.setTryTimes(c.getInt(2));
                td.setTime(c.getLong(3));
                td.setOrder(c.getLong(4));
                td.setVerifyMd5(c.getString(5));
                tds.save(td);
            }
            c.close();
            c = null;
        }
        return tds;
    }

    public TaskDataSet getFirstList(int size) {
        TaskDataSet tds = null;
        Cursor c = this.db.rawQuery("SELECT _DATAID , _CONTENT , _TRYTIMES , _TIME, _ORDER , _VERIFYMD5 , _TYPE FROM TASK_DATA ORDER BY _ORDER LIMIT 0," + size, null);
        if (c != null) {
            tds = new TaskDataSet();
            TaskData td = null;
            while (c.moveToNext()) {
                td = new TaskData();
                td.setDataId(c.getString(0));
                td.setContent(c.getString(1));
                td.setTryTimes(c.getInt(2));
                td.setTime(c.getLong(3));
                td.setOrder(c.getLong(4));
                td.setVerifyMd5(c.getString(5));
                tds.save(td);
            }
            c.close();
            c = null;
        }
        return tds;
    }

    public int size() {
        int size = 0;
        Cursor c = this.db.rawQuery("SELECT COUNT(*) FROM TASK_DATA", null);
        if (c != null) {
            while (c.moveToNext()) {
                size = c.getInt(0);
            }
            c.close();
            c = null;
        }
        return size;
    }

    public void save(TaskData td) {
        this.db.beginTransaction();
        try {
            this.db.execSQL("INSERT INTO TASK_DATA(_DATAID , _CONTENT , _TRYTIMES , _TIME, _ORDER , _VERIFYMD5 , _TYPE) VALUES(?,?,?,?,?,?,?)", new Object[]{td.getDataId(), td.getContent(), td.getTryTimes(), td.getTime(), td.getOrder(), td.getVerifyMd5(), null});
            this.db.setTransactionSuccessful();
        }
        finally {
            this.db.endTransaction();
        }
    }

    public void update(TaskData td) {
        this.db.beginTransaction();
        try {
            this.db.execSQL("DELETE FROM TASK_DATA WHERE _DATAID = ?", new Object[]{td.getDataId()});
            this.db.execSQL("INSERT INTO TASK_DATA(_DATAID , _CONTENT , _TRYTIMES , _TIME, _ORDER , _VERIFYMD5 , _TYPE) VALUES(?,?,?,?,?,?,?)", new Object[]{td.getDataId(), td.getContent(), td.getTryTimes(), td.getTime(), td.getOrder(), td.getVerifyMd5(), null});
            this.db.setTransactionSuccessful();
        }
        finally {
            this.db.endTransaction();
        }
    }

    public void remove(TaskData td) {
        this.db.beginTransaction();
        try {
            this.db.execSQL("DELETE FROM TASK_DATA WHERE _DATAID = ?", new Object[]{td.getDataId()});
            this.db.setTransactionSuccessful();
        }
        finally {
            this.db.endTransaction();
        }
    }

    public TaskData getFirst() {
        TaskData td = null;
        Cursor c = this.db.rawQuery("SELECT _DATAID , _CONTENT , _TRYTIMES , _TIME, _ORDER , _VERIFYMD5 , _TYPE FROM TASK_DATA ORDER BY _ORDER LIMIT 0,1", null);
        if (c != null) {
            if (c.moveToNext()) {
                td = new TaskData();
                td.setDataId(c.getString(0));
                td.setContent(c.getString(1));
                td.setTryTimes(c.getInt(2));
                td.setTime(c.getLong(3));
                td.setOrder(c.getLong(4));
                td.setVerifyMd5(c.getString(5));
            }
            c.close();
            c = null;
        }
        return td;
    }

    public TaskData getLast() {
        TaskData td = null;
        Cursor c = this.db.rawQuery("SELECT _DATAID , _CONTENT , _TRYTIMES , _TIME, _ORDER , _VERIFYMD5 , _TYPE FROM TASK_DATA ORDER BY _ORDER DESC LIMIT 0,1", null);
        if (c != null) {
            if (c.moveToNext()) {
                td = new TaskData();
                td.setDataId(c.getString(0));
                td.setContent(c.getString(1));
                td.setTryTimes(c.getInt(2));
                td.setTime(c.getLong(3));
                td.setOrder(c.getLong(4));
                td.setVerifyMd5(c.getString(5));
            }
            c.close();
            c = null;
        }
        return td;
    }
}

