/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiido.autoviewtrack;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CalendarView;
import android.widget.Checkable;
import android.widget.NumberPicker;
import android.widget.TextView;
import com.yy.hiido.autoviewtrack.AutoTrackWorker;
import com.yy.hiido.autoviewtrack.beans.ActEvent;
import com.yy.hiido.autoviewtrack.track.PathElement;
import com.yy.hiido.autoviewtrack.track.ResourceIds;
import com.yy.hiido.autoviewtrack.track.ResourceReader;
import com.yy.hiidostatis.defs.controller.HttpSendController;
import com.yy.hiidostatis.inner.util.SharedTimerTask;
import com.yy.hiidostatis.inner.util.ThreadPool;
import com.yy.hiidostatis.inner.util.cipher.Coder;
import com.yy.hiidostatis.inner.util.http.StatisHttpEncryptUtil;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.Date;

public class AutoTrack {
    public static final int PERIOD = 60000;
    public static AutoTrack gAutoTrack;
    private ResourceIds mResourceIds;
    private AutoTrackWorker statisAPI;
    private SharedTimerTask timerTask = new SharedTimerTask(){

        @Override
        public void run() {
            AutoTrack.this.statisAPI.onTimer();
            ThreadPool.getPool().execute(AutoTrack.this.timerTask, 60000L);
        }
    };
    private Application.ActivityLifecycleCallbacks callbacks = new Application.ActivityLifecycleCallbacks(){

        public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
        }

        public void onActivityStarted(Activity activity) {
        }

        public void onActivityResumed(Activity activity) {
            AutoTrack.sendActivityShow(activity);
        }

        public void onActivityPaused(Activity activity) {
            AutoTrack.sendActivityHide(activity);
        }

        public void onActivityStopped(Activity activity) {
        }

        public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
        }

        public void onActivityDestroyed(Activity activity) {
        }
    };

    private AutoTrack(AutoTrackWorker statisAPI, Context context) {
        this.mResourceIds = new ResourceReader.Ids(context.getPackageName(), context);
        this.statisAPI = statisAPI;
        ThreadPool.getPool().getTimer().schedule(this.timerTask, 60000L, 60000L);
        ThreadPool.getPool().execute(this.timerTask, 60000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void startAutoTrack(Context context, String appkey, String ver, String sdkVer, String url, String[] ipAddress, String testServer) {
        if (gAutoTrack != null) return;
        Class<AutoTrack> clazz = AutoTrack.class;
        synchronized (AutoTrack.class) {
            if (gAutoTrack != null) {
                // ** MonitorExit[var7_7] (shouldn't be in output)
                return;
            }
            Application app = context instanceof Application ? (Application)context : (Application)context.getApplicationContext();
            AutoTrackWorker worker = AutoTrack.createAutoTrackWorker(context, appkey, ver, sdkVer, url, ipAddress, testServer);
            gAutoTrack = new AutoTrack(worker, context);
            app.registerActivityLifecycleCallbacks(AutoTrack.gAutoTrack.callbacks);
            // ** MonitorExit[var7_7] (shouldn't be in output)
            return;
        }
    }

    private static AutoTrackWorker createAutoTrackWorker(Context context, String appkey, String ver, String sdkVer, String url, String[] ipAddress, String testServer) {
        try {
            String path = context.getCacheDir().getAbsolutePath() + "/hiido_metrics";
            File dir = new File(path);
            dir.mkdirs();
            StatisHttpEncryptUtil httpUtil = new StatisHttpEncryptUtil(url, ipAddress);
            httpUtil.setTestServer(testServer);
            HttpSendController http = new HttpSendController(httpUtil, dir, 20, 2);
            AutoTrackWorker worker = new AutoTrackWorker(context, 10, http, 108000L, appkey, ver, sdkVer);
            return worker;
        }
        catch (Throwable e) {
            return null;
        }
    }

    private PathElement getViewPath(View view) {
        int viewId = view.getId();
        String viewIdName = -1 == viewId ? null : this.mResourceIds.nameForId(viewId);
        int hashCode = view.hashCode();
        CharSequence description = view.getContentDescription();
        String desc = null;
        if (description != null) {
            desc = description.toString();
        }
        Object tagO = view.getTag();
        String tag = null;
        if (tagO instanceof CharSequence) {
            tag = tagO.toString();
        }
        if (view.getParent() == null || !(view.getParent() instanceof ViewGroup)) {
            PathElement path = new PathElement(0, viewId, hashCode, viewIdName, desc, tag, null);
            return path;
        }
        PathElement pp = this.getViewPath((View)((ViewGroup)view.getParent()));
        int index = ((ViewGroup)view.getParent()).indexOfChild(view);
        PathElement path = new PathElement(index, viewId, hashCode, viewIdName, desc, tag, pp);
        return path;
    }

    public static void sendViewEvent(View host, String event) {
        if (gAutoTrack == null) {
            return;
        }
        gAutoTrack.sendEvent(host, event);
    }

    public static void sendActivityShow(Activity act) {
        if (gAutoTrack == null) {
            return;
        }
        AutoTrack.gAutoTrack.statisAPI.addTrackEvent(new ActEvent(act.getClass().getName(), null, "ActShow", act.getTitle().toString(), false, null));
    }

    public static void sendActivityHide(Activity act) {
        if (gAutoTrack == null) {
            return;
        }
        AutoTrack.gAutoTrack.statisAPI.addTrackEvent(new ActEvent(act.getClass().getName(), null, "ActHide", act.getTitle().toString(), false, null));
    }

    public static void sendFragmentShow(Object act) {
        if (gAutoTrack == null) {
            return;
        }
        AutoTrack.gAutoTrack.statisAPI.addTrackEvent(new ActEvent(act.getClass().getName(), null, "FmgShow", null, false, null));
    }

    public static void sendFragmentHide(Object act) {
        if (gAutoTrack == null) {
            return;
        }
        AutoTrack.gAutoTrack.statisAPI.addTrackEvent(new ActEvent(act.getClass().getName(), null, "FmgHide", null, false, null));
    }

    public void sendEvent(View host, String eventType) {
        Log.i((String)"Send Event", (String)(host.getClass().getName() + ":" + eventType));
        boolean checked = false;
        String text = "";
        try {
            if (host instanceof Checkable) {
                checked = ((Checkable)host).isChecked();
            } else if (host instanceof CalendarView) {
                String v;
                long date = ((CalendarView)host).getDate();
                text = v = SimpleDateFormat.getDateInstance().format(new Date(date));
            } else if (host instanceof NumberPicker) {
                text = String.valueOf(((NumberPicker)host).getValue());
            }
            if (host instanceof TextView) {
                text = ((TextView)host).getText().toString();
            }
        }
        catch (Throwable date) {
            // empty catch block
        }
        PathElement path = this.getViewPath(host);
        String fullPath = path.toString(this.mResourceIds);
        if (fullPath != null) {
            try {
                String md5 = Coder.encryptMD5(fullPath);
                this.statisAPI.addTrackEvent(new ActEvent(host.getContext().getClass().getName(), md5, eventType, text, checked, fullPath));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private View.AccessibilityDelegate getOldDelegate(View v) {
        View.AccessibilityDelegate ret = null;
        try {
            Class<?> klass = v.getClass();
            Method m = klass.getMethod("getAccessibilityDelegate", new Class[0]);
            ret = (View.AccessibilityDelegate)m.invoke((Object)v, new Object[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return ret;
    }
}

