/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiidostatis.inner.implementation;

import android.content.Context;
import com.yy.hiidostatis.api.HiidoSDK;
import com.yy.hiidostatis.api.ReportFailedCallback;
import com.yy.hiidostatis.inner.AbstractConfig;
import com.yy.hiidostatis.inner.implementation.ITaskExecutor;
import com.yy.hiidostatis.inner.implementation.ITaskManager;
import com.yy.hiidostatis.inner.implementation.TaskData;
import com.yy.hiidostatis.inner.implementation.TaskDataSqLiteCacheManager;
import com.yy.hiidostatis.inner.implementation.TaskExecutor;
import com.yy.hiidostatis.inner.util.ArdUtil;
import com.yy.hiidostatis.inner.util.ThreadPool;
import com.yy.hiidostatis.inner.util.Util;
import com.yy.hiidostatis.inner.util.http.AbstractStatisHttpUtil;
import com.yy.hiidostatis.inner.util.http.CacheIp;
import com.yy.hiidostatis.inner.util.http.HIpConfig;
import com.yy.hiidostatis.inner.util.http.HStatisHttpEncryptUtil;
import com.yy.hiidostatis.inner.util.http.IStatisHttpUtil;
import com.yy.hiidostatis.inner.util.http.StatisHttpEncryptUtil;
import com.yy.hiidostatis.inner.util.http.StatisHttpUtil;
import com.yy.hiidostatis.inner.util.log.ActLog;
import com.yy.hiidostatis.inner.util.log.L;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicInteger;

public class TaskManagerNew
implements ITaskManager {
    private static final int MAX_RETRY_TIMES = AbstractConfig.MAX_DATA_RETRY_TIME;
    private static final int MAX_CACHE_DAY = AbstractConfig.MAX_DATA_CACHE_DAY;
    private volatile boolean isEnableSend = true;
    private AbstractConfig mConfig;
    private final TaskExecutor mExecutor;
    private final TaskExecutor mSaveExecutor;
    private TaskDataSqLiteCacheManager cacheManager;
    private volatile FailSendControler failSendControler = new FailSendControler(-1L);
    private CacheIp mCacheIp = new CacheIp();
    private CacheIp mCacheIpTemporary = new CacheIp();
    private String mLastSucDataId = null;
    private IStatisHttpUtil mHttpUtil = null;
    private AtomicInteger sendFailedCount = new AtomicInteger(0);
    private Vector<TaskData> mPreStoreVectors = new Vector();
    private volatile boolean mIsStoreWorking = false;
    private final int BATCH_STORE_SIZE = 100;
    private final long BATCH_STORE_WAITING_TIME = 50L;
    private final long BATCH_STORE_INTERVAL_TIME = 10000L;
    private volatile boolean mIsWorking = false;

    public TaskManagerNew(Context context, AbstractConfig config) {
        this.mConfig = config;
        this.cacheManager = new TaskDataSqLiteCacheManager(context, config.getCacheFileName());
        ITaskExecutor.OnTaskRejectedListener rejectListener = new ITaskExecutor.OnTaskRejectedListener(){

            @Override
            public void onRejectedTask(ITaskExecutor.ExecutorTask task) {
                L.brief("Store rejected task %s", task.getData().getDataId());
                TaskManagerNew.this.cacheManager.save(task.getContext(), task.getData());
            }
        };
        this.mSaveExecutor = new TaskExecutor(rejectListener, "Statis_SDK_Save_Worker");
        this.mExecutor = new TaskExecutor(null, "Statis_SDK_Send_Worker");
    }

    private IStatisHttpUtil getHttpUtilCache() {
        if (this.mHttpUtil != null) {
            return this.mHttpUtil;
        }
        this.mHttpUtil = this.getHttpUtil();
        return this.mHttpUtil;
    }

    private IStatisHttpUtil getHttpUtil() {
        AbstractStatisHttpUtil httpUtil = this.isEncrypt() ? (this.isAbroad() ? new HStatisHttpEncryptUtil(HIpConfig.instance.getHost(this.mConfig.getBusinessType()), HIpConfig.instance.getIps(this.mConfig.getBusinessType())) : new StatisHttpEncryptUtil(this.mConfig.getUrlHost(), this.mConfig.getUrlAddress())) : new StatisHttpUtil();
        httpUtil.setTestServer(this.mConfig.getTestServer());
        httpUtil.setCacheIp(this.mCacheIp);
        return httpUtil;
    }

    private boolean isEncrypt() {
        boolean isEncryptTestServer = this.mConfig.isEncryptTestServer();
        String testServer = this.mConfig.getTestServer();
        L.brief("isEncrypt[%b],isEncryptTestServer[%b],testServer[%s]", this.mConfig.isEncrypt(), isEncryptTestServer, testServer);
        if (this.mConfig.isEncrypt()) {
            return isEncryptTestServer || Util.empty(testServer);
        }
        return false;
    }

    @Override
    public boolean send(Context c, String content) {
        ActLog.writeActLog(c, "Add", content, null, null, null);
        TaskData data = new TaskData();
        data.setContent(content);
        data.setDataId(data.createDataId());
        data.setVerifyMd5(data.createVerifyMd5());
        boolean b = this.cacheManager.save(c, data);
        this.createSendTask(c, true, 0);
        return b;
    }

    @Override
    public boolean send(Context c, String content, Long order) {
        ActLog.writeActLog(c, "Add", content, null, null, null);
        TaskData data = new TaskData();
        data.setContent(content);
        data.setDataId(data.createDataId());
        data.setVerifyMd5(data.createVerifyMd5());
        if (order != null) {
            data.setOrder(order);
        }
        boolean b = this.cacheManager.save(c, data);
        this.createSendTask(c, true, 0);
        return b;
    }

    private void createSendTask(final Context c, final boolean isSendFront, int wait) {
        if (this.mIsWorking) {
            return;
        }
        this.mIsWorking = true;
        try {
            ITaskExecutor.ExecutorTask runnable = new ITaskExecutor.ExecutorTask(c, null){

                @Override
                public void run() {
                    int wait = 0;
                    try {
                        while ((wait = TaskManagerNew.this.sendNext(c, isSendFront)) == 0) {
                        }
                    }
                    catch (Throwable e) {
                        L.error(this, "exception:%s", e);
                    }
                    finally {
                        TaskManagerNew.this.mIsWorking = false;
                        if (wait > 0) {
                            TaskManagerNew.this.createSendTask(c, true, wait);
                        }
                    }
                }
            };
            this.mExecutor.submit(runnable, wait);
        }
        catch (Throwable e) {
            this.mIsWorking = false;
            L.error(this, "noticeSend:RejectedExecutionException=%s,do nothing.", e);
        }
    }

    @Override
    public void sendTemporary(Context c, final String content) {
        ThreadPool.getPool().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    IStatisHttpUtil httpUtil = TaskManagerNew.this.getHttpUtil();
                    httpUtil.setLastTryTimes(0);
                    httpUtil.setRetryTimeHost(0);
                    httpUtil.setTryTimeIp(1);
                    httpUtil.setCacheIp(TaskManagerNew.this.mCacheIpTemporary);
                    boolean suc = httpUtil.sendSync(content);
                    int lastTryTimes = httpUtil.getLastTryTimes();
                    L.debug(this, "sendTemporary:lastTryTimes:%d . Return value: %B to send command %s. ", lastTryTimes, suc, content);
                }
                catch (Throwable e) {
                    L.error(this, "sendTemporary error = %s", e);
                }
            }
        });
    }

    private int sendNext(Context c, boolean isSendFront) {
        TaskData data;
        if (!this.isEnableSend) {
            L.brief("isEnableSend:false,end send.", new Object[0]);
            return -1;
        }
        if (!ArdUtil.isNetworkAvailable(c)) {
            L.brief("isNetworkAvailable:false,end send.", new Object[0]);
            return 2000;
        }
        L.brief("isSendFront:%b", isSendFront);
        TaskData taskData = data = isSendFront ? this.cacheManager.getFirst(c) : this.cacheManager.getLast(c);
        if (data == null) {
            L.brief("data is null,end send. ", new Object[0]);
            return -1;
        }
        if (this.isOverdue(data) || this.isOverMaxTryTimes(data)) {
            L.warn(this, "data:%s .overdue or over MaxTryTimes. give up the data. max cache day = [%d].MaxTryTimes = [%d] .dataTryTimes = [%d]", data.getDataId(), MAX_CACHE_DAY, MAX_RETRY_TIMES, data.getTryTimes());
            this.removeInvalid(c, data);
            return 0;
        }
        boolean isSuc = this.doSend(c, data);
        if (isSuc) {
            this.cacheManager.remove(c, data);
            this.sendFailedCount.set(0);
            return 0;
        }
        if (this.isOverMaxTryTimes(data)) {
            this.removeInvalid(c, data);
        } else {
            this.cacheManager.update(c, data);
        }
        int failedCount = this.sendFailedCount.incrementAndGet();
        if (failedCount > 10) {
            this.sendFailedCount.compareAndSet(failedCount, 10);
        }
        int wait = failedCount * failedCount * 100;
        wait = Math.min(10000, wait);
        return wait;
    }

    private boolean doSend(Context c, TaskData data) {
        if (data.getDataId() != null && data.getDataId().equals(this.mLastSucDataId)) {
            L.warn(this, "data send more than 1 times continuously. dataId=%s", this.mLastSucDataId);
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return true;
        }
        int rt = data.getTryTimes();
        long bt = System.currentTimeMillis();
        IStatisHttpUtil httpUtil = this.getHttpUtilCache();
        httpUtil.setLastTryTimes(data.getTryTimes());
        String content = data.getContent();
        try {
            content = String.format("%s&hd_stime=%d", content, Util.wallTimeMillis());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        boolean suc = httpUtil.sendSync(content);
        int tryTimes = httpUtil.getLastTryTimes();
        L.debug(this, "Return value: %B to send command %s. ", suc, content);
        if (Math.random() < 0.001) {
            HiidoSDK.instance().reportReturnCode(50000, httpUtil.getHost(), System.currentTimeMillis() - bt, String.valueOf(httpUtil.getLastStatusCode()));
        }
        if (!suc) {
            ReportFailedCallback cb = HiidoSDK.instance().getOptions().getReportFailedCallback();
            if (rt == 0 && cb != null) {
                String ps = httpUtil.getUrlParams();
                String ct = httpUtil.getBody();
                if (ps != null && !ps.isEmpty()) {
                    try {
                        cb.hiidoSdkReportFailedCallBack(ps, ct);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
            HiidoSDK.instance().reportCount("SDK_METRICS", 50000, httpUtil.getHost(), "SDK_FAIL", 1L);
            if (httpUtil.getLastStatusCode() == 414 || httpUtil.getLastStatusCode() == 400) {
                this.removeInvalid(c, data);
                this.failSendControler.reset();
                L.warn(this, "httpUtil.getLastStatusCode()=%d,removeInvalid:%s", httpUtil.getLastStatusCode(), data.getContent());
                return true;
            }
            data.setTryTimes(tryTimes);
            L.debug(this, "data:%s ; all tryTimes:%d ; createTime:%d", data.getDataId(), data.getTryTimes(), data.getTime());
            this.failSendControler.increase();
        } else {
            HiidoSDK.instance().reportCount("SDK_METRICS", 50000, httpUtil.getHost(), "SDK_SUC", 1L);
            HiidoSDK.instance().reportCount("SDK_METRICS", 50000, httpUtil.getHost(), "SDK_DUR", System.currentTimeMillis() - bt);
            this.failSendControler.reset();
            this.mLastSucDataId = data.getDataId();
        }
        return suc;
    }

    private boolean isOverdue(TaskData data) {
        try {
            return Util.daysBetween(data.getTime(), System.currentTimeMillis()) > MAX_CACHE_DAY;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    private boolean isOverMaxTryTimes(TaskData data) {
        return data.getTryTimes() >= MAX_RETRY_TIMES;
    }

    private void removeInvalid(Context c, TaskData data) {
        this.cacheManager.remove(c, data);
        ActLog.writeActLog(c, "Dis", data.getContent(), null, null, null);
        ActLog.writeSendFailLog(c, null, null, data.getContent(), "remove Invalid", "-1", data.getTryTimes());
    }

    public int cacheSize(Context context) {
        return this.cacheManager.size(context);
    }

    @Override
    public void storePendingCommands(Context c, boolean shutDownOnEnd) {
        if (c == null) {
            return;
        }
        try {
            this.cacheManager.storePendingCommands(c);
            L.brief("storePendingCommands .", new Object[0]);
        }
        catch (Throwable e) {
            L.error(this, "Failed to store pending commands.", new Object[0]);
        }
    }

    @Override
    public void flush(Context c) {
        this.failSendControler.reset();
        this.createSendTask(c, true, 0);
    }

    private boolean isAbroad() {
        return this.mConfig.isAbroad();
    }

    @Override
    public void enableSend(boolean enable) {
        this.isEnableSend = enable;
    }

    public TaskExecutor getExecutor() {
        return this.mExecutor;
    }

    private static class FailSendControler {
        private static final long SEND_FAIL_SLEEP_TIMES = 10000L;
        private long lastFailTime = 0L;
        private int failContinuous = 0;
        private final long sleepTime;

        public FailSendControler(long sleepTime) {
            this.sleepTime = sleepTime > 0L ? sleepTime : 10000L;
        }

        public void reset() {
            this.lastFailTime = 0L;
            this.failContinuous = 0;
        }

        public void increase() {
            this.lastFailTime = System.currentTimeMillis();
            ++this.failContinuous;
        }

        public long getSleepTime() {
            return this.sleepTime;
        }

        public int getFailContinuous() {
            return this.failContinuous;
        }

        public boolean isOverTime() {
            return System.currentTimeMillis() - this.lastFailTime > this.getSleepTime();
        }
    }
}

