/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiidostatis.inner.implementation;

import com.yy.hiidostatis.api.ExecutorProvider;
import com.yy.hiidostatis.inner.implementation.AbstractTaskExecutor;
import com.yy.hiidostatis.inner.implementation.ITaskExecutor;
import com.yy.hiidostatis.inner.util.ThreadPool;
import com.yy.mobile.perf.taskexecutor.IQueueTaskExecutor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class TaskExecutor
extends AbstractTaskExecutor {
    private final ITaskExecutor.OnTaskRejectedListener mOnTaskRejectedListener;
    private ScheduledExecutorService mExecutor;
    private IQueueTaskExecutor singleTaskExecutor;

    TaskExecutor(ITaskExecutor.OnTaskRejectedListener l) {
        this(l, "Statis_SDK_Worker");
    }

    TaskExecutor(ITaskExecutor.OnTaskRejectedListener l, final String name) {
        if (ExecutorProvider.getIyyTaskExecutor() != null) {
            try {
                this.singleTaskExecutor = ExecutorProvider.getIyyTaskExecutor().createAQueueExcuter();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (this.singleTaskExecutor == null) {
            this.mExecutor = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

                @Override
                public Thread newThread(Runnable r) {
                    Thread ret = new Thread(r);
                    ret.setName(name);
                    ret.setPriority(1);
                    return ret;
                }
            });
        }
        this.mOnTaskRejectedListener = l;
    }

    @Override
    protected void submitTask(Runnable task) {
        try {
            if (this.singleTaskExecutor != null) {
                this.singleTaskExecutor.execute(task, 0L);
            } else {
                this.mExecutor.execute(task);
            }
        }
        catch (Throwable e) {
            ThreadPool.getPool().executeQueue(task);
        }
    }

    @Override
    protected void submitTask(Runnable task, int delay) {
        try {
            if (this.singleTaskExecutor != null) {
                this.singleTaskExecutor.execute(task, delay);
            } else {
                this.mExecutor.schedule(task, (long)delay, TimeUnit.MILLISECONDS);
            }
        }
        catch (Throwable e) {
            ThreadPool.getPool().executeQueue(task);
        }
    }

    @Override
    public ITaskExecutor.OnTaskRejectedListener getOnTaskRejectedListener() {
        return this.mOnTaskRejectedListener;
    }
}

