/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiidostatis.inner.util.http;

import android.os.Build;
import com.yy.hiidostatis.inner.AppInfo;
import com.yy.hiidostatis.inner.util.http.SSLSocketClient;
import com.yy.hiidostatis.inner.util.log.L;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Pattern;
import javax.net.ssl.HttpsURLConnection;

public class HttpUtil {
    private static final Pattern ipv4Pattern = Pattern.compile("\\d+\\.\\d+\\.\\d+\\.\\d+");

    public static String get(String url, Map<String, String> params) throws IOException {
        String paramsStr = null;
        if (params != null && params.size() > 0) {
            int i = 0;
            StringBuffer sb = new StringBuffer();
            for (Map.Entry<String, String> entry : params.entrySet()) {
                if (i++ > 0) {
                    sb.append("&");
                }
                sb.append(entry.getKey()).append("=").append(entry.getValue());
            }
            paramsStr = sb.toString();
            sb.setLength(0);
            sb = null;
        }
        return HttpUtil.getByUrlConn((String)url, paramsStr).result;
    }

    public static String post(String urlAddr, String content) throws IOException {
        return HttpUtil.postByUrlConn((String)urlAddr, (String)content).result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HttpResp getByUrlConn(String urlAddr, String content) throws IOException {
        HttpResp resp = new HttpResp();
        HttpURLConnection urlConn = null;
        FilterOutputStream dos = null;
        InputStream is = null;
        try {
            if (content != null && content.length() > 0) {
                urlAddr = String.format("%s?%s", urlAddr, content);
            }
            urlConn = HttpUtil.urlToUrlConnection(urlAddr);
            urlConn.setConnectTimeout(30000);
            urlConn.setReadTimeout(60000);
            urlConn.setUseCaches(false);
            urlConn.setRequestMethod("GET");
            urlConn.setInstanceFollowRedirects(true);
            urlConn.setRequestProperty("User-Agent", "Hiido");
            urlConn.connect();
            resp.isSucceed = urlConn.getResponseCode() == 200;
            resp.statusCode = urlConn.getResponseCode();
            resp.reason = urlConn.getResponseMessage();
            if (urlConn.getResponseCode() == 200) {
                L.verbose(HttpUtil.class, "get url=[%s] is ok", urlAddr);
                is = urlConn.getInputStream();
                ByteArrayOutputStream bao = new ByteArrayOutputStream();
                byte[] b = new byte[1024];
                int len = 0;
                while ((len = is.read(b)) != -1) {
                    bao.write(b, 0, len);
                }
                resp.result = new String(bao.toByteArray(), "UTF-8");
                L.verbose(HttpUtil.class, "the result is %s", resp.result);
                b = null;
                bao.close();
            } else {
                L.warn(HttpUtil.class, "http get [%s] error! status:%d", urlAddr, urlConn.getResponseCode());
            }
        }
        catch (Throwable throwable) {
        }
        finally {
            try {
                if (urlConn != null) {
                    urlConn.disconnect();
                    urlConn = null;
                }
                if (dos != null) {
                    dos.close();
                    dos = null;
                }
                if (is != null) {
                    is.close();
                    is = null;
                }
            }
            catch (Throwable throwable) {}
        }
        return resp;
    }

    public static boolean isIpAddress(String host) {
        return ipv4Pattern.matcher(host).matches();
    }

    public static HttpURLConnection urlToUrlConnection(String urlAddr) throws IOException {
        URL url = new URL(urlAddr);
        if (Build.VERSION.SDK_INT > 27 && AppInfo.INSTANCE.targetSdkVersion > 27) {
            if (!url.getProtocol().equalsIgnoreCase("https")) {
                String surl = "https" + urlAddr.substring(url.getProtocol().length());
                url = new URL(surl);
            }
            HttpsURLConnection con = (HttpsURLConnection)url.openConnection();
            boolean b = HttpUtil.isIpAddress(url.getHost());
            if (b) {
                con.setSSLSocketFactory(SSLSocketClient.getSSLSocketFactory());
                con.setHostnameVerifier(SSLSocketClient.getHostnameVerifier());
            }
            return con;
        }
        HttpURLConnection urlConn = (HttpURLConnection)url.openConnection();
        return urlConn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HttpResp postByUrlConn(String urlAddr, String content) throws IOException {
        HttpResp resp = new HttpResp();
        HttpURLConnection urlConn = null;
        FilterOutputStream dos = null;
        InputStream is = null;
        try {
            urlConn = HttpUtil.urlToUrlConnection(urlAddr);
            urlConn.setConnectTimeout(30000);
            urlConn.setReadTimeout(60000);
            urlConn.setDoOutput(true);
            urlConn.setUseCaches(false);
            urlConn.setRequestMethod("POST");
            urlConn.setInstanceFollowRedirects(true);
            urlConn.setRequestProperty("Accept-Charset", "text/html;charset=UTF-8");
            urlConn.setRequestProperty("User-Agent", "Hiido");
            urlConn.connect();
            dos = new DataOutputStream(urlConn.getOutputStream());
            dos.write(content.getBytes("UTF-8"));
            ((DataOutputStream)dos).flush();
            dos.close();
            dos = null;
            resp.isSucceed = urlConn.getResponseCode() == 200;
            resp.statusCode = urlConn.getResponseCode();
            resp.reason = urlConn.getResponseMessage();
            resp.remoteIp = HttpUtil.getAddressInfo(urlConn);
            if (urlConn.getResponseCode() == 200) {
                L.verbose(HttpUtil.class, "post url=[%s] is ok", urlAddr);
                is = urlConn.getInputStream();
                ByteArrayOutputStream bao = new ByteArrayOutputStream();
                byte[] b = new byte[1024];
                int len = 0;
                while ((len = is.read(b)) != -1) {
                    bao.write(b, 0, len);
                }
                resp.result = new String(bao.toByteArray(), "UTF-8");
                L.verbose(HttpUtil.class, "the result is %s", resp.result);
                b = null;
                bao.close();
            } else {
                L.warn(HttpUtil.class, "http post [%s] error! status:%d", urlAddr, urlConn.getResponseCode());
            }
        }
        catch (Throwable throwable) {
        }
        finally {
            try {
                if (urlConn != null) {
                    urlConn.disconnect();
                    urlConn = null;
                }
                if (dos != null) {
                    dos.close();
                    dos = null;
                }
                if (is != null) {
                    is.close();
                    is = null;
                }
            }
            catch (Throwable throwable) {}
        }
        return resp;
    }

    private static String getAddressInfo(HttpURLConnection con) {
        if (Build.VERSION.SDK_INT > 27) {
            return "";
        }
        try {
            Class<?> c = con.getClass();
            Field f = c.getDeclaredField("route");
            f.setAccessible(true);
            Object route = f.get(con);
            Field pf = route.getClass().getDeclaredField("proxy");
            pf.setAccessible(true);
            Proxy proxy = (Proxy)pf.get(route);
            Field netF = route.getClass().getDeclaredField("inetSocketAddress");
            netF.setAccessible(true);
            InetSocketAddress address = (InetSocketAddress)netF.get(route);
            String addr = address.toString();
            Proxy.Type type = proxy.type();
            return addr + ":" + (Object)((Object)type);
        }
        catch (Throwable e) {
            return "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HttpResp postFileByUrlConn(String urlAddr, Map<String, String> textMap, Map<String, String> fileMap) throws Exception {
        HttpResp resp = new HttpResp();
        HttpURLConnection conn = null;
        String BOUNDARY = String.format("---------%d---------", System.currentTimeMillis());
        URL url = null;
        OutputStream out = null;
        try {
            url = new URL(urlAddr);
            conn = (HttpURLConnection)url.openConnection();
            conn.setConnectTimeout(5000);
            conn.setReadTimeout(30000);
            conn.setDoOutput(true);
            conn.setDoInput(true);
            conn.setUseCaches(false);
            conn.setRequestMethod("POST");
            conn.setRequestProperty("Content-Type", String.format("multipart/form-data; boundary=%s", BOUNDARY));
            out = new DataOutputStream(conn.getOutputStream());
            if (textMap != null) {
                StringBuffer strBuf = new StringBuffer();
                Iterator<Map.Entry<String, String>> iter = textMap.entrySet().iterator();
                Map.Entry<String, String> entry = null;
                String inputName = null;
                String inputValue = null;
                while (iter.hasNext()) {
                    entry = iter.next();
                    inputName = entry.getKey();
                    inputValue = entry.getValue();
                    if (inputValue == null) continue;
                    strBuf.append("\r\n").append("--").append(BOUNDARY).append("\r\n");
                    strBuf.append("Content-Disposition: form-data; name=\"").append(inputName).append("\"\r\n\r\n");
                    strBuf.append(inputValue);
                }
                out.write(strBuf.toString().getBytes());
                strBuf.setLength(0);
                strBuf = null;
                iter = null;
                entry = null;
                inputName = null;
                inputValue = null;
            }
            if (fileMap != null) {
                Iterator<Map.Entry<String, String>> iter = fileMap.entrySet().iterator();
                Map.Entry<String, String> entry = null;
                String inputName = null;
                String inputValue = null;
                File file = null;
                StringBuffer strBuf = new StringBuffer();
                DataInputStream in = null;
                FileInputStream fis = null;
                byte[] bufferOut = null;
                while (iter.hasNext()) {
                    entry = iter.next();
                    inputName = entry.getKey();
                    inputValue = entry.getValue();
                    if (inputValue == null) continue;
                    file = new File(inputValue);
                    strBuf.setLength(0);
                    strBuf.append("\r\n").append("--").append(BOUNDARY).append("\r\n");
                    strBuf.append("Content-Disposition: form-data; name=\"").append(inputName).append("\"; filename=\"").append(file.getName()).append("\"\r\n");
                    strBuf.append("Content-Type:").append(HttpUtil.getContentType(file)).append("\r\n\r\n");
                    out.write(strBuf.toString().getBytes());
                    fis = new FileInputStream(file);
                    in = new DataInputStream(fis);
                    int bytes = 0;
                    bufferOut = new byte[1024];
                    while ((bytes = in.read(bufferOut)) != -1) {
                        out.write(bufferOut, 0, bytes);
                    }
                    fis.close();
                    in.close();
                }
                strBuf.setLength(0);
                strBuf = null;
                in = null;
                fis = null;
            }
            byte[] endData = String.format("\r\n--%s--\r\n", BOUNDARY).getBytes();
            out.write(endData);
            out.flush();
            resp.isSucceed = conn.getResponseCode() == 200;
            resp.statusCode = conn.getResponseCode();
            resp.reason = conn.getResponseMessage();
            if (conn.getResponseCode() == 200) {
                InputStream is = conn.getInputStream();
                ByteArrayOutputStream bao = new ByteArrayOutputStream();
                byte[] b = new byte[1024];
                int len = 0;
                while ((len = is.read(b)) != -1) {
                    bao.write(b, 0, len);
                }
                resp.result = new String(bao.toByteArray(), "UTF-8");
                b = null;
                bao.close();
            }
        }
        finally {
            if (conn != null) {
                conn.disconnect();
                conn = null;
            }
            if (out != null) {
                out.close();
                out = null;
            }
        }
        return resp;
    }

    private static String getContentType(File f) throws Exception {
        return "application/octet-stream";
    }

    public static class HttpResp {
        public boolean isSucceed = false;
        public int statusCode = -1;
        public String reason = null;
        public String result = null;
        public String remoteIp = null;
    }
}

