/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiidostatis.inner.util;

import android.os.SystemClock;
import com.yy.hiidostatis.inner.util.log.L;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Util {
    private static volatile Locale locale = null;
    private static ThreadLocal<Map<String, SimpleDateFormat>> dateFormatThreadLocal;

    private static SimpleDateFormat getSimpleDateFormat(String format) {
        Map<String, SimpleDateFormat> formatMap = dateFormatThreadLocal.get();
        SimpleDateFormat sdf = formatMap.get(format);
        if (sdf == null) {
            sdf = locale == null ? new SimpleDateFormat(format) : new SimpleDateFormat(format, locale);
            formatMap.put(format, sdf);
        }
        return sdf;
    }

    public static String formatDate(String format, long time) {
        return Util.getSimpleDateFormat(format).format(time);
    }

    public static Date parseDate(String format, String date) throws ParseException {
        return Util.getSimpleDateFormat(format).parse(date);
    }

    public static String formatStr(String format, Object ... args) {
        if (args == null || args.length == 0) {
            return format;
        }
        if (locale == null) {
            return String.format(format, args);
        }
        return String.format(locale, format, args);
    }

    public static boolean empty(String s) {
        return s == null || s.length() == 0;
    }

    public static String asEmptyOnNull(String s) {
        return s == null ? "" : s;
    }

    public static boolean hasData(String s) {
        return !Util.empty(s);
    }

    public static boolean empty(Collection<?> list) {
        return list == null || list.size() == 0;
    }

    public static boolean empty(byte[] bytes) {
        return bytes == null || bytes.length == 0;
    }

    public static <T> boolean empty(T ... array) {
        return array == null || array.length == 0;
    }

    public static boolean empty(int ... args) {
        return args == null || args.length == 0;
    }

    public static boolean hasData(Collection<?> list) {
        return !Util.empty(list);
    }

    public static <T> boolean hasData(T ... array) {
        return !Util.empty(array);
    }

    public static long cpuMillis() {
        return SystemClock.elapsedRealtime();
    }

    public static long cpuSec() {
        return Util.millisToSec(Util.cpuMillis());
    }

    public static long millisToSec(long millis) {
        return millis / 1000L;
    }

    public static long millisToSec1(long millis) {
        return millis % 1000L != 0L && millis > 0L ? millis / 1000L + 1L : millis / 1000L;
    }

    public static long wallTimeSec() {
        return Util.millisToSec(Util.wallTimeMillis());
    }

    public static long wallTimeMillis() {
        return System.currentTimeMillis();
    }

    public static int daysBetween(long time1, long time2) {
        long between_times = time2 - time1;
        long between_days = between_times / 86400000L;
        if (between_times % 86400000L != 0L) {
            ++between_days;
        }
        return Integer.parseInt(String.valueOf(between_days));
    }

    public static int longToInt(long l) {
        if (l >= Integer.MAX_VALUE) {
            L.warn(Util.class, "Failed to convert long %d to int.", l);
        }
        return (int)l;
    }

    public static String getRandStringEx(int length) {
        byte[] charList = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122};
        byte[] rev = new byte[length];
        Random f = new Random();
        for (int i = 0; i < length; ++i) {
            rev[i] = charList[f.nextInt(charList.length - 1)];
        }
        return new String(rev);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isExistClass(String className) {
        Class<?> c = null;
        try {
            if (Util.empty(className)) {
                boolean bl = false;
                return bl;
            }
            c = Class.forName(className);
            boolean bl = c != null;
            return bl;
        }
        catch (Throwable e) {
            boolean bl = false;
            return bl;
        }
        finally {
            c = null;
        }
    }

    public static String replaceEncode(String str, String enCodeStr) {
        if (Util.empty(str)) {
            return str;
        }
        try {
            return str.replace(enCodeStr, URLEncoder.encode(enCodeStr, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            return str;
        }
    }

    public static String parseParam(String content, String param) {
        try {
            String[] params = content.split("&");
            String[] kv = null;
            for (String oneParam : params) {
                kv = oneParam.split("=");
                if (!param.equals(kv[0])) continue;
                return kv[1];
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return "";
    }

    public static Map<String, String> parseParams(String content) {
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            String[] params = content.split("&");
            String[] kv = null;
            for (String oneParam : params) {
                kv = oneParam.split("=", -1);
                map.put(kv[0], kv[1]);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return map;
    }

    public static String getOutNetIp() {
        URL infoUrl = null;
        InputStream inStream = null;
        try {
            infoUrl = new URL("http://city.ip138.com/ip2city.asp");
            URLConnection connection = infoUrl.openConnection();
            HttpURLConnection httpConnection = (HttpURLConnection)connection;
            int responseCode = httpConnection.getResponseCode();
            if (responseCode == 200) {
                inStream = httpConnection.getInputStream();
                BufferedReader reader = new BufferedReader(new InputStreamReader(inStream, "UTF-8"));
                StringBuilder strber = new StringBuilder();
                String line = null;
                while ((line = reader.readLine()) != null) {
                    strber.append(line).append("\n");
                }
                inStream.close();
                String ip = "";
                String result = strber.toString();
                String rexp = "[\\d]{1,3}\\.[\\d]{1,3}\\.[\\d]{1,3}\\.[\\d]{1,3}";
                Pattern pat = Pattern.compile(rexp);
                Matcher mat = pat.matcher(result);
                while (mat.find()) {
                    ip = mat.group();
                }
                return ip;
            }
        }
        catch (Throwable e) {
            L.debug(Util.class, "getOutNetIp ex=%s", e);
        }
        return "";
    }

    public static String getInnerIP() {
        try {
            Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
            while (en.hasMoreElements()) {
                NetworkInterface intf = en.nextElement();
                Enumeration<InetAddress> enumIpAddr = intf.getInetAddresses();
                while (enumIpAddr.hasMoreElements()) {
                    InetAddress inetAddress = enumIpAddr.nextElement();
                    if (inetAddress.isLoopbackAddress() || !(inetAddress instanceof Inet4Address)) continue;
                    return inetAddress.getHostAddress().toString();
                }
            }
        }
        catch (Throwable e) {
            L.debug(Util.class, "getInnerIP ex=%s", e);
        }
        return "";
    }

    public static byte[] readInputStream(InputStream in) throws IOException {
        int readSize;
        byte[] buffer = new byte[5120];
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        while ((readSize = in.read(buffer)) >= 0) {
            out.write(buffer, 0, readSize);
        }
        return out.toByteArray();
    }

    static {
        try {
            if (!"1234567890".equals(String.format("%d", 1234567890))) {
                locale = Locale.ENGLISH;
                System.out.println("locale=" + locale);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        dateFormatThreadLocal = new ThreadLocal<Map<String, SimpleDateFormat>>(){

            @Override
            protected Map<String, SimpleDateFormat> initialValue() {
                return new HashMap<String, SimpleDateFormat>();
            }
        };
    }
}

