/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiidostatis.defs.controller;

import android.content.Context;
import android.os.Build;
import android.util.Log;
import com.bun.miitmdid.core.IIdentifierListener;
import com.bun.miitmdid.core.JLibrary;
import com.bun.miitmdid.core.MdidSdkHelper;
import com.bun.miitmdid.supplier.IdSupplier;
import com.yy.hiidostatis.inner.util.ThreadPool;

public enum OaidController {
    INSTANCE;

    private OaidHelper oaidHelper = new OaidHelper();

    public static void loadLib(Context context) {
        try {
            if (Build.VERSION.SDK_INT < 28) {
                return;
            }
            JLibrary.InitEntry((Context)context);
        }
        catch (Throwable e) {
            Log.e((String)"OaidController", (String)"JLibrary.InitEntry(context)", (Throwable)e);
        }
    }

    public void initOaidAsyn(Context ctx, OaidInitListener listener) {
        this.oaidHelper.initOaid(ctx, listener);
    }

    public boolean isLoaded() {
        return this.oaidHelper.isInit();
    }

    public String oaid() {
        return this.oaidHelper.getOaid();
    }

    public static interface OaidInitListener {
        public void initFinish(boolean var1, String var2, String var3);
    }

    private final class OaidHelper {
        private static final int TIME_OUT = 10000;
        private volatile boolean init;
        private volatile String oaid = "";

        private OaidHelper() {
        }

        private synchronized void initFinish(boolean success, String oaid, String error, OaidInitListener listener) {
            try {
                if (this.init) {
                    if (success && (this.oaid == null || this.oaid.isEmpty()) && oaid != null && !oaid.isEmpty()) {
                        this.oaid = oaid;
                    }
                    return;
                }
                this.init = true;
                this.oaid = oaid;
                if (listener != null) {
                    listener.initFinish(success, oaid, error);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        public void initOaid(Context cxt, final OaidInitListener listener) {
            try {
                if (Build.VERSION.SDK_INT < 28) {
                    this.init = true;
                    return;
                }
                ThreadPool.getPool().execute(new Runnable(){

                    @Override
                    public void run() {
                        if (OaidHelper.this.init) {
                            return;
                        }
                        OaidHelper.this.initFinish(false, "", "\u83b7\u53d6OAID\u8d85\u65f6", listener);
                    }
                }, 10000L);
                int nres = this.callFromReflect(cxt, listener);
                if (nres == 1008612) {
                    throw new Exception("\u4e0d\u652f\u6301\u7684\u8bbe\u5907");
                }
                if (nres == 1008613) {
                    throw new Exception("\u52a0\u8f7d\u914d\u7f6e\u6587\u4ef6\u51fa\u9519");
                }
                if (nres == 1008611) {
                    throw new Exception("\u4e0d\u652f\u6301\u7684\u8bbe\u5907\u5382\u5546");
                }
                if (nres == 1008614) {
                    throw new Exception("\u83b7\u53d6\u63a5\u53e3\u662f\u5f02\u6b65\u7684\uff0c\u7ed3\u679c\u4f1a\u5728\u56de\u8c03\u4e2d\u8fd4\u56de\uff0c\u56de\u8c03\u6267\u884c\u7684\u56de\u8c03\u53ef\u80fd\u5728\u5de5\u4f5c\u7ebf\u7a0b");
                }
                if (nres == 1008615) {
                    throw new Exception("\u53cd\u5c04\u8c03\u7528\u51fa\u9519");
                }
            }
            catch (Throwable e) {
                this.initFinish(false, "", e.getMessage(), listener);
            }
        }

        public boolean isInit() {
            return this.init;
        }

        public String getOaid() {
            return this.oaid == null ? "" : this.oaid;
        }

        private int callFromReflect(Context cxt, final OaidInitListener listener) {
            return MdidSdkHelper.InitSdk((Context)cxt, (boolean)true, (IIdentifierListener)new IIdentifierListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void OnSupport(boolean b, IdSupplier idSupplier) {
                    try {
                        if (idSupplier == null) {
                            OaidHelper.this.initFinish(false, "", "\u83b7\u53d6OAID\u5931\u8d25", listener);
                            return;
                        }
                        String oaid = idSupplier.getOAID();
                        OaidHelper.this.initFinish(true, oaid, null, listener);
                    }
                    catch (Throwable throwable) {
                    }
                    finally {
                        if (idSupplier != null) {
                            try {
                                idSupplier.shutDown();
                            }
                            catch (Throwable throwable) {}
                        }
                    }
                }
            });
        }
    }
}

