/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiidostatis.defs;

import android.content.Context;
import android.net.wifi.WifiInfo;
import android.os.Process;
import android.telephony.CellLocation;
import android.telephony.cdma.CdmaCellLocation;
import android.telephony.gsm.GsmCellLocation;
import com.yy.hiidostatis.api.StatisContent;
import com.yy.hiidostatis.api.StatisOption;
import com.yy.hiidostatis.defs.controller.OaidController;
import com.yy.hiidostatis.defs.interf.IStatisAPI;
import com.yy.hiidostatis.defs.listener.ActAdditionListenerController;
import com.yy.hiidostatis.defs.listener.ActListener;
import com.yy.hiidostatis.defs.listener.HiidoSdkAdditionDelegate;
import com.yy.hiidostatis.defs.monitor.ScreenMonitor;
import com.yy.hiidostatis.defs.monitor.TrafficMonitor;
import com.yy.hiidostatis.defs.obj.Act;
import com.yy.hiidostatis.defs.obj.EventElementInfo;
import com.yy.hiidostatis.defs.obj.EventInfo;
import com.yy.hiidostatis.defs.obj.Property;
import com.yy.hiidostatis.defs.obj.ShareType;
import com.yy.hiidostatis.inner.AbstractConfig;
import com.yy.hiidostatis.inner.GeneralProxy;
import com.yy.hiidostatis.inner.GeneralStatisTool;
import com.yy.hiidostatis.inner.implementation.CommonFiller;
import com.yy.hiidostatis.inner.util.ArdUtil;
import com.yy.hiidostatis.inner.util.DefaultPreference;
import com.yy.hiidostatis.inner.util.ProcessUtil;
import com.yy.hiidostatis.inner.util.ThreadPool;
import com.yy.hiidostatis.inner.util.Util;
import com.yy.hiidostatis.inner.util.cipher.Base64Util;
import com.yy.hiidostatis.inner.util.cipher.Coder;
import com.yy.hiidostatis.inner.util.hdid.DeviceProxy;
import com.yy.hiidostatis.inner.util.hdid.GAIDClient;
import com.yy.hiidostatis.inner.util.log.L;
import com.yy.hiidostatis.pref.HdStatisConfig;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URLEncoder;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public class StatisAPI
implements IStatisAPI {
    private static final int MAX_EVENT_FIELD_BYTES = 256;
    private static final long PRIORITY_INNER = -2L;
    private static final long PRIORITY_INNER_SECOND = -1L;
    private static final long PRIORITY_OUTER = 0L;
    private static final String KEY_MAGIC = "HiidoData";
    private Context mContext;
    private StatisOption mOption;
    private boolean mIsInit = false;
    private String sessionId = null;
    private GeneralStatisTool mGeneralStatisTool;
    private AbstractConfig mAbstractConfig;
    private ActAdditionListenerController mActListernerController = new ActAdditionListenerController();
    private Long launchTime = null;
    private String testServer;
    private boolean isAbroad = false;
    public int businessType = 100;
    private String appsflyer;

    @Override
    public StatisOption getOption() {
        return this.mOption;
    }

    public Context getContext() {
        return this.mContext;
    }

    @Override
    public void init(final Context context, final StatisOption option) {
        ThreadPool.getPool().executeQueue(new Runnable(){

            @Override
            public void run() {
                StatisAPI.this.mAbstractConfig = HdStatisConfig.getConfig(option == null ? null : option.getAppkey());
                StatisAPI.this.setTestServer(StatisAPI.this.testServer);
                StatisAPI.this.setAbroad(StatisAPI.this.isAbroad);
                StatisAPI.this.setBusinessType(StatisAPI.this.businessType);
                if (!StatisAPI.this.mIsInit) {
                    StatisAPI.this.mContext = context == null ? StatisAPI.this.mContext : context.getApplicationContext();
                    StatisAPI.this.mOption = option;
                    if (StatisAPI.this.mContext == null || StatisAPI.this.mOption == null || Util.empty(StatisAPI.this.mOption.getAppkey())) {
                        L.errorOn(this, "init incorrect! Input context is null || mOption is null || Appkey is null", new Object[0]);
                    } else {
                        StatisAPI.this.mGeneralStatisTool = GeneralProxy.getGeneralStatisInstance(StatisAPI.this.mContext, StatisAPI.this.mAbstractConfig);
                        L.infoOn(this, "init finish! appId:%s; appkey:%s; from:%s; ver:%s; sdkver:%s", StatisAPI.this.mOption.getAppId(), StatisAPI.this.mOption.getAppkey(), StatisAPI.this.mOption.getFrom(), StatisAPI.this.mOption.getVer(), StatisAPI.this.mAbstractConfig.getSdkVer());
                    }
                    L.info(this, "statisApi init. Context:%s ;api:%s", StatisAPI.this.mContext, this);
                    StatisAPI.this.mIsInit = true;
                } else {
                    L.warnOn(this, "statisAPI only be init once", new Object[0]);
                }
            }
        });
    }

    public void setTestServer(final String testServer) {
        ThreadPool.getPool().executeQueue(new Runnable(){

            @Override
            public void run() {
                StatisAPI.this.testServer = testServer;
                if (StatisAPI.this.mAbstractConfig != null) {
                    ((HdStatisConfig)StatisAPI.this.mAbstractConfig).setTestServer(testServer);
                }
            }
        });
    }

    public void setAbroad(final boolean isAbroad) {
        ThreadPool.getPool().executeQueue(new Runnable(){

            @Override
            public void run() {
                StatisAPI.this.isAbroad = isAbroad;
                if (StatisAPI.this.mAbstractConfig != null) {
                    StatisAPI.this.mAbstractConfig.setAbroad(isAbroad);
                }
            }
        });
    }

    public void setBusinessType(final int businessType) {
        ThreadPool.getPool().executeQueue(new Runnable(){

            @Override
            public void run() {
                StatisAPI.this.businessType = businessType;
                if (StatisAPI.this.mAbstractConfig != null) {
                    StatisAPI.this.mAbstractConfig.setBusinessType(businessType);
                }
            }
        });
    }

    private StatisContent fillBusinessComm(StatisContent content, boolean isReadOnly) {
        StatisOption option;
        if (isReadOnly) {
            content = content.copy();
        }
        if ((option = this.getOption()) != null) {
            content.put("app", option.getAppId());
            content.put("appkey", option.getAppkey());
            content.put("from", option.getFrom());
            content.put("ver", option.getVer());
        }
        if (this.sessionId != null) {
            content.put("sessionid", this.sessionId);
        }
        if (this.appsflyer != null) {
            content.put("mdsr", this.appsflyer);
        }
        content.put("timezone", ArdUtil.getTimeZone());
        content.put("oaid", OaidController.INSTANCE.oaid());
        if (this.mAbstractConfig != null && this.mAbstractConfig.isAbroad()) {
            content.put("gaid", GAIDClient.getGAID(this.mContext));
        }
        return content;
    }

    private boolean reportStatisticContentAll(String act, StatisContent content, boolean isReadOnly, boolean fillCommon, boolean fillConcrete, boolean isCover, Long order) {
        if (this.mContext == null || Util.empty(act) || Util.empty(content)) {
            L.error(StatisAPI.class, "Input error! context is null || act is null || content is null ", new Object[0]);
            return false;
        }
        try {
            StatisContent newContent = this.fillBusinessComm(content, isReadOnly);
            return this.mGeneralStatisTool.reportCustom(this.mContext, act, newContent, fillCommon, fillConcrete, isCover, order);
        }
        catch (Throwable e) {
            L.errorOn(this, "reportStatisticContentAll exception .%s", e);
            return false;
        }
    }

    public void reportStatisticContentTemporary(final String act, final StatisContent content, final boolean fillCommon, final boolean isCover) {
        ThreadPool.getPool().executeQueue(new Runnable(){

            @Override
            public void run() {
                if (StatisAPI.this.mContext == null || Util.empty(act) || Util.empty(content)) {
                    L.error(StatisAPI.class, "Input error! context is null || act is null || content is null ", new Object[0]);
                    return;
                }
                try {
                    if (!fillCommon) {
                        CommonFiller.fillKey(content, act);
                    }
                    StatisContent newContent = StatisAPI.this.fillBusinessComm(content, false);
                    StatisAPI.this.mGeneralStatisTool.reportCustomTemporary(StatisAPI.this.mContext, act, newContent, fillCommon, fillCommon, isCover);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public void reportStatisticContent(final String act, final StatisContent content, final boolean fillCommon, final boolean isCover) {
        ThreadPool.getPool().executeQueue(new Runnable(){

            @Override
            public void run() {
                if (!fillCommon) {
                    CommonFiller.fillKey(content, act);
                }
                StatisAPI.this.reportStatisticContentAll(act, content, true, fillCommon, fillCommon, isCover, null);
            }
        });
    }

    public void reportStatisticContent(final String act, final StatisContent content, final boolean fillCommon, final boolean isCover, final boolean isPriority) {
        ThreadPool.getPool().executeQueue(new Runnable(){

            @Override
            public void run() {
                if (!fillCommon) {
                    CommonFiller.fillKey(content, act);
                }
                StatisAPI.this.reportStatisticContentAll(act, content, true, fillCommon, fillCommon, isCover, isPriority ? Long.valueOf(0L) : null);
            }
        });
    }

    public void reportStatisticContentWithNoComm(Context context, final String act, final StatisContent content) {
        ThreadPool.getPool().executeQueue(new Runnable(){

            @Override
            public void run() {
                if (Util.empty(act) || Util.empty(content)) {
                    L.error(StatisAPI.class, "Input error! act is null || content is null ", new Object[0]);
                    return;
                }
                StatisContent cp = content.copy();
                CommonFiller.fillKey(cp, act);
                StatisAPI.this.reportStatisticContentAll(act, cp, false, false, false, false, null);
            }
        });
    }

    public void reportStatisticContentWithNoComm(Context context, final String act, final StatisContent content, final boolean isPriority) {
        ThreadPool.getPool().executeQueue(new Runnable(){

            @Override
            public void run() {
                if (Util.empty(act) || Util.empty(content)) {
                    L.error(StatisAPI.class, "Input error! act is null || content is null ", new Object[0]);
                    return;
                }
                StatisContent cp = content.copy();
                CommonFiller.fillKey(cp, act);
                StatisAPI.this.reportStatisticContentAll(act, cp, false, false, false, false, isPriority ? Long.valueOf(0L) : null);
            }
        });
    }

    private boolean reportStatisticContentInner(Act act, StatisContent content, boolean fillCommon, boolean fillConcrete, boolean isPriority) {
        try {
            ActListener listener = this.mActListernerController.getListerner(act);
            StatisContent addContent = this.mActListernerController.getActAddition(act, listener);
            if (addContent != null) {
                content.putContent(addContent, false);
            }
            Long order = null;
            if (isPriority) {
                order = -2L;
                if (Act.MBSDK_APPLIST == act) {
                    order = -1L;
                }
            }
            return this.reportStatisticContentAll(act.toString(), content, false, fillCommon, fillConcrete, false, order);
        }
        catch (Throwable e) {
            L.errorOn(StatisAPI.class, "reportStatisticContentInner act:%s ,exception:%s", act.toString(), e);
            return false;
        }
    }

    @Override
    public void reportInstall(final int type, final IStatisAPI.ReportResult resultReceiver) {
        ThreadPool.getPool().executeQueue(new Runnable(){

            @Override
            public void run() {
                if (StatisAPI.this.mContext == null) {
                    L.warn(StatisAPI.class, "Input context is null", new Object[0]);
                    if (resultReceiver != null) {
                        resultReceiver.onReportResult(false);
                    }
                }
                StatisContent content = new StatisContent();
                content.put("new", type);
                content.put("htype", DeviceProxy.getType(StatisAPI.this.mContext));
                content.put("hfrom", DeviceProxy.getHFrom(StatisAPI.this.mContext));
                content.put("htime", DeviceProxy.getCreateTime(StatisAPI.this.mContext));
                content.put("sdpm", DeviceProxy.getSdPermission(StatisAPI.this.mContext));
                boolean b = StatisAPI.this.reportStatisticContentInner(Act.MBSDK_INSTALL, content, true, true, true);
                if (resultReceiver != null) {
                    resultReceiver.onReportResult(b);
                }
            }
        });
    }

    public void reportRun(final long uid) {
        ThreadPool.getPool().executeQueue(new Runnable(){

            @Override
            public void run() {
                StatisAPI.this.launchTime = System.currentTimeMillis();
                StatisContent content = new StatisContent();
                content.put("uid", uid);
                content.put("rot", ArdUtil.isRoot() ? 1 : 0);
                WifiInfo wi = ArdUtil.getWifiInfo(StatisAPI.this.mContext);
                if (wi != null) {
                    content.put("bssid", wi.getBSSID());
                    content.put("ssid", wi.getSSID());
                    content.put("rssi", wi.getRssi());
                }
                wi = null;
                StatisAPI.this.reportStatisticContentInner(Act.MBSDK_RUN, content, true, true, true);
            }
        });
    }

    public void reportDo(final long uid) {
        ThreadPool.getPool().executeQueue(new Runnable(){

            @Override
            public void run() {
                StatisContent content = new StatisContent();
                content.put("uid", uid);
                content.put("htype", DeviceProxy.getType(StatisAPI.this.mContext));
                content.put("hfrom", DeviceProxy.getHFrom(StatisAPI.this.mContext));
                content.put("htime", DeviceProxy.getCreateTime(StatisAPI.this.mContext));
                content.put("sdpm", DeviceProxy.getSdPermission(StatisAPI.this.mContext));
                try {
                    content.put("srvtm", GeneralProxy.getGeneralConfigInstance(StatisAPI.this.mContext, StatisAPI.this.mAbstractConfig).getSrvTime());
                }
                catch (Throwable e) {
                    L.error(this, "get srvtm error,%s", e);
                }
                StatisAPI.this.reportStatisticContentInner(Act.MBSDK_DO, content, true, true, true);
            }
        });
    }

    public void reportDo5(final long uid) {
        ThreadPool.getPool().executeQueue(new Runnable(){

            @Override
            public void run() {
                StatisContent content = new StatisContent();
                content.put("uid", uid);
                StatisAPI.this.reportStatisticContentInner(Act.MBSDK_DO5, content, true, true, true);
            }
        });
    }

    public void reportDoShort(final long uid, final Map<String, String> prop) {
        ThreadPool.getPool().executeQueue(new Runnable(){

            @Override
            public void run() {
                Long dur;
                StatisContent content = new StatisContent();
                content.put("uid", uid);
                content.put("sid", (String)prop.get("sid"));
                content.put("subsid", (String)prop.get("subsid"));
                content.put("auid", (String)prop.get("auid"));
                if (StatisAPI.this.launchTime != null && (dur = Long.valueOf(System.currentTimeMillis() - StatisAPI.this.launchTime)) > 0L) {
                    content.put("dur", dur);
                }
                content.put("prop", StatisAPI.this.getPropString(prop));
                StatisAPI.this.reportStatisticContentInner(Act.MBSDK_DO1, content, true, true, true);
            }
        });
    }

    private String getPropString(Map<String, String> prop) {
        String propStr = null;
        if (prop != null && prop.size() > 0) {
            StringBuffer sb = new StringBuffer();
            Set<Map.Entry<String, String>> entrySet = prop.entrySet();
            for (Map.Entry<String, String> entry : entrySet) {
                try {
                    sb.append(URLEncoder.encode(entry.getKey(), "UTF-8")).append("=").append(URLEncoder.encode(entry.getValue(), "UTF-8")).append(",");
                }
                catch (Throwable throwable) {}
            }
            if (sb.length() > 0) {
                propStr = sb.toString().substring(0, sb.length() - 1);
            }
            sb.setLength(0);
            sb = null;
            entrySet = null;
        }
        return propStr;
    }

    public void reportLogin(final long uid) {
        ThreadPool.getPool().executeQueue(new Runnable(){

            @Override
            public void run() {
                StatisContent content = new StatisContent();
                content.put("uid", uid);
                StatisAPI.this.reportStatisticContentInner(Act.MBSDK_LOGIN, content, true, true, false);
            }
        });
    }

    public void reportAppsflyer(final String data) {
        ThreadPool.getPool().executeQueue(new Runnable(){

            @Override
            public void run() {
                StatisAPI.this.appsflyer = data;
                StatisContent content = new StatisContent();
                content.put("mdsr", data);
                StatisAPI.this.reportStatisticContentInner(Act.MBSDK_APPSFLYER, content, true, true, false);
            }
        });
    }

    public void reportShare(final String platform, final int mediaType, final String content, final ShareType stype, final String errmsg, final String screen, final String userData) {
        ThreadPool.getPool().executeQueue(new Runnable(){

            @Override
            public void run() {
                StatisContent cont = new StatisContent();
                cont.put("platform", platform);
                cont.put("mediatype", mediaType);
                cont.put("content", content);
                cont.put("stype", stype.ordinal());
                cont.put("errmsg", errmsg);
                cont.put("screen", screen);
                cont.put("userdata", userData);
                StatisAPI.this.reportStatisticContentInner(Act.MBSDK_SHARE, cont, true, true, false);
            }
        });
    }

    public void reportIM(final String sender, final String receiver, final String content, final Date editTime, final Date sendTime, final String errormsg, final int mediaType, final String userData) {
        ThreadPool.getPool().executeQueue(new Runnable(){

            @Override
            public void run() {
                StatisContent cont = new StatisContent();
                cont.put("sender", sender);
                cont.put("receiver", receiver);
                cont.put("content", content);
                cont.put("edit_time", editTime.getTime() / 1000L);
                cont.put("send_time", sendTime.getTime() / 1000L);
                cont.put("errormsg", errormsg);
                cont.put("mediatype", mediaType);
                cont.put("userdata", userData);
                StatisAPI.this.reportStatisticContentInner(Act.MBSDK_IM, cont, true, true, false);
            }
        });
    }

    public void reportUrlScheme(final String scheme, final String host, final int port, final String path, final String query) {
        ThreadPool.getPool().executeQueue(new Runnable(){

            @Override
            public void run() {
                StatisContent content = new StatisContent();
                content.put("scheme", scheme);
                content.put("host", host);
                content.put("port", port);
                content.put("path", path);
                content.put("query", query);
                StatisAPI.this.reportStatisticContentInner(Act.MBSDK_URL_SCHEME, content, true, true, false);
            }
        });
    }

    public void reportReg(final String uid, final String name, final String type, final Map<String, String> prop) {
        ThreadPool.getPool().executeQueue(new Runnable(){

            @Override
            public void run() {
                StatisContent content = new StatisContent();
                content.put("uid", uid);
                content.put("acc", uid);
                content.put("name", name);
                content.put("type", type);
                content.put("prop", StatisAPI.this.getPropString(prop));
                StatisAPI.this.reportStatisticContentInner(Act.MBSDK_REG, content, true, true, false);
            }
        });
    }

    public void reportAction(final long uid, final String appa, final String page, final String event) {
        ThreadPool.getPool().executeQueue(new Runnable(){

            @Override
            public void run() {
                if (Util.empty(appa) && Util.empty(page) && Util.empty(event)) {
                    L.warn(StatisAPI.class, "Input appa is null && page is null && event is null ", new Object[0]);
                    return;
                }
                StatisContent content = new StatisContent();
                content.put("uid", uid);
                content.put("appa", appa);
                content.put("page", page);
                content.put("even", event);
                StatisAPI.this.reportStatisticContentInner(Act.MBSDK_ACTION, content, true, true, false);
            }
        });
    }

    @Override
    public void reportLanuch(final long uid, final String appa, final StatisContent sensor) {
        ThreadPool.getPool().executeQueue(new Runnable(){

            @Override
            public void run() {
                if (Util.empty(appa)) {
                    L.warn(StatisAPI.class, "Input appa is null ", new Object[0]);
                    return;
                }
                StatisContent content = new StatisContent();
                content.put("uid", uid);
                content.put("appa", appa);
                content.putContent(sensor, true);
                try {
                    content.put("alr", TrafficMonitor.instance.getAlr());
                    content.put("als", TrafficMonitor.instance.getAls());
                    content.put("apr", TrafficMonitor.instance.getApr());
                    content.put("aps", TrafficMonitor.instance.getAps());
                    int cht = (ScreenMonitor.instance.getClick() < 4 ? 0 : 2) | (ScreenMonitor.instance.getSlide() < 3 ? 0 : 1);
                    content.put("cht", cht);
                    content.put("pan", ScreenMonitor.instance.getSlide());
                    content.put("tap", ScreenMonitor.instance.getClick());
                }
                catch (Throwable e) {
                    L.warn(this, "reportLanuch exception=%s", e);
                }
                StatisAPI.this.reportStatisticContentInner(Act.MBSDK_LANUCH, content, true, true, false);
            }
        });
    }

    @Override
    public void reportPage(final long uid, final String page) {
        ThreadPool.getPool().executeQueue(new Runnable(){

            @Override
            public void run() {
                if (Util.empty(page)) {
                    L.warn(StatisAPI.class, "Input page is null ", new Object[0]);
                    return;
                }
                StatisContent content = new StatisContent();
                content.put("uid", uid);
                content.put("page", page);
                StatisAPI.this.reportStatisticContentInner(Act.MBSDK_PAGE, content, true, true, false);
            }
        });
    }

    @Override
    public void reportPageState(final long uid, final String page, final long duration) {
        ThreadPool.getPool().executeQueue(new Runnable(){

            @Override
            public void run() {
                if (Util.empty(page)) {
                    L.warn(StatisAPI.class, "Input page is null ", new Object[0]);
                    return;
                }
                StatisContent content = new StatisContent();
                content.put("uid", uid);
                content.put("page", page);
                content.put("duration", duration);
                StatisAPI.this.reportStatisticContentInner(Act.MBSDK_PAGE_STATE, content, true, true, false);
            }
        });
    }

    @Override
    public void reportEvent(final long uid, final String event) {
        ThreadPool.getPool().executeQueue(new Runnable(){

            @Override
            public void run() {
                if (Util.empty(event)) {
                    L.warn(StatisAPI.class, "Input event is null ", new Object[0]);
                    return;
                }
                StatisContent content = new StatisContent();
                content.put("uid", uid);
                content.put("event", event);
                try {
                    content.put("srvtm", GeneralProxy.getGeneralConfigInstance(StatisAPI.this.mContext, StatisAPI.this.mAbstractConfig).getSrvTime());
                }
                catch (Throwable e) {
                    L.error(this, "get srvtm error,%s", e);
                }
                L.debug(this, "add mbsdkevent %s", event);
                StatisAPI.this.reportStatisticContentInner(Act.MBSDK_EVENT, content, true, true, false);
            }
        });
    }

    public void reportError(final long uid, final String eid, final String emsg, final String param) {
        ThreadPool.getPool().executeQueue(new Runnable(){

            @Override
            public void run() {
                StatisContent content = new StatisContent();
                content.put("uid", uid);
                content.put("eid", eid);
                content.put("emsg", emsg);
                content.put("parm", param);
                StatisAPI.this.reportStatisticContentInner(Act.MBSDK_ERROR, content, true, true, false);
            }
        });
    }

    @Override
    public void reportCrash(final long uid, final String crashMsg) {
        ThreadPool.getPool().executeQueue(new Runnable(){

            @Override
            public void run() {
                if (StatisAPI.this.mContext == null) {
                    L.warn(StatisAPI.class, "Input context is null", new Object[0]);
                    return;
                }
                StatisContent content = new StatisContent();
                content.put("uid", uid);
                content.put("crashmsg", crashMsg);
                content.put("rtyp", 2);
                content.put("rot", ArdUtil.isRoot() ? 1 : 0);
                content.put("tram", ArdUtil.getTotalMemory(StatisAPI.this.mContext));
                content.put("trom", ArdUtil.getTotalInternalStorgeSize());
                content.put("tsd", ArdUtil.getTotalExternalStorgeSize());
                content.put("aram", ArdUtil.getAvailMemory(StatisAPI.this.mContext));
                content.put("arom", ArdUtil.getAvailInternalStorgeSize());
                content.put("asd", ArdUtil.getAvailExternalStorgeSize());
                content.put("ctyp", "1");
                content.put("crashid", UUID.randomUUID().toString());
                if (StatisAPI.this.launchTime != null) {
                    content.put("ltime", (System.currentTimeMillis() - StatisAPI.this.launchTime) / 1000L);
                }
                content.put("cpage", DefaultPreference.getPreference().getPrefString(StatisAPI.this.mContext, "PREF_CPAGE", null));
                content.put("cpkg", ArdUtil.getPackageName(StatisAPI.this.mContext));
                content.put("cthread", ProcessUtil.getCurProcessName(StatisAPI.this.mContext) + "#" + Process.myTid());
                StatisAPI.this.reportStatisticContentInner(Act.MBSDK_CRASH, content, true, true, false);
            }
        });
    }

    @Override
    public void reportCrashInner(final long uid, final Throwable throwable) {
        ThreadPool.getPool().executeQueue(new Runnable(){

            @Override
            public void run() {
                if (StatisAPI.this.mContext == null) {
                    L.warn(StatisAPI.class, "Input context is null", new Object[0]);
                    return;
                }
                StatisContent content = new StatisContent();
                content.put("uid", uid);
                content.put("crashmsg", StatisAPI.this.getErrorInfo(throwable));
                content.put("rtyp", 1);
                content.put("rot", ArdUtil.isRoot() ? 1 : 0);
                content.put("tram", ArdUtil.getTotalMemory(StatisAPI.this.mContext));
                content.put("trom", ArdUtil.getTotalInternalStorgeSize());
                content.put("tsd", ArdUtil.getTotalExternalStorgeSize());
                content.put("aram", ArdUtil.getAvailMemory(StatisAPI.this.mContext));
                content.put("arom", ArdUtil.getAvailInternalStorgeSize());
                content.put("asd", ArdUtil.getAvailExternalStorgeSize());
                content.put("ctyp", "1");
                content.put("crashid", UUID.randomUUID().toString());
                if (StatisAPI.this.launchTime != null) {
                    content.put("ltime", (System.currentTimeMillis() - StatisAPI.this.launchTime) / 1000L);
                }
                content.put("cpage", DefaultPreference.getPreference().getPrefString(StatisAPI.this.mContext, "PREF_CPAGE", null));
                content.put("cpkg", ArdUtil.getPackageName(StatisAPI.this.mContext));
                content.put("cthread", ProcessUtil.getCurProcessName(StatisAPI.this.mContext) + "#" + Process.myTid());
                StatisAPI.this.reportStatisticContentInner(Act.MBSDK_CRASH, content, true, true, false);
            }
        });
    }

    @Override
    public boolean reportDevice(long uid, StatisContent extra) {
        this.reportDevice(uid, extra, null);
        return true;
    }

    @Override
    public boolean reportDevice(long uid) {
        this.reportDevice(uid, null, null);
        return true;
    }

    @Override
    public boolean reportInstall(int type) {
        this.reportInstall(type, null);
        return true;
    }

    @Override
    public void reportCrash(long uid, Throwable throwable) {
        this.reportCrash(uid, this.getErrorInfo(throwable));
    }

    private String getErrorInfo(Throwable throwable) {
        try {
            StringWriter writer = new StringWriter();
            PrintWriter pw = new PrintWriter(writer);
            throwable.printStackTrace(pw);
            String errorinfo = ((Object)writer).toString();
            pw.close();
            ((Writer)writer).close();
            pw = null;
            writer = null;
            return errorinfo;
        }
        catch (Throwable e) {
            L.error(StatisAPI.class, "SDK Get Crash Error Info Exception!" + e, new Object[0]);
            return "SDK Get Crash Error Info Exception!" + e;
        }
    }

    public void reportSuccess(final long uid, final String aid, final String type, final long duration, final String parm) {
        ThreadPool.getPool().executeQueue(new Runnable(){

            @Override
            public void run() {
                if (StatisAPI.this.mContext == null) {
                    L.warn(StatisAPI.class, "Input context is null!", new Object[0]);
                    return;
                }
                StatisContent statisContent = new StatisContent();
                statisContent.put("uid", uid);
                statisContent.put("actionid", aid);
                statisContent.put("type", type);
                statisContent.put("duration", duration);
                statisContent.put("parm", parm);
                StatisAPI.this.reportStatisticContentInner(Act.MBSDK_SUCCESS, statisContent, true, true, false);
            }
        });
    }

    public void reportFailure(final long uid, final String aid, final String type, final String failCode, final String failMsg, final String parm) {
        ThreadPool.getPool().executeQueue(new Runnable(){

            @Override
            public void run() {
                if (StatisAPI.this.mContext == null) {
                    L.warn(StatisAPI.class, "Input context is null!", new Object[0]);
                    return;
                }
                StatisContent statisContent = new StatisContent();
                statisContent.put("uid", uid);
                statisContent.put("actionid", aid);
                statisContent.put("type", type);
                statisContent.put("failcode", failCode);
                statisContent.put("failmsg", failMsg);
                statisContent.put("parm", parm);
                StatisAPI.this.reportStatisticContentInner(Act.MBSDK_FAILURE, statisContent, true, true, false);
            }
        });
    }

    public void reportCustomContent(final long uid, final String type, final String content) {
        ThreadPool.getPool().executeQueue(new Runnable(){

            @Override
            public void run() {
                if (StatisAPI.this.mContext == null || content == null || content.length() == 0) {
                    L.warn(StatisAPI.class, "Input context is null || content is null", new Object[0]);
                    return;
                }
                StatisContent statisContent = new StatisContent();
                statisContent.put("uid", uid);
                statisContent.put("type", type);
                statisContent.put("content", content);
                StatisAPI.this.reportStatisticContentInner(Act.MBSDK_REPORT, statisContent, true, true, false);
            }
        });
    }

    @Override
    public void reportAppList(long uid, String type, String applist) {
        this.reportAppList(uid, type, applist, null);
    }

    @Override
    public void reportAppList(final long uid, final String type, final String applist, final String applist2) {
        ThreadPool.getPool().executeQueue(new Runnable(){

            @Override
            public void run() {
                if (!(applist != null && applist.length() != 0 || applist2 != null && applist2.length() != 0)) {
                    L.warn(StatisAPI.class, "applist is empty\uff0cno report applist !", new Object[0]);
                    return;
                }
                StatisContent content = new StatisContent();
                try {
                    String act = Act.MBSDK_APPLIST.toString();
                    CommonFiller.fillCommonNew(StatisAPI.this.mContext, content, act, StatisAPI.this.mAbstractConfig.getSdkVer());
                    CommonFiller.fillConcreteInfoNew(StatisAPI.this.mContext, content);
                    String desKey = content.get("act") + content.get("time") + StatisAPI.KEY_MAGIC;
                    desKey = Coder.encryptMD5(desKey);
                    desKey = desKey.toLowerCase().substring(0, 8);
                    L.verbose(StatisAPI.class, "des key is %s", desKey);
                    String applistEncrypt = Coder.encryptDES(applist, desKey);
                    L.verbose(StatisAPI.class, "applist length is %d", applistEncrypt.length());
                    content.put("uid", uid);
                    content.put("type", type);
                    content.put("applist", applistEncrypt);
                    content.put("applist2", applist2);
                    StatisAPI.this.reportStatisticContentInner(Act.MBSDK_APPLIST, content, false, false, true);
                }
                catch (Throwable e) {
                    L.error(StatisAPI.class, "encrypt exception %s", e);
                }
            }
        });
    }

    public void reportTimesEvent(long uid, String eid) {
        this.reportTimesEvent(uid, eid, null);
    }

    public void reportTimesEvent(long uid, String eid, String label) {
        this.reportTimesEvent(uid, eid, label, null);
    }

    public void reportTimesEvent(final long uid, final String eid, final String label, Property property) {
        final Property pro = property == null ? null : property.copy();
        ThreadPool.getPool().executeQueue(new Runnable(){

            @Override
            public void run() {
                if (Util.empty(eid)) {
                    L.error(this, "eid is not allow null.", new Object[0]);
                    return;
                }
                if (eid.getBytes().length > 256) {
                    L.warn(this, "eid[%s] bytes[%d] must under %d bytes.", eid, eid.getBytes().length, 256);
                }
                if (!Util.empty(label) && label.getBytes().length > 256) {
                    L.warn(this, "label[%s] bytes[%d] must under %d bytes.", label, label.getBytes().length, 256);
                }
                EventInfo mEventInfo = new EventInfo();
                EventElementInfo event = new EventElementInfo(eid, 1);
                event.addParam(label);
                event.setProperty(pro);
                mEventInfo.addElem(event);
                String ev = mEventInfo.getResult();
                mEventInfo = null;
                event = null;
                StatisAPI.this.reportEvent(uid, ev);
            }
        });
    }

    public void reportCountEvent(long uid, String eid, double evalue) {
        this.reportCountEvent(uid, eid, evalue, null);
    }

    public void reportCountEvent(long uid, String eid, double evalue, String label) {
        this.reportCountEvent(uid, eid, evalue, label, null);
    }

    public void reportCountEvent(final long uid, final String eid, final double evalue, final String label, Property property) {
        final Property pro = property == null ? null : property.copy();
        ThreadPool.getPool().executeQueue(new Runnable(){

            @Override
            public void run() {
                if (Util.empty(eid)) {
                    L.error(this, "eid is not allow null.", new Object[0]);
                    return;
                }
                if (eid.getBytes().length > 256) {
                    L.warn(this, "eid[%s] bytes[%d] must under %d bytes.", eid, eid.getBytes().length, 256);
                }
                if (!Util.empty(label) && label.getBytes().length > 256) {
                    L.warn(this, "label[%s] bytes[%d] must under %d bytes.", label, label.getBytes().length, 256);
                }
                EventInfo mEventInfo = new EventInfo();
                EventElementInfo event = new EventElementInfo(eid, String.valueOf(evalue));
                event.addParam(label);
                event.setProperty(pro);
                mEventInfo.addElem(event);
                String ev = mEventInfo.getResult();
                mEventInfo = null;
                event = null;
                StatisAPI.this.reportEvent(uid, ev);
            }
        });
    }

    @Override
    public void reportSdkList(final long uid, final String sdkList) {
        ThreadPool.getPool().executeQueue(new Runnable(){

            @Override
            public void run() {
                if (StatisAPI.this.mContext == null || sdkList == null || sdkList.length() == 0) {
                    L.warn(StatisAPI.class, "Input context is null || sdkList is null", new Object[0]);
                    return;
                }
                String enSdkList = sdkList;
                try {
                    enSdkList = Base64Util.encode(enSdkList.getBytes("UTF-8"));
                }
                catch (Throwable e) {
                    L.error(StatisAPI.class, "encrypt exception %s", e);
                }
                StatisContent statisContent = new StatisContent();
                statisContent.put("uid", uid);
                statisContent.put("sdklist", enSdkList);
                StatisAPI.this.reportStatisticContentInner(Act.MBSDK_SDKLIST, statisContent, true, true, false);
            }
        });
    }

    @Override
    public void reportDevice(final long uid, final StatisContent extra, final IStatisAPI.ReportResult resultReceiver) {
        ThreadPool.getPool().executeQueue(new Runnable(){

            @Override
            public void run() {
                if (StatisAPI.this.mContext == null) {
                    L.warn(StatisAPI.class, "Input context is null", new Object[0]);
                    if (resultReceiver != null) {
                        resultReceiver.onReportResult(false);
                    }
                }
                StatisContent statisContent = new StatisContent();
                statisContent.put("uid", uid);
                statisContent.put("cpunum", ArdUtil.getCpuNum());
                statisContent.put("cpu", ArdUtil.getMaxCpuFreq());
                statisContent.put("memory", ArdUtil.getTotalMemory(StatisAPI.this.mContext));
                statisContent.put("rot", ArdUtil.isRoot() ? 1 : 0);
                if (extra != null) {
                    statisContent.putContent(extra, true);
                }
                boolean b = StatisAPI.this.reportStatisticContentInner(Act.MBSDK_SDKDEVICE, statisContent, true, true, false);
                if (resultReceiver != null) {
                    resultReceiver.onReportResult(b);
                }
            }
        });
    }

    public void reportLocation(final long uid, final double longitude, final double latitude, final double altitude, final IStatisAPI.ReportResult resultReceiver) {
        ThreadPool.getPool().executeQueue(new Runnable(){

            @Override
            public void run() {
                WifiInfo wi;
                if (StatisAPI.this.mContext == null) {
                    L.warn(StatisAPI.class, "Input context is null", new Object[0]);
                    if (resultReceiver != null) {
                        resultReceiver.onReportResult(false);
                    }
                }
                StatisContent statisContent = new StatisContent();
                statisContent.put("uid", uid);
                statisContent.put("lon", longitude);
                statisContent.put("lat", latitude);
                statisContent.put("alt", altitude);
                CellLocation c = ArdUtil.getCellId(StatisAPI.this.mContext);
                if (c != null) {
                    if (c instanceof GsmCellLocation) {
                        statisContent.put("ceid", ((GsmCellLocation)c).getCid());
                        statisContent.put("lac", ((GsmCellLocation)c).getLac());
                    } else if (c instanceof CdmaCellLocation) {
                        statisContent.put("ceid", ((CdmaCellLocation)c).getBaseStationId());
                        statisContent.put("lac", ((CdmaCellLocation)c).getNetworkId());
                    }
                    c = null;
                }
                if ((wi = ArdUtil.getWifiInfo(StatisAPI.this.mContext)) != null) {
                    statisContent.put("bssid", wi.getBSSID());
                    statisContent.put("ssid", wi.getSSID());
                    statisContent.put("rssi", wi.getRssi());
                    wi = null;
                }
                boolean b = StatisAPI.this.reportStatisticContentInner(Act.MBSDK_LOCATION, statisContent, true, true, false);
                if (resultReceiver != null) {
                    resultReceiver.onReportResult(b);
                }
            }
        });
    }

    public void reportFeedback(final long uid, final String fbId, final String cont, final String link, final String remk, final IStatisAPI.ReportResult resultReceiver) {
        ThreadPool.getPool().executeQueue(new Runnable(){

            @Override
            public void run() {
                if (StatisAPI.this.mContext == null || Util.empty(cont)) {
                    L.warn(StatisAPI.class, "Input context is null||cont is null", new Object[0]);
                    if (resultReceiver != null) {
                        resultReceiver.onReportResult(false);
                    }
                }
                StatisContent statisContent = new StatisContent();
                statisContent.put("uid", uid);
                statisContent.put("fbid", fbId);
                statisContent.put("cont", cont);
                statisContent.put("link", link);
                statisContent.put("remk", remk);
                boolean b = StatisAPI.this.reportStatisticContentInner(Act.MBSDK_FBACK, statisContent, true, true, false);
                if (resultReceiver != null) {
                    resultReceiver.onReportResult(b);
                }
            }
        });
    }

    public void reportPushToken(final long uid, final String token) {
        ThreadPool.getPool().executeQueue(new Runnable(){

            @Override
            public void run() {
                if (StatisAPI.this.mContext == null || Util.empty(token)) {
                    L.warn(StatisAPI.class, "Input context is null||token is null", new Object[0]);
                    return;
                }
                StatisContent statisContent = new StatisContent();
                statisContent.put("uid", uid);
                statisContent.put("pushtoken", token);
                StatisAPI.this.reportStatisticContentInner(Act.MBSDK_PUSH, statisContent, true, true, false);
            }
        });
    }

    public void addActAdditionListener(ActListener listener) {
        this.mActListernerController.add(listener);
    }

    public void removeActAdditionListener(ActListener listener) {
        this.mActListernerController.remove(listener);
    }

    public HiidoSdkAdditionDelegate getAdditionParamsDelegate() {
        return this.mActListernerController.getHiidoSdkAdditionDelegate();
    }

    public void setAdditionParamsDelegate(HiidoSdkAdditionDelegate hiidoSdkAdditionDelegate) {
        this.mActListernerController.setHiidoSdkAdditionDelegate(hiidoSdkAdditionDelegate);
    }

    public void generateSession() {
        try {
            this.sessionId = Coder.encryptMD5(UUID.randomUUID().toString()).substring(0, 20);
            L.brief("generate new session:%s", this.sessionId);
        }
        catch (Throwable e) {
            L.error(this, "generateSession exception:%s", e);
        }
    }

    @Override
    public String getSession() {
        return this.sessionId;
    }

    @Override
    public void setSession(String sessionId) {
        if (sessionId == null || sessionId.isEmpty()) {
            this.generateSession();
        } else {
            this.sessionId = sessionId;
        }
    }

    @Override
    public IStatisAPI create() {
        return new StatisAPI();
    }

    public void exit() {
        this.sessionId = null;
        this.launchTime = null;
    }

    @Override
    public Long getLaunchTime() {
        return this.launchTime;
    }

    @Override
    public void reportRecentAppList(final long uid, final String userApp, final String systemApp) {
        ThreadPool.getPool().executeQueue(new Runnable(){

            @Override
            public void run() {
                if (!(userApp != null && userApp.length() != 0 || systemApp != null && systemApp.length() != 0)) {
                    L.warn(StatisAPI.class, "applist is empty\uff0cno report applist !", new Object[0]);
                    return;
                }
                StatisContent content = new StatisContent();
                try {
                    String act = Act.MBSDK_RECENT_APPLIST.toString();
                    CommonFiller.fillCommonNew(StatisAPI.this.mContext, content, act, StatisAPI.this.mAbstractConfig.getSdkVer());
                    CommonFiller.fillConcreteInfoNew(StatisAPI.this.mContext, content);
                    String desKey = content.get("act") + content.get("time") + StatisAPI.KEY_MAGIC;
                    desKey = Coder.encryptMD5(desKey);
                    desKey = desKey.toLowerCase().substring(0, 8);
                    L.verbose(StatisAPI.class, "des key is %s", desKey);
                    content.put("uid", uid);
                    String encryptUserApp = Coder.encryptDES(userApp == null ? "" : userApp, desKey);
                    content.put("userapp", encryptUserApp);
                    String encryptSystemApp = Coder.encryptDES(systemApp == null ? "" : systemApp, desKey);
                    content.put("systemapp", encryptSystemApp);
                    L.verbose(StatisAPI.class, "applist length is %d", encryptUserApp.length());
                    StatisAPI.this.reportStatisticContentInner(Act.MBSDK_RECENT_APPLIST, content, false, false, true);
                }
                catch (Throwable e) {
                    L.error(StatisAPI.class, "encrypt exception %s", e);
                }
            }
        });
    }
}

