/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiidostatis.defs;

import android.content.Context;
import com.yy.hiidostatis.defs.interf.IConfigAPI;
import com.yy.hiidostatis.inner.GeneralConfigTool;
import com.yy.hiidostatis.inner.GeneralProxy;
import com.yy.hiidostatis.inner.implementation.CommonFiller;
import com.yy.hiidostatis.inner.util.hdid.DeviceProxy;
import com.yy.hiidostatis.inner.util.log.L;
import com.yy.hiidostatis.pref.HdStatisConfig;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONObject;

public class ConfigAPI
implements IConfigAPI {
    private GeneralConfigTool mGeneralConfigTool;

    public ConfigAPI(Context context, String appkey) {
        this.mGeneralConfigTool = GeneralProxy.getGeneralConfigInstance(context, HdStatisConfig.getConfig(appkey));
    }

    private JSONObject getConfig(String r, Map<String, String> params, Context context, boolean isCache, boolean isDecrypt) throws Exception {
        String result = isCache ? this.mGeneralConfigTool.getCache(r, params, context, isDecrypt) : this.mGeneralConfigTool.get(r, params, context, isDecrypt);
        return result == null || result.length() == 0 ? null : new JSONObject(result);
    }

    @Override
    public JSONObject getAppListConfig(Context context, boolean isCache) {
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("sys", "2");
            String imei = CommonFiller.getIMEI(context);
            params.put("mid", imei == null || imei.isEmpty() ? DeviceProxy.getHdid(context) : imei);
            return this.getConfig("api/getAppConfig", params, context, isCache, true);
        }
        catch (Throwable e) {
            L.error(ConfigAPI.class, "getAppListConfig error! %s", e);
            return null;
        }
    }

    public JSONObject getDeviceConfig(Context context, String appkey, String deviceid, long uid, boolean isCache) {
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("appkey", appkey);
            params.put("sys", "2");
            if (deviceid != null) {
                params.put("deviceid", deviceid);
            }
            params.put("uid", uid + "");
            return this.getConfig("api/getDeviceConfig", params, context, isCache, true);
        }
        catch (Throwable e) {
            L.error(ConfigAPI.class, "getDeviceConfig error! %s", e);
            return null;
        }
    }

    @Override
    public JSONObject getSdkListConfig(Context context, boolean isCache) {
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("sys", "2");
            return this.getConfig("api/getSdkListConfig", params, context, isCache, true);
        }
        catch (Throwable e) {
            L.error(ConfigAPI.class, "geSdkListConfig error! %s", e);
            return null;
        }
    }

    @Override
    public JSONObject getSdkVer(Context context, boolean isCache) {
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("sys", "2");
            params.put("type", "11");
            params.put("ver", this.mGeneralConfigTool.getConfig().getSdkVer());
            return this.getConfig("api/getSdkVer", params, context, isCache, false);
        }
        catch (Throwable e) {
            L.error(ConfigAPI.class, "getSdkVer error! %s", e);
            return null;
        }
    }

    @Override
    public String getOnlineConfigs(Context context, String appKey) {
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("appkey", appKey);
            String result = this.mGeneralConfigTool.get("api/getOnlineConfig", params, context, true);
            return result;
        }
        catch (Throwable e) {
            L.error(ConfigAPI.class, "getSdkVer error! %s", e);
            return null;
        }
    }
}

