/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiidostatis.inner.util.http;

import android.text.TextUtils;
import com.yy.hiidostatis.inner.util.http.CacheIp;
import com.yy.hiidostatis.inner.util.http.HttpUtil;
import com.yy.hiidostatis.inner.util.http.IStatisHttpUtil;
import com.yy.hiidostatis.inner.util.log.L;
import java.io.IOException;
import java.util.Random;

public abstract class AbstractStatisHttpUtil
implements IStatisHttpUtil {
    protected int mRetryTimeHost = 2;
    protected int mTryTimeIp = 2;
    protected Throwable mThrowable;
    protected String testServer;
    protected int lastTryTimes;
    protected CacheIp mCacheIp;
    protected int statusCode;
    protected String reasonPhrase;
    protected String lastRemoteIp;

    protected String getServerAddr() {
        String ret = this.testServer == null || this.testServer.length() == 0 ? this.getUrlService() : this.testServer;
        L.brief("return hiido server %s", ret);
        return ret;
    }

    protected String[] getFallbackIps() {
        return this.testServer == null || this.testServer.length() == 0 ? this.getUrlAddress() : new String[]{};
    }

    @Override
    public void setTestServer(String testServer) {
        this.testServer = testServer;
    }

    @Override
    public boolean sendSync(String content) {
        L.brief("to send content %s", content);
        return this.sendSyncByTrying(content);
    }

    protected boolean sendSyncByTrying(String content) {
        if (this.mCacheIp != null) {
            if (this.mCacheIp.isValid() && this.mCacheIp.getIp() != null && !this.mCacheIp.getIp().isEmpty()) {
                String url = this.asUrl(this.mCacheIp.getIp());
                if (this.sendContent(url, content, 0)) {
                    this.mCacheIp.inc();
                    return true;
                }
                this.mCacheIp.reset(null);
            } else {
                this.mCacheIp.reset(null);
            }
        }
        if (this.sendContent(this.getServerAddr(), content, this.mRetryTimeHost)) {
            return true;
        }
        Object[] ips = this.getFallbackIps();
        if (L.isLogOn() && L.outputDebug()) {
            L.brief("fallback IPs : %s", TextUtils.join((CharSequence)" ", (Object[])ips));
        }
        if (ips == null || ips.length == 0) {
            return false;
        }
        int ipTimes = this.mTryTimeIp;
        int index = 0;
        String url = null;
        while (ipTimes-- > 0) {
            index = new Random().nextInt(ips.length);
            if (ips[index] == null || ((String)ips[index]).isEmpty() || !this.sendContent(url = this.asUrl((String)ips[index]), content, 0)) continue;
            if (this.mCacheIp != null) {
                this.mCacheIp.reset((String)ips[index]);
                this.mCacheIp.inc();
            }
            return true;
        }
        return false;
    }

    protected boolean get(String urlAddr, String content) throws IOException {
        return this.getByUrlConn(urlAddr, content);
    }

    protected boolean post(String urlAddr, String content) throws IOException {
        return this.postByUrlConn(urlAddr, content);
    }

    private boolean getByUrlConn(String urlAddr, String content) throws IOException {
        this.statusCode = -1;
        this.reasonPhrase = null;
        HttpUtil.HttpResp resp = HttpUtil.getByUrlConn(urlAddr, content);
        this.statusCode = resp.statusCode;
        this.reasonPhrase = resp.reason;
        return resp.isSucceed;
    }

    private boolean postByUrlConn(String urlAddr, String content) throws IOException {
        this.statusCode = -1;
        this.reasonPhrase = null;
        HttpUtil.HttpResp resp = HttpUtil.postByUrlConn(urlAddr, content);
        this.statusCode = resp.statusCode;
        this.reasonPhrase = resp.reason;
        this.lastRemoteIp = resp.remoteIp;
        return resp.isSucceed;
    }

    protected String asUrl(String ip) {
        return String.format(this.getUrlFormat(), ip);
    }

    @Override
    public Throwable getLastError() {
        return this.mThrowable;
    }

    @Override
    public int getLastTryTimes() {
        return this.lastTryTimes;
    }

    @Override
    public int getLastStatusCode() {
        return this.statusCode;
    }

    protected abstract boolean sendContent(String var1, String var2, int var3);

    protected abstract String getUrlService();

    protected abstract String getUrlFormat();

    protected abstract String[] getUrlAddress();

    @Override
    public void setLastTryTimes(int lastTryTimes) {
        this.lastTryTimes = lastTryTimes;
    }

    @Override
    public void setCacheIp(CacheIp cacheIp) {
        this.mCacheIp = cacheIp;
    }

    @Override
    public void setRetryTimeHost(int retryTimeHost) {
        this.mRetryTimeHost = retryTimeHost;
    }

    @Override
    public void setTryTimeIp(int tryTimeIp) {
        this.mTryTimeIp = tryTimeIp;
    }
}

