/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiido.autoviewtrack.track;

import com.yy.hiido.autoviewtrack.track.ResourceIds;
import java.util.LinkedList;

public class PathElement {
    public final int hashCode;
    public final String viewIdName;
    public final int index;
    public final int viewId;
    public final String contentDescription;
    public final String tag;
    public final PathElement parent;

    public PathElement(int index, int vId, int hashCode, String viewIdName, String cDesc, String vTag, PathElement parent) {
        this.hashCode = hashCode;
        this.viewIdName = viewIdName;
        this.index = index;
        this.viewId = vId;
        this.contentDescription = cDesc;
        this.tag = vTag;
        this.parent = parent;
    }

    public String toString(ResourceIds resourceIds) {
        try {
            LinkedList<PathElement> paths = new LinkedList<PathElement>();
            PathElement cur = this;
            while (cur != null) {
                paths.add(0, cur);
                cur = cur.parent;
            }
            StringBuilder array = new StringBuilder();
            for (PathElement p : paths) {
                StringBuilder builder = new StringBuilder();
                builder.append(p.index).append("|");
                int c = 0;
                if (p.viewId > -1) {
                    builder.append(resourceIds.nameForId(p.viewId)).append("|");
                    ++c;
                } else {
                    builder.append("|");
                }
                if (null != p.contentDescription) {
                    builder.append(p.contentDescription).append("|");
                    ++c;
                } else {
                    builder.append("|");
                }
                if (null != p.tag) {
                    builder.append(p.tag).append("|");
                    ++c;
                } else {
                    builder.append("|");
                }
                if (c <= 0 && array.length() <= 0) continue;
                if (array.length() > 0) {
                    array.append("#").append(builder.toString());
                    continue;
                }
                array.append(builder.toString());
            }
            return array.toString();
        }
        catch (Throwable throwable) {
            return null;
        }
    }
}

