/*
 * Decompiled with CFR 0.152.
 */
package com.yy.gslbsdk.control;

import android.content.Context;
import com.yy.gslbsdk.cache.DataCacheMgr;
import com.yy.gslbsdk.cache.DataV6CacheMgr;
import com.yy.gslbsdk.cache.ServerIPInfo;
import com.yy.gslbsdk.cache.ServerIPMgr;
import com.yy.gslbsdk.cache.ServerIPV6Mgr;
import com.yy.gslbsdk.control.NetworkStatus;
import com.yy.gslbsdk.db.DBAccessMgr;
import com.yy.gslbsdk.db.ResultTB;
import com.yy.gslbsdk.device.NetStatusInfo;
import com.yy.gslbsdk.protocol.DnsInfo;
import com.yy.gslbsdk.protocol.ResInfo;
import com.yy.gslbsdk.util.GlobalTools;
import com.yy.gslbsdk.util.LogTools;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class IpVersionController {
    public static final String IPV6_BIZ = "ipv6-biz";
    public static final String IPV4_BIZ = "ipv4-biz";
    public static final String IPV4_ONLY = "ipv4-only";
    public static final String IPV6_ONLY = "ipv6-only";
    public static final String IPV4_AND_V6 = "ipv4+v6";
    private static final int NUM_V4_IP = 2;
    private static final int NUM_V6_IP = 1;
    private static IpVersionController sInstance = null;
    private int mCurrIpVer = 0;

    public static IpVersionController getInstance() {
        if (sInstance == null) {
            sInstance = new IpVersionController();
        }
        return sInstance;
    }

    public void setEnableIpv6(boolean enable) {
        NetworkStatus.updateEnableV6(enable);
        DataCacheMgr.INSTANCE.getCachedNetStatusInfo().setNetworkStatus(NetworkStatus.getInstanceClone());
    }

    public void setNetworkStatus(int status) {
        NetworkStatus.updateStatus(status);
        DataCacheMgr.INSTANCE.getCachedNetStatusInfo().setNetworkStatus(NetworkStatus.getInstanceClone());
    }

    public int getCurrIpVer() {
        if (this.mCurrIpVer == 0) {
            this.judgeIpVersion();
        }
        return this.mCurrIpVer;
    }

    public String getCurrIpVerStr() {
        String str = null;
        switch (this.getCurrIpVer()) {
            case 1: {
                str = IPV4_ONLY;
                break;
            }
            case 2: {
                str = IPV6_ONLY;
                break;
            }
            case 3: {
                str = IPV4_AND_V6;
                break;
            }
            default: {
                str = "unknown";
            }
        }
        return str;
    }

    public void judgeIpVersion() {
        List<String> listIp = IpVersionController.getCurrentIp();
        LogTools.printError(String.format("judgeIpVersion listIp: %s", listIp.toString()));
        this.mCurrIpVer = 0;
        block4: for (int i = 0; i < listIp.size(); ++i) {
            String ip = listIp.get(i);
            int ipVer = IpVersionController.tellIpVer(ip);
            switch (ipVer) {
                case 4: {
                    this.mCurrIpVer |= 1;
                    continue block4;
                }
                case 6: {
                    this.mCurrIpVer |= 2;
                    continue block4;
                }
            }
        }
        if (listIp.size() > 0 && this.mCurrIpVer != 0) {
            LogTools.printError(String.format("judgeIpVersion ip version: %s", this.getCurrIpVerStr()));
        }
    }

    public static List<String> getCurrentIp() {
        ArrayList<String> list = new ArrayList<String>();
        try {
            Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
            while (en.hasMoreElements()) {
                NetworkInterface nif = en.nextElement();
                String nameNetCard = nif.getName();
                if (nameNetCard.contains("usb")) continue;
                Enumeration<InetAddress> inet = nif.getInetAddresses();
                while (inet.hasMoreElements()) {
                    boolean add = false;
                    InetAddress ip = inet.nextElement();
                    if (ip.isLoopbackAddress() || ip.isLinkLocalAddress()) continue;
                    if (list.size() < 1) {
                        list.add(nameNetCard);
                        add = true;
                    } else {
                        String name = (String)list.get(0);
                        if (name != null && name.equals(nameNetCard)) {
                            add = true;
                        }
                    }
                    String ipAddr = ip.getHostAddress();
                    if (!add) continue;
                    list.add(ipAddr);
                }
            }
        }
        catch (Exception e) {
            LogTools.printWarning(e);
        }
        return list;
    }

    public ArrayList<String> getBestServerIPCache(NetworkStatus status) {
        LinkedList<ServerIPInfo> list;
        String msg = String.format("getBestServerIPCache NetworkStatus: %s", status.toString());
        LogTools.printDebug(msg);
        ArrayList<String> result = new ArrayList<String>();
        if (status.canV6() && !(list = ServerIPV6Mgr.getInstance().getBestServerIPCache()).isEmpty()) {
            int cnt = status.canV4() ? 1 : 2;
            for (int i = 0; i < list.size() && i < cnt; ++i) {
                String ip = list.get(i).getIp();
                if (ip == null || ip.trim().length() < 1) continue;
                result.add(ip);
            }
        }
        if (status.canV4() && !(list = ServerIPMgr.getInstance().getBestServerIPCache()).isEmpty()) {
            for (int i = 0; i < list.size() && i < 2; ++i) {
                String ip = list.get(i).getIp();
                if (ip == null || ip.trim().length() < 1) continue;
                result.add(ip);
            }
        }
        return result;
    }

    public ArrayList<String> getServerIPByKnownISP(Context context, int isp, NetworkStatus status) {
        ArrayList<String> list;
        ArrayList<String> result = new ArrayList<String>();
        if (status.canV6()) {
            list = ServerIPV6Mgr.getInstance().getServerIPByKnownISP(context, isp);
            result.addAll(list);
        }
        if (status.canV4()) {
            list = ServerIPMgr.getInstance().getServerIPByKnownISP(context, isp);
            result.addAll(list);
        }
        return result;
    }

    public ArrayList<String> getServerIPByUnKnownISP(Context context, NetworkStatus status) {
        ArrayList<String> list;
        ArrayList<String> result = new ArrayList<String>();
        if (status.canV6()) {
            list = ServerIPV6Mgr.getInstance().getServerIPByUnKnownISP(context);
            result.addAll(list);
        }
        if (status.canV4()) {
            list = ServerIPMgr.getInstance().getServerIPByUnKnownISP(context);
            result.addAll(list);
        }
        return result;
    }

    public String getOneServerIPByKnownISP(Context context, int isp, NetworkStatus status) {
        if (status.canV6()) {
            return ServerIPV6Mgr.getInstance().getOneServerIPByKnownISP(context, isp);
        }
        return ServerIPMgr.getInstance().getOneServerIPByKnownISP(context, isp);
    }

    public String getOneServerIPByUnKnownISP(Context context, NetworkStatus status) {
        if (status.canV6()) {
            return ServerIPV6Mgr.getInstance().getOneServerIPByUnKnownISP(context);
        }
        return ServerIPMgr.getInstance().getOneServerIPByUnKnownISP(context);
    }

    public void resetBestServerIPCache(ServerIPInfo ipInfo) {
        if (IpVersionController.tellIpVer(ipInfo.getIp()) == 6) {
            ServerIPV6Mgr.getInstance().resetBestServerIPCache(ipInfo);
        } else {
            ServerIPMgr.getInstance().resetBestServerIPCache(ipInfo);
        }
    }

    public void clearBestServerIPCache() {
        ServerIPV6Mgr.getInstance().clearBestServerIPCache();
        ServerIPMgr.getInstance().clearBestServerIPCache();
    }

    public static int tellIpVer(String ip) {
        if (ip.contains(":")) {
            return 6;
        }
        if (7 <= ip.length() && ip.length() <= 15) {
            boolean isAllDigit = true;
            for (int i = 0; i < ip.length(); ++i) {
                if (ip.charAt(i) == '.' || Character.isDigit(ip.charAt(i))) continue;
                isAllDigit = false;
                break;
            }
            if (isAllDigit) {
                return 4;
            }
        }
        return 0;
    }

    public int delResult(ResultTB result) {
        int ver = IpVersionController.tellIpVer(result.getIp());
        int num = 0;
        if (ver == 6) {
            num = DBAccessMgr.getInstance(GlobalTools.APP_CONTEXT).delResultV6(result);
        } else if (ver == 4) {
            num = DBAccessMgr.getInstance(GlobalTools.APP_CONTEXT).delResult(result);
        } else {
            LogTools.printError(String.format("tell ip version failed! %s", result.getIp()));
        }
        return num;
    }

    public int delResultByHost(String host) {
        int num = 0;
        num += DBAccessMgr.getInstance(GlobalTools.APP_CONTEXT).delResultV6ByHost(host);
        return num += DBAccessMgr.getInstance(GlobalTools.APP_CONTEXT).delResultByHost(host);
    }

    public List<ResultTB> getResultByNetworkHost(String network, String host, NetworkStatus status) {
        List<ResultTB> ret = null;
        if (status.canV6()) {
            ret = DBAccessMgr.getInstance(GlobalTools.APP_CONTEXT).getResultV6ByNetworkHost(network, host);
        }
        if (ret == null || ret.isEmpty()) {
            ret = DBAccessMgr.getInstance(GlobalTools.APP_CONTEXT).getResultByNetworkHost(network, host);
        }
        return ret;
    }

    public void putLocalDNSIntoCache(DnsInfo dnsInfo) {
        String ip = dnsInfo.getIps().get(0);
        int ver = IpVersionController.tellIpVer(ip);
        if (ver == 6) {
            DataV6CacheMgr.INSTANCE.putLocalDNSIntoCache(dnsInfo);
        } else if (ver == 4) {
            DataCacheMgr.INSTANCE.putLocalDNSIntoCache(dnsInfo);
        } else {
            LogTools.printWarning(String.format("tell ip version failed! %s", ip));
        }
    }

    public int getLocalDNSFromCache(String host, DnsInfo dnsInfo) {
        int ret = 2;
        NetworkStatus networkStatus = NetworkStatus.getInstanceClone();
        if (networkStatus.canV6()) {
            ret = DataV6CacheMgr.INSTANCE.getLocalDNSFromCache(host, dnsInfo);
        }
        if (ret != 0 && networkStatus.canV4()) {
            ret = DataCacheMgr.INSTANCE.getLocalDNSFromCache(host, dnsInfo);
        }
        return ret;
    }

    public int getHttpDNSFromCache(Context context, NetStatusInfo network, String host, DnsInfo dnsInfo) {
        NetworkStatus networkStatus = network.getNetworkStatus();
        String msg = String.format("getHttpDNSFromCache getCurrIpVerStr: %s, netId: %s, NetworkStatus: %s", this.getCurrIpVerStr(), network.getNetStatusID(), networkStatus.getStatus());
        LogTools.printDebug(msg);
        DnsInfo dnsInfoV4 = new DnsInfo();
        int retV4 = 2;
        retV4 = DataCacheMgr.INSTANCE.getHttpDNSFromCache(context, network.getNetStatusID(), host, dnsInfoV4);
        DnsInfo dnsInfoV6 = new DnsInfo();
        int retV6 = 2;
        retV6 = DataV6CacheMgr.INSTANCE.getHttpDNSFromCache(context, network.getNetStatusID(), host, dnsInfoV6);
        if (retV6 == 0) {
            dnsInfo.cloneDnsInfo(dnsInfoV6);
            dnsInfo.getIps().addAll(dnsInfoV4.getIps());
        } else if (retV4 == 0) {
            dnsInfo.cloneDnsInfo(dnsInfoV4);
            dnsInfo.getIps().addAll(dnsInfoV6.getIps());
        } else {
            return 2;
        }
        return 0;
    }

    public int putHttpDNSIntoCache(Context context, ResInfo resInfo) {
        int ret = 2;
        LinkedHashMap<String, DnsInfo> listHostDns_v4 = new LinkedHashMap<String, DnsInfo>();
        LinkedHashMap<String, DnsInfo> listHostDns_v6 = new LinkedHashMap<String, DnsInfo>();
        LinkedHashMap<String, DnsInfo> listHostDns = resInfo.getDns();
        for (String host : listHostDns.keySet()) {
            DnsInfo dnsInfo = listHostDns.get(host);
            LinkedList<String> ips = dnsInfo.getIps();
            if (ips.isEmpty()) {
                listHostDns_v4.put(host, dnsInfo);
                listHostDns_v6.put(host, dnsInfo);
                continue;
            }
            for (int i = 0; i < ips.size(); ++i) {
                String ip = ips.get(i);
                int ver = IpVersionController.tellIpVer(ip);
                LinkedHashMap<String, DnsInfo> listTmp = null;
                listTmp = ver == 6 ? listHostDns_v6 : (ver == 4 ? listHostDns_v4 : new LinkedHashMap());
                DnsInfo di = listTmp.get(host);
                if (di == null) {
                    di = new DnsInfo();
                    di.cloneDnsInfo(dnsInfo);
                    di.setIps(new LinkedList<String>());
                    listTmp.put(host, di);
                }
                di.getIps().add(ip);
            }
        }
        ResInfo resInfoV4 = new ResInfo();
        resInfoV4.updateResInfo(resInfo);
        resInfoV4.setDns(listHostDns_v4);
        DataCacheMgr.INSTANCE.putHttpDNSIntoCache(context, resInfoV4);
        ResInfo resInfoV6 = new ResInfo();
        resInfoV6.updateResInfo(resInfo);
        resInfoV6.setDns(listHostDns_v6);
        DataV6CacheMgr.INSTANCE.putHttpDNSIntoCache(context, resInfoV6);
        ret = 0;
        return ret;
    }

    public void deleteHttpDNSFromMemCache(String host) {
        DataV6CacheMgr.INSTANCE.deleteHttpDNSFromMemCache(host);
        DataCacheMgr.INSTANCE.deleteHttpDNSFromMemCache(host);
    }

    public ConcurrentHashMap<String, DnsInfo> getAllLocalDNSFromCache() {
        ConcurrentHashMap<String, DnsInfo> map = null;
        if (NetworkStatus.getInstanceClone().canV6()) {
            map = DataV6CacheMgr.INSTANCE.getAllLocalDNSFromCache();
        }
        if (map == null || map.isEmpty()) {
            map = DataCacheMgr.INSTANCE.getAllLocalDNSFromCache();
        }
        return map;
    }

    public static Map<Integer, List<String>> filterIpVer(List<String> list) {
        LinkedList listV4 = new LinkedList();
        LinkedList<String> listV6 = new LinkedList<String>();
        if (!list.isEmpty()) {
            for (int i = 0; i < list.size(); ++i) {
                String ip = list.get(i);
                int ver = IpVersionController.tellIpVer(ip);
                LinkedList<String> listTmp = null;
                listTmp = ver == 6 ? listV6 : (ver == 4 ? listV4 : new LinkedList());
                listTmp.add(ip);
            }
        }
        HashMap<Integer, List<String>> map = new HashMap<Integer, List<String>>();
        map.put(4, listV4);
        map.put(6, listV6);
        LogTools.printDebug(String.format("filterIpVer listV4 : %s, listV6 : %s, all: %s", ((Object)listV4).toString(), ((Object)listV6).toString(), list.toString()));
        return map;
    }
}

