/*
 * Decompiled with CFR 0.152.
 */
package com.yy.gslbsdk.util;

import android.text.TextUtils;
import android.util.Log;
import com.yy.gslbsdk.GslbEvent;
import com.yy.gslbsdk.util.GlobalTools;

public class LogTools {
    public static final String TAG = GlobalTools.LOG_TAG + "-" + "2.1.9-SNAPSHOT";

    private static void printMsgEvent(String level, String msg) {
        GslbEvent.INSTANCE.onMessage(String.format(" [%s][%s] %s", level, TAG, msg));
    }

    public static void printWarning(Exception e) {
        if (e == null) {
            return;
        }
        if (GlobalTools.LOG_IS_OPEN) {
            Log.w((String)TAG, (String)(TAG + " warning."), (Throwable)e);
        }
        LogTools.printMsgEvent("warn", e.getLocalizedMessage());
    }

    public static void printWarning(String log) {
        if (TextUtils.isEmpty((CharSequence)log)) {
            return;
        }
        if (GlobalTools.LOG_IS_OPEN) {
            Log.w((String)TAG, (String)log);
        }
        LogTools.printMsgEvent("warn", log);
    }

    public static void printError(String log) {
        if (TextUtils.isEmpty((CharSequence)log)) {
            return;
        }
        if (GlobalTools.LOG_IS_OPEN) {
            Log.e((String)TAG, (String)log);
        }
        LogTools.printMsgEvent("error", log);
    }

    public static void printDebug(String log) {
        if (TextUtils.isEmpty((CharSequence)log)) {
            return;
        }
        if (GlobalTools.LOG_IS_OPEN) {
            Log.d((String)TAG, (String)log);
        }
        LogTools.printMsgEvent("debug", log);
    }

    public static void printInfo(String log) {
        if (TextUtils.isEmpty((CharSequence)log)) {
            return;
        }
        if (GlobalTools.LOG_IS_OPEN) {
            Log.i((String)TAG, (String)log);
        }
        LogTools.printMsgEvent("info", log);
    }
}

