/*
 * Decompiled with CFR 0.152.
 */
package com.yy.gslbsdk.cache;

import android.content.Context;
import com.yy.gslbsdk.GslbEvent;
import com.yy.gslbsdk.cache.ServerIPInfo;
import com.yy.gslbsdk.db.DBAccessMgr;
import com.yy.gslbsdk.db.ServerV6TB;
import com.yy.gslbsdk.protocol.UpdateServerInfo;
import com.yy.gslbsdk.protocol.UpdateServerProtocolMgr;
import com.yy.gslbsdk.thread.AsynTaskMgr;
import com.yy.gslbsdk.util.GlobalTools;
import com.yy.gslbsdk.util.LogTools;
import com.yy.gslbsdk.util.RuntimeTools;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class ServerIPV6Mgr {
    public static String curLocalDNSIp = null;
    public List<Integer> mListUsedIsp = null;
    public static final String[] SERVER_IP_CTL = new String[]{"240e:e9:5005:11ff::2", "240e:97d:2014:1ff::3"};
    public static final String[] SERVER_IP_CNC = new String[]{"2408:873d:2012:200:ff::2", "2408:8756:4cff:e5ff::2"};
    public static final String[] SERVER_IP_CMC = new String[]{"240e:e9:5005:11ff::2", "2408:873d:2012:200:ff::2", "240e:97d:2014:1ff::3", "2408:8756:4cff:e5ff::2"};
    public static final String[] SERVER_IP_EDU = new String[0];
    public static final String[] SERVER_IP_PUBLIC = new String[0];
    public static final String[] SERVER_IP_LOCALIZE = new String[]{"240e:e9:5005:11ff::2", "2408:873d:2012:200:ff::2", "240e:97d:2014:1ff::3", "2408:8756:4cff:e5ff::2"};
    private static ServerIPV6Mgr mServerIPMgr = null;
    private LinkedList<ServerIPInfo> mBestServerIpCache = new LinkedList();
    private ConcurrentMap<Integer, ArrayList<ServerV6TB>> mIspServerIpCache = new ConcurrentHashMap<Integer, ArrayList<ServerV6TB>>();

    public static ServerIPV6Mgr getInstance() {
        if (mServerIPMgr == null) {
            mServerIPMgr = new ServerIPV6Mgr();
        }
        return mServerIPMgr;
    }

    public synchronized void resetBestServerIPCache(ServerIPInfo ipInfo) {
        if (ipInfo != null && ipInfo.getIp() != null) {
            int i;
            for (i = 0; i < this.mBestServerIpCache.size(); ++i) {
                if (!this.mBestServerIpCache.get(i).getIp().equals(ipInfo.getIp())) continue;
                this.mBestServerIpCache.remove(i);
                break;
            }
            int num = this.mBestServerIpCache.size();
            for (i = 0; i < num; ++i) {
                if (ipInfo.getScore() >= this.mBestServerIpCache.get(i).getScore()) continue;
                this.mBestServerIpCache.add(i, ipInfo);
                break;
            }
            if (i == num) {
                this.mBestServerIpCache.add(ipInfo);
            }
        }
    }

    public synchronized LinkedList<ServerIPInfo> getBestServerIPCache() {
        return (LinkedList)this.mBestServerIpCache.clone();
    }

    public synchronized void clearBestServerIPCache() {
        this.mBestServerIpCache.clear();
    }

    public void initUsedIsp(String localize) {
        if (this.mListUsedIsp == null) {
            this.mListUsedIsp = new LinkedList<Integer>();
        } else {
            this.mListUsedIsp.clear();
        }
        if ("CN".equalsIgnoreCase(localize)) {
            this.mListUsedIsp.add(1);
            this.mListUsedIsp.add(2);
            this.mListUsedIsp.add(3);
            this.mListUsedIsp.add(4);
            this.mListUsedIsp.add(5);
        } else {
            this.mListUsedIsp.add(6);
            this.mListUsedIsp.add(5);
        }
    }

    public void initServerIP(final Context context, String localize) {
        curLocalDNSIp = RuntimeTools.execCmd(GlobalTools.CMD_GET_LOCALDNS_IP);
        this.initUsedIsp(localize);
        if (this.mIspServerIpCache == null || this.mIspServerIpCache.isEmpty()) {
            DBAccessMgr dbMgr = DBAccessMgr.getInstance(context);
            boolean initFromHardCode = true;
            List<ServerV6TB> serverList = dbMgr.getAllServerV6();
            if (serverList != null && !serverList.isEmpty()) {
                for (int i = 0; i < serverList.size(); ++i) {
                    ServerV6TB stb = serverList.get(i);
                    if (!this.mListUsedIsp.contains(stb.getIsp())) continue;
                    initFromHardCode = false;
                    break;
                }
            }
            if (!initFromHardCode) {
                this.addIspServerIpCache(serverList);
            } else {
                HashMap<Integer, String[]> mapUsedHardCodeServerIp = new HashMap<Integer, String[]>();
                mapUsedHardCodeServerIp.put(5, SERVER_IP_PUBLIC);
                if ("CN".equalsIgnoreCase(GlobalTools.APP_LOCALIZE_CODE)) {
                    mapUsedHardCodeServerIp.put(1, SERVER_IP_CTL);
                    mapUsedHardCodeServerIp.put(2, SERVER_IP_CNC);
                    mapUsedHardCodeServerIp.put(3, SERVER_IP_CMC);
                    mapUsedHardCodeServerIp.put(4, SERVER_IP_EDU);
                } else {
                    mapUsedHardCodeServerIp.put(6, SERVER_IP_LOCALIZE);
                }
                for (int i = 0; i < this.mListUsedIsp.size(); ++i) {
                    int isp = this.mListUsedIsp.get(i);
                    String[] arrServerIp = (String[])mapUsedHardCodeServerIp.get(isp);
                    if (arrServerIp != null && arrServerIp.length > 0) {
                        ArrayList<ServerV6TB> list = new ArrayList<ServerV6TB>(arrServerIp.length);
                        for (String ip : arrServerIp) {
                            ServerV6TB server = new ServerV6TB();
                            server.setIp(ip);
                            server.setIsp(isp);
                            server.setVer(0);
                            list.add(server);
                        }
                        Collections.shuffle(list);
                        this.mIspServerIpCache.putIfAbsent(isp, list);
                        continue;
                    }
                    LogTools.printError(String.format("initServerIP there is no server ip in hard code with isp = %d ", isp));
                }
                AsynTaskMgr.INSTANCE.post(new Runnable(){

                    @Override
                    public void run() {
                        DBAccessMgr dbMgr = DBAccessMgr.getInstance(context);
                        List<ServerV6TB> serverList = dbMgr.getAllServerV6();
                        if (serverList != null && !serverList.isEmpty()) {
                            LogTools.printInfo(String.format("initServerIP db server ip is not empty, size is %d ", serverList.size()));
                            return;
                        }
                        for (int i = 0; i < ServerIPV6Mgr.this.mListUsedIsp.size(); ++i) {
                            int isp = ServerIPV6Mgr.this.mListUsedIsp.get(i);
                            List list = (List)ServerIPV6Mgr.this.mIspServerIpCache.get(isp);
                            if (list == null || list.size() <= 0) continue;
                            for (ServerV6TB serverV6TB : list) {
                                dbMgr.addServerV6(serverV6TB);
                            }
                        }
                    }
                });
            }
        }
        LogTools.printDebug("initServerIP...");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<String> getServerIpListFromCache(int isp) {
        ArrayList<String> result = new ArrayList<String>();
        if (this.mIspServerIpCache.containsKey(isp)) {
            ArrayList listRaw = (ArrayList)this.mIspServerIpCache.get(isp);
            if (listRaw == null || listRaw.isEmpty()) {
                return result;
            }
            ArrayList list = null;
            ArrayList arrayList = listRaw;
            synchronized (arrayList) {
                list = (ArrayList)listRaw.clone();
            }
            for (int i = 0; i < list.size(); ++i) {
                String ip = ((ServerV6TB)list.get(i)).getIp();
                if (ip == null) continue;
                result.add(ip);
            }
        }
        return result;
    }

    private ArrayList<String> getServerIpListFromDb(Context context, int isp) {
        ArrayList<String> result = new ArrayList<String>();
        DBAccessMgr dbMgr = DBAccessMgr.getInstance(context);
        List<ServerV6TB> serverList = dbMgr.getServerV6ByIsp(isp);
        if (serverList != null && !serverList.isEmpty()) {
            for (int i = 0; i < serverList.size(); ++i) {
                String ip = serverList.get(i).getIp();
                if (ip == null) continue;
                result.add(ip);
            }
        }
        return result;
    }

    public ArrayList<String> getServerIPByKnownISP(Context context, int isp) {
        int i;
        ArrayList<String> listPublic;
        ArrayList<String> result = new ArrayList<String>();
        ArrayList<String> listCurr = this.getServerIpListFromCache(isp);
        Collections.shuffle(listCurr);
        if (listCurr.isEmpty()) {
            listCurr = this.getServerIpListFromDb(context, isp);
        }
        if (!listCurr.isEmpty()) {
            for (int i2 = 0; i2 < 2 && i2 < listCurr.size(); ++i2) {
                result.add(listCurr.get(i2));
            }
        }
        if ((listPublic = this.getServerIpListFromCache(5)).isEmpty()) {
            listPublic = this.getServerIpListFromDb(context, 5);
        }
        if (!listPublic.isEmpty()) {
            for (int i3 = 0; i3 < 1 && i3 < listPublic.size(); ++i3) {
                result.add(listPublic.get(i3));
            }
        }
        ArrayList<String> listOther = new ArrayList<String>();
        for (i = 0; i < this.mListUsedIsp.size(); ++i) {
            int ispOther = this.mListUsedIsp.get(i);
            if (isp == ispOther) continue;
            ArrayList<String> listTmp = this.getServerIpListFromCache(ispOther);
            if (listTmp.isEmpty()) {
                listTmp = this.getServerIpListFromDb(context, ispOther);
            }
            if (listTmp.isEmpty()) continue;
            listOther.addAll(listTmp);
        }
        if (!listOther.isEmpty()) {
            Collections.shuffle(listOther);
            result.add((String)listOther.get(0));
        }
        if (result.size() < 3) {
            for (i = 0; i < result.size(); ++i) {
                listCurr.remove(result.get(i));
            }
            for (int j = 0; j < listCurr.size() && result.size() < 3; ++j) {
                result.add(listCurr.get(j));
            }
        }
        return result;
    }

    public ArrayList<String> getServerIPByUnKnownISP(Context context) {
        int numMin;
        ArrayList<String> result = new ArrayList<String>();
        boolean isCN = "CN".equalsIgnoreCase(GlobalTools.APP_LOCALIZE_CODE);
        for (int x = 0; x < this.mListUsedIsp.size(); ++x) {
            int isp = this.mListUsedIsp.get(x);
            ArrayList<String> listServerIp = this.getServerIpListFromCache(isp);
            if (listServerIp.isEmpty()) {
                listServerIp = this.getServerIpListFromDb(context, isp);
            }
            if (listServerIp.isEmpty()) continue;
            if (isCN) {
                Collections.shuffle(listServerIp);
                for (int y = 0; y < 1 && y < listServerIp.size(); ++y) {
                    result.add(listServerIp.get(y));
                }
                continue;
            }
            if (isp == 6) {
                int i;
                for (i = 0; i < 2 && i < listServerIp.size(); ++i) {
                    result.add(listServerIp.get(i));
                }
                for (i = 0; i < result.size(); ++i) {
                    listServerIp.remove(result.get(i));
                }
                if (listServerIp.isEmpty()) continue;
                Collections.shuffle(listServerIp);
                result.add(listServerIp.get(0));
                continue;
            }
            if (isp != 5) continue;
            result.add(listServerIp.get(0));
        }
        ArrayList<Integer> listIsp2AddServerIp = new ArrayList<Integer>();
        if (isCN) {
            numMin = 3;
            listIsp2AddServerIp.add(5);
        } else {
            numMin = 3;
            listIsp2AddServerIp.add(6);
        }
        if (result.size() < numMin) {
            block4: for (int i = 0; i < listIsp2AddServerIp.size(); ++i) {
                int addIsp = (Integer)listIsp2AddServerIp.get(i);
                ArrayList<String> listServerIp = this.getServerIpListFromCache(addIsp);
                if (listServerIp.isEmpty()) {
                    listServerIp = this.getServerIpListFromDb(context, addIsp);
                }
                for (int z = 0; z < listServerIp.size(); ++z) {
                    String serverIp = listServerIp.get(z);
                    if (result.contains(serverIp)) continue;
                    result.add(serverIp);
                    if (result.size() >= numMin) continue block4;
                }
            }
        }
        return result;
    }

    public String getOneServerIPByKnownISP(Context context, int isp) {
        String result = null;
        ArrayList<String> listIp = this.getServerIpListFromCache(isp);
        if (listIp == null || listIp.isEmpty()) {
            listIp = this.getServerIpListFromDb(context, isp);
        }
        if (listIp != null && !listIp.isEmpty()) {
            result = listIp.get(0);
        }
        return result;
    }

    public String getOneServerIPByUnKnownISP(Context context) {
        if (this.mListUsedIsp == null) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        List<Integer> listIsp = this.mListUsedIsp;
        for (int i = 0; i < listIsp.size(); ++i) {
            int isp = listIsp.get(i);
            ArrayList<String> listIp = this.getServerIpListFromCache(isp);
            if (listIp == null || listIp.isEmpty()) {
                listIp = this.getServerIpListFromDb(context, isp);
            }
            if (listIp == null || listIp.isEmpty()) continue;
            result.add(listIp.get(0));
        }
        if (!result.isEmpty()) {
            Collections.shuffle(result);
            return (String)result.get(0);
        }
        return null;
    }

    public boolean canUpdate(Context context, int newVer) {
        DBAccessMgr dbMgr = DBAccessMgr.getInstance(context);
        List<ServerV6TB> serverList = dbMgr.getAllServerV6();
        if (serverList != null && !serverList.isEmpty()) {
            int curVer = serverList.get(0).getVer();
            return newVer > curVer;
        }
        return false;
    }

    public int updateServerIP(Context context, String json) {
        LinkedHashMap<Integer, UpdateServerInfo> mapServerIpNew = new LinkedHashMap<Integer, UpdateServerInfo>();
        int code = UpdateServerProtocolMgr.responseProtocolV6(json, mapServerIpNew);
        if (code != 0) {
            return 7;
        }
        DBAccessMgr dbMgr = DBAccessMgr.getInstance(context);
        List<ServerV6TB> serverList = dbMgr.getAllServerV6();
        if (serverList != null && serverList.size() > 0) {
            ServerV6TB serverV6TB = serverList.get(0);
            Iterator<UpdateServerInfo> iterator = mapServerIpNew.values().iterator();
            if (!iterator.hasNext()) {
                return 7;
            }
            UpdateServerInfo info = iterator.next();
            if (info.getVer() == serverV6TB.getVer()) {
                GslbEvent.INSTANCE.onMessage(String.format("updateServerIP version is same. ver: %d", info.getVer()));
                return 5;
            }
        }
        ArrayList<ServerV6TB> listCacheNew = new ArrayList<ServerV6TB>(mapServerIpNew.size());
        for (int key : mapServerIpNew.keySet()) {
            UpdateServerInfo info = mapServerIpNew.get(key);
            for (String strIP : info.getIps()) {
                ServerV6TB server = new ServerV6TB();
                server.setIp(strIP);
                server.setIsp(info.getIsp());
                server.setVer(info.getVer());
                dbMgr.addServerV6(server);
                listCacheNew.add(server);
            }
        }
        this.mIspServerIpCache.clear();
        this.addIspServerIpCache(listCacheNew);
        dbMgr.delSomeServerV6(serverList);
        this.clearBestServerIPCache();
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addIspServerIpCache(List<ServerV6TB> list) {
        for (int i = 0; i < list.size(); ++i) {
            ServerV6TB server = list.get(i);
            int isp = server.getIsp();
            if (!this.mListUsedIsp.contains(isp)) continue;
            if (this.mIspServerIpCache.containsKey(isp)) {
                ArrayList listOld = (ArrayList)this.mIspServerIpCache.get(isp);
                if (listOld == null || listOld.isEmpty()) continue;
                ArrayList arrayList = listOld;
                synchronized (arrayList) {
                    listOld.add(server);
                    continue;
                }
            }
            ArrayList<ServerV6TB> listNew = new ArrayList<ServerV6TB>();
            listNew.add(server);
            this.mIspServerIpCache.putIfAbsent(isp, listNew);
        }
    }
}

