/*
 * Decompiled with CFR 0.152.
 */
package com.yy.gslbsdk.thread;

import android.os.Bundle;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import com.yy.gslbsdk.cache.DataCacheMgr;
import com.yy.gslbsdk.control.IpVersionController;
import com.yy.gslbsdk.db.DBAccessMgr;
import com.yy.gslbsdk.db.HostTB;
import com.yy.gslbsdk.device.NetStatusInfo;
import com.yy.gslbsdk.flow.DnsResolveFlow;
import com.yy.gslbsdk.flow.QualityDetectFlow;
import com.yy.gslbsdk.protocol.DnsInfo;
import com.yy.gslbsdk.protocol.LocalDNSProtocolMgr;
import com.yy.gslbsdk.util.GlobalTools;
import com.yy.gslbsdk.util.LogTools;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public enum AsynTaskMgr {
    INSTANCE;

    private HandlerThread mHandlerThread = null;
    private Handler mHandler = null;
    private AtomicBoolean mMonitorStarted = new AtomicBoolean(false);
    private static int KTaskUpdateHost;
    private static int KTaskParseLocalDns;

    public synchronized void start() {
        this.mHandlerThread = new HandlerThread("gslb_asyn_task");
        this.mHandlerThread.start();
        this.mHandler = new AsynTaskHandler(this.mHandlerThread.getLooper());
    }

    public synchronized void stop() {
        this.mHandlerThread.quit();
    }

    public void parseLocalDns(String host) {
        Message msg = Message.obtain();
        msg.what = KTaskParseLocalDns;
        Bundle bundle = new Bundle();
        bundle.putString("host", host);
        msg.setData(bundle);
        this.mHandler.sendMessage(msg);
    }

    public void updateHost(ArrayList<String> hostList, boolean isPre) {
        Message msg = Message.obtain();
        msg.what = KTaskUpdateHost;
        Bundle bundle = new Bundle();
        bundle.putStringArrayList("hostList", hostList);
        bundle.putBoolean("isPre", isPre);
        msg.setData(bundle);
        this.mHandler.sendMessage(msg);
    }

    public void startMonitors() {
        this.mHandler.postDelayed(new Runnable(){

            @Override
            public void run() {
                if (AsynTaskMgr.this.mMonitorStarted.compareAndSet(false, true)) {
                    DnsResolveFlow.getInstance().beginNetworkMonitor();
                    DnsResolveFlow.getInstance().beginTTLMonitor();
                    QualityDetectFlow.getInstance().beginQualityMonitor();
                    QualityDetectFlow.getInstance().beginHijackMonitor();
                }
            }
        }, (long)GlobalTools.MONITOR_DELAY);
    }

    public void stopMonitors() {
        if (this.mMonitorStarted.compareAndSet(true, false)) {
            DnsResolveFlow.getInstance().stopNetworkMonitor();
            QualityDetectFlow.getInstance().stopAllMonitor();
        }
    }

    public void postDelayed(Runnable r, long delayMillis) {
        this.mHandler.removeCallbacks(r);
        this.mHandler.postDelayed(r, delayMillis);
    }

    public void post(Runnable r) {
        this.mHandler.post(r);
    }

    private void doParseLocalDns(Bundle bundle) {
        String host = bundle.getString("host");
        if (host == null || host.length() == 0) {
            return;
        }
        long timeBegin = System.currentTimeMillis();
        DnsInfo dnsInfo = LocalDNSProtocolMgr.requestProtocol(host);
        if (dnsInfo != null) {
            NetStatusInfo network = DataCacheMgr.INSTANCE.getCachedNetStatusInfo();
            dnsInfo.setNt(network.getNetType());
            DnsInfo cacheDnsInfo = new DnsInfo();
            int code = IpVersionController.getInstance().getHttpDNSFromCache(GlobalTools.APP_CONTEXT, network, host, cacheDnsInfo);
            if (code == 0) {
                dnsInfo.setUip(cacheDnsInfo.getUip());
            }
            IpVersionController.getInstance().putLocalDNSIntoCache(dnsInfo);
        } else {
            LogTools.printError("local parse error");
        }
        LogTools.printInfo("parse local dns, timespent = " + (System.currentTimeMillis() - timeBegin) + ", host = " + host);
    }

    private void doUpdateHost(Bundle bundle) {
        if (bundle != null) {
            ArrayList hostList = bundle.getStringArrayList("hostList");
            boolean isPre = bundle.getBoolean("isPre");
            if (hostList != null && GlobalTools.APP_CONTEXT != null) {
                long insertTime = System.currentTimeMillis();
                DBAccessMgr dbMgr = DBAccessMgr.getInstance(GlobalTools.APP_CONTEXT);
                for (String loop : hostList) {
                    HostTB host;
                    List<HostTB> hosts = dbMgr.getHostByHost(loop);
                    if (hosts.isEmpty()) {
                        host = new HostTB();
                        host.setHost(loop);
                        host.setInsertTime(insertTime);
                        host.setIsPre(isPre ? 1 : 0);
                        dbMgr.addHost(host);
                        continue;
                    }
                    host = hosts.get(0);
                    host.setInsertTime(insertTime);
                    if (host.getIsPre() == 0) {
                        host.setIsPre(isPre ? 1 : 0);
                    }
                    dbMgr.updateHost(host);
                }
                List<HostTB> curList = dbMgr.getAllHost();
                int allCnt = curList.size();
                if (allCnt > GlobalTools.KEEP_HOST_NUM) {
                    for (int i = allCnt - 1; i > 0; --i) {
                        if (curList.get(i).getIsPre() == 1) continue;
                        LogTools.printInfo("remove host " + curList.get(i).getHost());
                        dbMgr.delHost(curList.get(i));
                        if (--allCnt <= GlobalTools.KEEP_HOST_NUM) break;
                    }
                }
                curList.clear();
            }
        }
    }

    static {
        KTaskUpdateHost = 1;
        KTaskParseLocalDns = 2;
    }

    private static class AsynTaskHandler
    extends Handler {
        public AsynTaskHandler(Looper l) {
            super(l);
        }

        public void handleMessage(Message msg) {
            super.handleMessage(msg);
            if (msg.what == KTaskUpdateHost) {
                INSTANCE.doUpdateHost(msg.getData());
            } else if (msg.what == KTaskParseLocalDns) {
                INSTANCE.doParseLocalDns(msg.getData());
            }
        }
    }
}

