/*
 * Decompiled with CFR 0.152.
 */
package com.yy.gslbsdk.util;

import android.annotation.SuppressLint;
import com.yy.gslbsdk.util.LogTools;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

@SuppressLint(value={"SimpleDateFormat"})
public class FormatTools {
    public static SimpleDateFormat full_date_time_format1 = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
    public static SimpleDateFormat full_date_time_format2 = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5 HH\u65f6mm\u5206ss\u79d2");
    public static SimpleDateFormat full_date_time_format3 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    public static SimpleDateFormat full_date_format1 = new SimpleDateFormat("yyyy/MM/dd");
    public static SimpleDateFormat full_date_format2 = new SimpleDateFormat("yyyy-MM-dd");
    public static SimpleDateFormat full_time_format = new SimpleDateFormat("HH:mm:ss");
    public static SimpleDateFormat time_hour_minute_format = new SimpleDateFormat("HH:mm");
    public static SimpleDateFormat year_format = new SimpleDateFormat("yyyy");
    public static DecimalFormat two_decimal = new DecimalFormat("0.00");

    public static String getDayBeginFromOne(SimpleDateFormat sdf, String oneday, int day) {
        try {
            Calendar calendar = Calendar.getInstance();
            if (oneday == null) {
                calendar.setTime(new Date());
            } else {
                calendar.setTime(sdf.parse(oneday));
            }
            calendar.add(5, day);
            return sdf.format(calendar.getTime());
        }
        catch (Exception e) {
            LogTools.printWarning(e);
            return null;
        }
    }

    public static Date getSecondBeginFromOne(SimpleDateFormat sdf, String oneTime, int second) {
        try {
            Calendar calendar = Calendar.getInstance();
            if (oneTime == null) {
                calendar.setTime(new Date());
            } else {
                calendar.setTime(sdf.parse(oneTime));
            }
            calendar.add(13, second);
            return calendar.getTime();
        }
        catch (Exception e) {
            LogTools.printWarning(e);
            return null;
        }
    }

    public static long getDateTimestamp(SimpleDateFormat sdf, String date) {
        try {
            if (date == null) {
                return new Date().getTime();
            }
            return sdf.parse(date).getTime();
        }
        catch (ParseException e) {
            LogTools.printWarning(e);
            return 0L;
        }
    }

    public static String getDateStr(SimpleDateFormat sdf, long timestamp) {
        try {
            return sdf.format(new Date(timestamp));
        }
        catch (Exception e) {
            LogTools.printWarning(e);
            return null;
        }
    }

    public static int daysOfTwo(String date1, String date2) {
        try {
            Calendar aCalendar = Calendar.getInstance();
            SimpleDateFormat data_time_format3 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            aCalendar.setTime(data_time_format3.parse(date1 + " 00:00:00"));
            int day1 = aCalendar.get(6);
            aCalendar.setTime(data_time_format3.parse(date2 + " 00:00:00"));
            int day2 = aCalendar.get(6);
            return day2 - day1;
        }
        catch (Exception e) {
            return 0;
        }
    }

    public static boolean containInList(List<?> targetList, Object obj) {
        for (Object loop : targetList) {
            if (!loop.equals(obj)) continue;
            return true;
        }
        return false;
    }
}

