/*
 * Decompiled with CFR 0.152.
 */
package com.yy.gslbsdk.cache;

import com.yy.gslbsdk.cache.DataCacheMgr;
import com.yy.gslbsdk.network.HTTPMgr;
import com.yy.gslbsdk.thread.ThreadInfo;
import com.yy.gslbsdk.thread.ThreadPoolMgr;
import com.yy.gslbsdk.util.GlobalTools;
import com.yy.gslbsdk.util.LogTools;
import java.util.HashMap;
import org.json.JSONObject;

public class HttpsLevelMgr {
    private static HttpsLevelMgr sInstance = null;

    public static HttpsLevelMgr getInstance() {
        if (sInstance == null) {
            sInstance = new HttpsLevelMgr();
        }
        return sInstance;
    }

    public void setHttpsLevel(int level) {
        if (0 > level || level > 2) {
            return;
        }
        if (level <= GlobalTools.HTTPS_LEVEL) {
            return;
        }
        GlobalTools.HTTPS_LEVEL = level;
    }

    public int update() {
        ThreadInfo task = new ThreadInfo("HttpsLevelUpdate");
        task.setThreadMainOper(new ThreadInfo.ThreadMainOper(){

            @Override
            public void handleOper(String name) {
                String[] result = HttpsLevelMgr.this.request();
                if (result == null) {
                    return;
                }
                int code = HttpsLevelMgr.this.response(result[1]);
            }
        });
        ThreadPoolMgr.getInstance().addTask(task);
        return 0;
    }

    private String[] request() {
        String appId = GlobalTools.ACCOUNT_ID == null ? "" : GlobalTools.ACCOUNT_ID;
        String devId = GlobalTools.APP_DEV_ID == null ? "" : GlobalTools.APP_DEV_ID;
        String userCfg = GlobalTools.APP_LOCALIZE_CODE == null ? "" : GlobalTools.APP_LOCALIZE_CODE;
        String gslbId = DataCacheMgr.INSTANCE.getIdentity(GlobalTools.APP_CONTEXT);
        HashMap<String, String> header_param = new HashMap<String, String>();
        header_param.put("host", GlobalTools.HTTPDNS_SERVER_HOST);
        header_param.put("p", "a");
        header_param.put("devid", devId);
        header_param.put("gslbid", gslbId);
        header_param.put("appid", appId);
        header_param.put("version", "2.1.9-SNAPSHOT");
        String url = "https://" + GlobalTools.HTTPDNS_SERVER_HOST + "/https_level?appid=" + appId + "&usercfg=" + userCfg;
        return HTTPMgr.postSniHttps(url, GlobalTools.HTTPDNS_SERVER_HOST, null, header_param);
    }

    private int response(String json) {
        if (json == null || json.length() < 1) {
            return 5;
        }
        try {
            JSONObject root = new JSONObject(json);
            int s = root.optInt("s");
            if (s != 0) {
                return 3;
            }
            int httpsLevel = root.getInt("level");
            if (httpsLevel < 0 || 2 < httpsLevel) {
                return 3;
            }
            this.setHttpsLevel(httpsLevel);
            return 0;
        }
        catch (Exception e) {
            LogTools.printWarning(e);
            return 3;
        }
    }
}

