/*
 * Decompiled with CFR 0.152.
 */
package com.yy.gslbsdk.protocol;

import com.yy.gslbsdk.cache.DataCacheMgr;
import com.yy.gslbsdk.control.IpVersionController;
import com.yy.gslbsdk.network.HTTPMgr;
import com.yy.gslbsdk.protocol.CmdInfo;
import com.yy.gslbsdk.protocol.DnsInfo;
import com.yy.gslbsdk.protocol.HttpDnsInfo;
import com.yy.gslbsdk.protocol.ResInfo;
import com.yy.gslbsdk.util.GlobalTools;
import com.yy.gslbsdk.util.LogTools;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import org.json.JSONArray;
import org.json.JSONObject;

public class HttpDNSProtocolMgr {
    public static String udpRequestProtocolV2(String[] host, long seqId, boolean total) {
        String result = null;
        if (host != null && host.length > 0) {
            try {
                JSONObject result_json = new JSONObject();
                result_json.put("seq_id", seqId);
                result_json.put("version", (Object)"v2");
                JSONArray array = new JSONArray();
                for (String item : host) {
                    array.put((Object)item);
                }
                result_json.put("dns_name", (Object)array);
                if (total) {
                    result_json.put("res_count", -1);
                }
                result = result_json.toString();
            }
            catch (Exception e) {
                LogTools.printError("udpRequestProtocolV2: " + e.getMessage());
            }
        }
        return result;
    }

    public static String getRequestUrlProtocolV2(String[] host, String serverIP, boolean total) {
        String url = "http://" + serverIP + "/dns_query_v3?";
        for (int i = 0; i < host.length; ++i) {
            url = url + "dns=" + host[i];
            if (i == host.length - 1) continue;
            url = url + "&";
        }
        if (total) {
            url = url + "&rescount=-1";
        }
        return url;
    }

    public static String[] requestHttpDnsV2(String[] host, String serverIP, boolean total) {
        return HttpDNSProtocolMgr.requestHttpDnsV2(host, serverIP, total, false, "");
    }

    public static String[] requestHttpDnsV2(String[] host, String serverIP, boolean total, boolean https, String requestId) {
        StringBuilder sb = new StringBuilder();
        int len = host.length;
        sb.append("dns=");
        for (int i = 0; i < len; ++i) {
            sb.append(host[i]);
            if (i >= len - 1) continue;
            sb.append(',');
        }
        String dnsString = sb.toString();
        String gslbId = DataCacheMgr.INSTANCE.getIdentity(GlobalTools.APP_CONTEXT);
        HashMap<String, String> header_param = new HashMap<String, String>();
        header_param.put("host", GlobalTools.HTTPDNS_SERVER_HOST);
        header_param.put("p", "a");
        header_param.put("devid", GlobalTools.APP_DEV_ID);
        header_param.put("gslbid", gslbId);
        header_param.put("appid", GlobalTools.ACCOUNT_ID);
        header_param.put("version", "2.1.6-SNAPSHOT");
        LogTools.printInfo(String.format("Post Params, dns = %s, gslbid = %s, devid = %s", dnsString, gslbId, GlobalTools.APP_DEV_ID));
        String code = GlobalTools.APP_LOCALIZE_CODE;
        if (code == null || code.trim().length() < 1) {
            code = "";
        }
        if (IpVersionController.tellIpVer(serverIP) == 6) {
            serverIP = "[" + serverIP + "]";
        }
        if (https) {
            String url = "https://" + serverIP + "/dns_query_v3?usercfg=" + code + "&requestId=" + requestId;
            if (total) {
                url = url + "&rescount=-1";
            }
            return HTTPMgr.postSniHttps(url, GlobalTools.HTTPDNS_SERVER_HOST, sb.toString(), header_param);
        }
        String url = "http://" + serverIP + "/dns_query_v3?usercfg=" + code + "&requestId=" + requestId;
        if (total) {
            url = url + "&rescount=-1";
        }
        return HTTPMgr.postHttp(url, sb.toString(), header_param);
    }

    public static int responseProtocolV2(String json, ResInfo resInfo, int source) {
        try {
            if (json == null || resInfo == null) {
                resInfo.setStatus(5);
                return 5;
            }
            JSONObject objResult = new JSONObject(json);
            resInfo.setStatus(HttpDNSProtocolMgr.translateErrCode(objResult.getInt("s")));
            resInfo.setUserIp(objResult.getString("u"));
            resInfo.setUserView(objResult.getString("v"));
            LinkedHashMap<String, DnsInfo> dns = new LinkedHashMap<String, DnsInfo>();
            JSONArray objDns = objResult.getJSONArray("dns");
            for (int i = 0; i < objDns.length(); ++i) {
                JSONObject objItem = objDns.getJSONObject(i);
                DnsInfo host = new DnsInfo();
                host.setView(objResult.getString("v"));
                host.setUip(objResult.getString("u"));
                host.setHost(objItem.getString("name"));
                int ttl = Math.max(objItem.getInt("ttl"), GlobalTools.sMinSecondTTL);
                host.setTtl(ttl);
                LinkedList<String> ips = new LinkedList<String>();
                if (!objItem.isNull("ips")) {
                    JSONArray objIps = objItem.getJSONArray("ips");
                    for (int j = 0; j < objIps.length(); ++j) {
                        ips.add(objIps.getString(j));
                    }
                    host.setIps(ips);
                }
                CmdInfo cmd = new CmdInfo();
                JSONObject objCmd = objItem.getJSONObject("cmd");
                cmd.setPe(objCmd.getBoolean("pe"));
                cmd.setRe(objCmd.getBoolean("re"));
                host.setCmd(cmd);
                if (resInfo.getNetInfo() != null) {
                    host.setNt(resInfo.getNetInfo().getNetType());
                }
                host.setSource(source);
                dns.put(host.getHost(), host);
            }
            resInfo.setDns(dns);
            JSONObject objHttpDns = objResult.getJSONObject("httpdns");
            HttpDnsInfo httpDnsInfo = new HttpDnsInfo();
            httpDnsInfo.setVer(objHttpDns.getInt("ver"));
            httpDnsInfo.setRe(objHttpDns.getBoolean("re"));
            resInfo.setHttpdns(httpDnsInfo);
            JSONArray arrRefresh = objResult.optJSONArray("rd");
            for (int i = 0; i < arrRefresh.length(); ++i) {
                JSONObject objRd = arrRefresh.optJSONObject(i);
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("dm", objRd.optString("dm", ""));
                map.put("ut", objRd.optString("ut", "0"));
                resInfo.addRefresh(map);
            }
            return 0;
        }
        catch (Exception e) {
            LogTools.printError("responseProtocolV2: " + e.getMessage());
            resInfo.setStatus(3);
            return 3;
        }
    }

    private static int translateErrCode(int status) {
        switch (status) {
            case 0: {
                return 0;
            }
            case 1: {
                return 4;
            }
            case 2002: {
                return 6;
            }
            case 1002: {
                return 5;
            }
            case 4: {
                return 7;
            }
        }
        return 8;
    }
}

