/*
 * Decompiled with CFR 0.152.
 */
package com.yy.gslbsdk.cache;

import android.content.Context;
import android.content.SharedPreferences;
import android.preference.PreferenceManager;
import android.text.TextUtils;
import com.yy.gslbsdk.DnsResultInfo;
import com.yy.gslbsdk.cache.DataCacheMgr;
import com.yy.gslbsdk.control.IpVersionController;
import com.yy.gslbsdk.device.NetStatusInfo;
import com.yy.gslbsdk.util.GlobalTools;
import com.yy.gslbsdk.util.LogTools;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ExternalCache {
    private static ExternalCache sInstance = null;
    public static final int SCENE_FIRST_INSTALL_START = 1;
    public static final int SCENE_SYNC_NO_RESULT = 2;
    public static final int SCENE_ASYNC_NO_RESULT = 4;
    public static final int SCENE_ASYNC_CACHE_OVERTIME = 8;
    private Map<String, Map<String, List<String>>> mDataAsset = null;
    private Map<String, Map<String, List<String>>> mDataExternal = null;
    private boolean mEnable = false;
    private NetType mNetType = NetType.GSLB_INNER;
    private int mScene = -1;
    private boolean mFirstStart = true;

    private ExternalCache() {
        SharedPreferences preference = PreferenceManager.getDefaultSharedPreferences((Context)GlobalTools.APP_CONTEXT);
        this.mFirstStart = preference.getBoolean("gslb_first_install", true);
        if (this.mFirstStart) {
            preference.edit().putBoolean("gslb_first_install", false).apply();
        }
    }

    public static final ExternalCache getInstance() {
        if (sInstance == null) {
            sInstance = new ExternalCache();
        }
        return sInstance;
    }

    public boolean isFirstStart() {
        return this.mFirstStart;
    }

    public void setEnable(boolean enable) {
        this.mEnable = enable;
    }

    public void setNetType(NetType netType) {
        this.mNetType = netType;
    }

    public void setScene(int scene) {
        this.mScene = scene;
    }

    public void setData(Map<String, Map<String, List<String>>> data) {
        this.mDataExternal = data;
    }

    private boolean matchScene(int currScene) {
        if (this.mFirstStart) {
            currScene |= 1;
        }
        return (this.mScene & currScene) > 0;
    }

    private boolean isWifi() {
        NetStatusInfo netInfo;
        if (this.mNetType == NetType.WIFI) {
            return true;
        }
        return this.mNetType == NetType.GSLB_INNER && (netInfo = DataCacheMgr.INSTANCE.getCachedNetStatusInfo()) != null && netInfo.getNetType() == 2;
    }

    private NetType getNetType() {
        NetStatusInfo netInfo;
        if (this.mNetType == NetType.WIFI) {
            return NetType.WIFI;
        }
        if (this.mNetType == NetType.GSLB_INNER && (netInfo = DataCacheMgr.INSTANCE.getCachedNetStatusInfo()) != null) {
            NetType netType = this.transNum2NetType(netInfo.getIsp());
            return netType;
        }
        return this.mNetType;
    }

    public void getResult(String host, int currScene, DnsResultInfo resultInfo) {
        try {
            Map<String, List<String>> result = this.getResult(host, currScene);
            if (result == null) {
                return;
            }
            resultInfo.mErrorCode = 0;
            resultInfo.mDataSource = 5;
            resultInfo.mIps = result.get("all").toArray(new String[0]);
            resultInfo.mIpsV4 = result.get("4").toArray(new String[0]);
            resultInfo.mIpsV6 = result.get("6").toArray(new String[0]);
        }
        catch (Exception e) {
            LogTools.printWarning(e);
        }
    }

    public Map<String, List<String>> getResult(String host, int currScene) {
        List<String> list;
        if (!this.mEnable) {
            return null;
        }
        if (this.mDataExternal == null && this.mDataAsset == null) {
            return null;
        }
        if (!this.matchScene(currScene)) {
            return null;
        }
        LinkedList<String> listIp = new LinkedList<String>();
        if (this.mDataExternal != null && this.mDataExternal.containsKey(host) && !this.isWifi()) {
            list = this.getIp(this.mDataExternal, host);
            listIp.addAll(list);
        }
        if (this.mDataAsset != null && this.mDataAsset.containsKey(host)) {
            list = this.getIp(this.mDataAsset, host);
            listIp.addAll(list);
        }
        if (listIp.isEmpty()) {
            return null;
        }
        LinkedList<String> listV4 = new LinkedList<String>();
        LinkedList<String> listV6 = new LinkedList<String>();
        for (int i = 0; i < listIp.size(); ++i) {
            String ip = (String)listIp.get(i);
            int ver = IpVersionController.tellIpVer(ip);
            if (ver == 4) {
                listV4.add(ip);
                continue;
            }
            if (ver != 6) continue;
            listV6.add(ip);
        }
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        map.put("all", listIp);
        map.put("4", listV4);
        map.put("6", listV6);
        return map;
    }

    private NetType transNum2NetType(int type) {
        if (NetType.MOBILE_CTL.getValue() == type) {
            return NetType.MOBILE_CTL;
        }
        if (NetType.MOBILE_CNC.getValue() == type) {
            return NetType.MOBILE_CNC;
        }
        if (NetType.MOBILE_CMC.getValue() == type) {
            return NetType.MOBILE_CMC;
        }
        if (NetType.WIFI.getValue() == type) {
            return NetType.WIFI;
        }
        return NetType.GSLB_INNER;
    }

    private List<String> getIp(Map<String, Map<String, List<String>>> data, String host) {
        List<String> list;
        LinkedList<String> listIp = new LinkedList<String>();
        Map<String, List<String>> mapDns = data.get(host);
        if (mapDns == null) {
            return listIp;
        }
        if ("CN".equalsIgnoreCase(GlobalTools.APP_LOCALIZE_CODE)) {
            NetType netType = this.getNetType();
            if (netType == NetType.WIFI) {
                List<String> list2 = this.getIpCNWifi(mapDns);
                listIp.addAll(list2);
            } else {
                List<String> list3 = this.getIpCNMobile(mapDns, netType);
                listIp.addAll(list3);
            }
        }
        if (GlobalTools.APP_LOCALIZE_CODE.length() > 0 && (list = mapDns.get(GlobalTools.APP_LOCALIZE_CODE.toUpperCase())) != null && !list.isEmpty()) {
            listIp.addAll(list);
        }
        return listIp;
    }

    private List<String> getIpCNMobile(Map<String, List<String>> mapDns, NetType netType) {
        LinkedList<String> listIp = new LinkedList<String>();
        List<String> list = mapDns.get(String.valueOf(netType.getValue()));
        if (list != null && !list.isEmpty()) {
            listIp.addAll(list);
        } else {
            list = mapDns.get(netType.getName());
            if (list != null && !list.isEmpty()) {
                listIp.addAll(list);
            }
        }
        return listIp;
    }

    private List<String> getIpCNWifi(Map<String, List<String>> mapDns) {
        LinkedList<String> listIp = new LinkedList<String>();
        List<String> list = this.getIpCNMobile(mapDns, NetType.MOBILE_CTL);
        if (!list.isEmpty()) {
            listIp.addAll(list);
        }
        if (!(list = this.getIpCNMobile(mapDns, NetType.MOBILE_CNC)).isEmpty()) {
            listIp.addAll(list);
        }
        if (!(list = this.getIpCNMobile(mapDns, NetType.MOBILE_CMC)).isEmpty()) {
            listIp.addAll(list);
        }
        return listIp;
    }

    private Map<String, Map<String, List<String>>> parseJson(String strJson) {
        HashMap<String, Map<String, List<String>>> map = new HashMap<String, Map<String, List<String>>>();
        try {
            JSONObject root = new JSONObject(strJson);
            Iterator itHost = root.keys();
            while (itHost.hasNext()) {
                String host = (String)itHost.next();
                JSONObject objDns = root.optJSONObject(host);
                Iterator itDns = objDns.keys();
                while (itDns.hasNext()) {
                    String op = (String)itDns.next();
                    if (TextUtils.isEmpty((CharSequence)op)) continue;
                    JSONArray arrIp = objDns.optJSONArray(op);
                    ArrayList<String> list = new ArrayList<String>(arrIp.length());
                    for (int i = 0; i < arrIp.length(); ++i) {
                        list.add(arrIp.getString(i));
                    }
                    HashMap mapDns = (HashMap)map.get(host);
                    if (mapDns == null) {
                        mapDns = new HashMap();
                        map.put(host, mapDns);
                    }
                    Collections.shuffle(list);
                    mapDns.put(op.toUpperCase(), list);
                }
            }
        }
        catch (JSONException e) {
            LogTools.printWarning((Exception)((Object)e));
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readAssets(Context context, String name) {
        StringBuffer sb = new StringBuffer();
        BufferedReader reader = null;
        try {
            InputStream is = context.getAssets().open(name);
            reader = new BufferedReader(new InputStreamReader(is));
            String line = null;
            while ((line = reader.readLine()) != null) {
                sb.append(line);
            }
        }
        catch (IOException e) {
            LogTools.printWarning(e);
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (Exception e) {
                LogTools.printWarning(e);
            }
        }
        return sb.toString();
    }

    public boolean loadFromAssets(Context context, String name) {
        String strJson = ExternalCache.readAssets(context, name);
        this.mDataAsset = this.parseJson(strJson);
        return true;
    }

    public Map<String, Map<String, List<String>>> testLoadAssetsJson(String strJson, boolean firstStart) {
        this.mDataAsset = this.parseJson(strJson);
        this.mFirstStart = firstStart;
        return this.mDataAsset;
    }

    public static enum NetType {
        WIFI("WIFI", 100),
        MOBILE_CTL("CTL", 1),
        MOBILE_CNC("CNC", 2),
        MOBILE_CMC("CMC", 3),
        GSLB_INNER("gslb", 0);

        private String name = "gslb";
        private int value = 0;

        private NetType(String name, int value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public int getValue() {
            return this.value;
        }
    }
}

