/*
 * Decompiled with CFR 0.152.
 */
package com.yy.gslbsdk.protocol;

import com.yy.gslbsdk.cache.DataCacheMgr;
import com.yy.gslbsdk.control.IpVersionController;
import com.yy.gslbsdk.network.HTTPMgr;
import com.yy.gslbsdk.protocol.UpdateServerInfo;
import com.yy.gslbsdk.util.GlobalTools;
import com.yy.gslbsdk.util.LogTools;
import java.util.HashMap;
import java.util.LinkedHashMap;
import org.json.JSONArray;
import org.json.JSONObject;

public class UpdateServerProtocolMgr {
    public static String[] requestProtocol(String serverIP, boolean https) {
        String code = GlobalTools.APP_LOCALIZE_CODE;
        if (code == null || code.trim().length() < 1) {
            code = "";
        }
        if (IpVersionController.tellIpVer(serverIP) == 6) {
            serverIP = "[" + serverIP + "]";
        }
        String url = serverIP + "/srv_query_v2?usercfg=" + code;
        HashMap<String, String> header_param = new HashMap<String, String>();
        header_param.put("host", GlobalTools.HTTPDNS_SERVER_HOST);
        header_param.put("p", "a");
        header_param.put("devid", GlobalTools.APP_DEV_ID);
        header_param.put("gslbid", DataCacheMgr.INSTANCE.getIdentity(GlobalTools.APP_CONTEXT));
        header_param.put("appid", GlobalTools.ACCOUNT_ID);
        header_param.put("version", "2.1.6-SNAPSHOT");
        if (https) {
            return HTTPMgr.getHttps("https://" + url, GlobalTools.HTTPDNS_SERVER_HOST, header_param);
        }
        return HTTPMgr.getHttp("http://" + url, header_param);
    }

    public static int responseProtocol(String json, LinkedHashMap<Integer, UpdateServerInfo> listServerInfo) {
        try {
            if (json == null || listServerInfo == null) {
                return 5;
            }
            JSONObject result_json = new JSONObject(json);
            int status = UpdateServerProtocolMgr.translateErrCode(result_json.getInt("s"));
            int ver = result_json.getInt("ver");
            JSONArray dns_json = result_json.getJSONArray("dns");
            for (int i = 0; i < dns_json.length(); ++i) {
                JSONObject dns_item = dns_json.getJSONObject(i);
                int isp = dns_item.getInt("v");
                if (!listServerInfo.containsKey(isp)) {
                    UpdateServerInfo info = new UpdateServerInfo();
                    info.setVer(ver);
                    info.setIsp(isp);
                    listServerInfo.put(isp, info);
                }
                listServerInfo.get(isp).getIps().add(dns_item.getString("ip"));
            }
            return status;
        }
        catch (Exception e) {
            LogTools.printError("UpdateServerProtocolMgr.responseProtocol: " + e.getMessage());
            return 3;
        }
    }

    public static int responseProtocolV6(String json, LinkedHashMap<Integer, UpdateServerInfo> listServerInfo) {
        try {
            if (json == null || listServerInfo == null) {
                return 5;
            }
            JSONObject result_json = new JSONObject(json);
            int status = UpdateServerProtocolMgr.translateErrCode(result_json.getInt("s"));
            int ver = result_json.getInt("ver");
            JSONArray dns_json = result_json.getJSONArray("dns_v6");
            for (int i = 0; i < dns_json.length(); ++i) {
                JSONObject dns_item = dns_json.getJSONObject(i);
                int isp = dns_item.getInt("v");
                if (!listServerInfo.containsKey(isp)) {
                    UpdateServerInfo info = new UpdateServerInfo();
                    info.setVer(ver);
                    info.setIsp(isp);
                    listServerInfo.put(isp, info);
                }
                listServerInfo.get(isp).getIps().add(dns_item.getString("ip"));
            }
            return status;
        }
        catch (Exception e) {
            LogTools.printError("UpdateServerProtocolMgr.responseProtocol: " + e.getMessage());
            return 3;
        }
    }

    private static int translateErrCode(int status) {
        switch (status) {
            case 0: {
                return 0;
            }
            case 1: {
                return 4;
            }
            case 2: {
                return 6;
            }
            case 3: {
                return 5;
            }
            case 4: {
                return 7;
            }
        }
        return 8;
    }
}

