/*
 * Decompiled with CFR 0.152.
 */
package com.yy.gslbsdk.protocol;

import com.yy.gslbsdk.cache.DataCacheMgr;
import com.yy.gslbsdk.protocol.HijackInfo;
import com.yy.gslbsdk.protocol.ReportInfo;
import com.yy.gslbsdk.protocol.StatsInfo;
import com.yy.gslbsdk.util.GlobalTools;
import com.yy.gslbsdk.util.LogTools;
import java.util.HashMap;
import java.util.LinkedList;
import org.json.JSONArray;
import org.json.JSONObject;

public class ReportProtocolMgr {
    public static String reportProtocol(ReportInfo reportInfo) {
        String result = null;
        try {
            JSONObject objIts;
            JSONArray arrIts;
            JSONObject objStats;
            HashMap<String, StatsInfo> statsList;
            JSONArray arrStats;
            JSONObject jsonResult = new JSONObject();
            jsonResult.put("appid", (Object)GlobalTools.ACCOUNT_ID);
            jsonResult.put("h", (Object)reportInfo.getHost());
            jsonResult.put("ni", (Object)reportInfo.getView());
            jsonResult.put("nt", reportInfo.getNetInfo().getNetType());
            jsonResult.put("isp", reportInfo.getNetInfo().getIsp());
            jsonResult.put("plat", (Object)"andr");
            jsonResult.put("gid", (Object)DataCacheMgr.INSTANCE.getIdentity(GlobalTools.APP_CONTEXT));
            jsonResult.put("v", (Object)"2.1.6-SNAPSHOT");
            jsonResult.put("timestamp", System.currentTimeMillis());
            if (reportInfo.getStats0() != null) {
                jsonResult.put("fc", reportInfo.getFc());
                jsonResult.put("lc", reportInfo.getLc());
                arrStats = new JSONArray();
                StatsInfo info = reportInfo.getStats0();
                JSONObject objStats2 = new JSONObject();
                objStats2.put("sip", (Object)info.getSip());
                JSONArray jSONArray = new JSONArray();
                for (long[] its : info.getIts()) {
                    JSONObject objIts2 = new JSONObject();
                    objIts2.put("avg", its[0]);
                    objIts2.put("cnt", its[1]);
                    jSONArray.put((Object)objIts2);
                }
                objStats2.put("its", (Object)jSONArray);
                arrStats.put((Object)objStats2);
                jsonResult.put("stats0", (Object)arrStats);
            }
            if (reportInfo.getStats1() != null) {
                arrStats = new JSONArray();
                statsList = reportInfo.getStats1();
                for (StatsInfo statsInfo : statsList.values()) {
                    objStats = new JSONObject();
                    objStats.put("sip", (Object)statsInfo.getSip());
                    arrIts = new JSONArray();
                    for (long[] its : statsInfo.getIts()) {
                        objIts = new JSONObject();
                        objIts.put("avg", its[0]);
                        objIts.put("cnt", its[1]);
                        arrIts.put((Object)objIts);
                    }
                    objStats.put("its", (Object)arrIts);
                    arrStats.put((Object)objStats);
                }
                jsonResult.put("stats1", (Object)arrStats);
            }
            if (reportInfo.getStats15() != null) {
                arrStats = new JSONArray();
                statsList = reportInfo.getStats15();
                for (StatsInfo statsInfo : statsList.values()) {
                    objStats = new JSONObject();
                    objStats.put("sip", (Object)statsInfo.getSip());
                    arrIts = new JSONArray();
                    for (long[] its : statsInfo.getIts()) {
                        objIts = new JSONObject();
                        objIts.put("avg", its[0]);
                        objIts.put("cnt", its[1]);
                        arrIts.put((Object)objIts);
                    }
                    objStats.put("its", (Object)arrIts);
                    arrStats.put((Object)objStats);
                }
                jsonResult.put("stats15", (Object)arrStats);
            }
            if (reportInfo.getCt() != -1) {
                jsonResult.put("ct", reportInfo.getCt());
            }
            if (reportInfo.getTt() != -1) {
                jsonResult.put("tt", reportInfo.getTt());
            }
            if (reportInfo.getHijack() != null) {
                JSONArray arrHijack = new JSONArray();
                LinkedList<HijackInfo> hijackList = reportInfo.getHijack();
                for (HijackInfo hijackInfo : hijackList) {
                    JSONObject objHijack = new JSONObject();
                    objHijack.put("uip", (Object)(hijackInfo.getUip() == null ? "" : hijackInfo.getUip()));
                    objHijack.put("dnsip", (Object)hijackInfo.getDnsip());
                    objHijack.put("hip", (Object)hijackInfo.getHip());
                    arrHijack.put((Object)objHijack);
                }
                jsonResult.put("hijack", (Object)arrHijack);
            }
            result = jsonResult.toString();
        }
        catch (Exception e) {
            LogTools.printError("reportProtocol: " + e.getMessage());
        }
        return result;
    }
}

