/*
 * Decompiled with CFR 0.152.
 */
package com.yy.gslbsdk.control;

import android.text.TextUtils;
import com.yy.gslbsdk.cache.DataCacheMgr;
import com.yy.gslbsdk.db.ResultTB;
import com.yy.gslbsdk.device.NetStatusInfo;
import com.yy.gslbsdk.flow.DnsResolveFlow;
import com.yy.gslbsdk.protocol.ResInfo;
import com.yy.gslbsdk.thread.ThreadInfo;
import com.yy.gslbsdk.thread.ThreadPoolMgr;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ActiveRefreshController {
    private static ActiveRefreshController sInstance = null;

    public static synchronized ActiveRefreshController getInstance() {
        if (sInstance == null) {
            sInstance = new ActiveRefreshController();
        }
        return sInstance;
    }

    public static void refreshHostCache(ResInfo resInfo) {
        if (resInfo == null) {
            return;
        }
        final NetStatusInfo network = DataCacheMgr.INSTANCE.getCachedNetStatusInfo();
        final ArrayList<String> listHost = new ArrayList<String>();
        List<Map<String, String>> listRefresh = resInfo.getListRefresh();
        if (listRefresh == null || listRefresh.isEmpty()) {
            return;
        }
        for (int i = 0; i < listRefresh.size(); ++i) {
            ResultTB cache;
            long lut;
            String ut;
            String dm;
            Map<String, String> mapRefresh = listRefresh.get(i);
            if (mapRefresh == null || mapRefresh.isEmpty() || TextUtils.isEmpty((CharSequence)(dm = mapRefresh.get("dm"))) || TextUtils.isEmpty((CharSequence)(ut = mapRefresh.get("ut"))) || !TextUtils.isDigitsOnly((CharSequence)ut) || (lut = Long.getLong(ut).longValue()) < 1L || (cache = DataCacheMgr.INSTANCE.getHttpDNSFromMemCache(network.getNetStatusID(), dm)) == null || cache.getUpdateTime() >= lut) continue;
            listHost.add(dm);
        }
        if (listHost.isEmpty()) {
            return;
        }
        ThreadInfo task = new ThreadInfo("Refresh-" + network + "-" + ((Object)listHost).toString());
        task.setThreadMainOper(new ThreadInfo.ThreadMainOper(){

            @Override
            public void handleOper(String name) {
                DnsResolveFlow.getInstance().handleDnsSync(listHost.toArray(new String[0]), "", network);
            }
        });
        ThreadPoolMgr.getInstance().addTask(task);
    }
}

