/*
 * Decompiled with CFR 0.152.
 */
package com.yy.gslbsdk;

import android.content.Context;
import com.yy.gslbsdk.DnsResultInfo;
import com.yy.gslbsdk.GslbEvent;
import com.yy.gslbsdk.cache.DataCacheMgr;
import com.yy.gslbsdk.cache.ExternalCache;
import com.yy.gslbsdk.cache.HttpsLevelMgr;
import com.yy.gslbsdk.cache.ServerIPMgr;
import com.yy.gslbsdk.cache.ServerIPV6Mgr;
import com.yy.gslbsdk.control.IpVersionController;
import com.yy.gslbsdk.flow.DnsResolveFlow;
import com.yy.gslbsdk.flow.QualityDetectFlow;
import com.yy.gslbsdk.statistic.StatisticMgr;
import com.yy.gslbsdk.thread.AsynTaskMgr;
import com.yy.gslbsdk.thread.ThreadPoolMgr;
import com.yy.gslbsdk.util.GlobalTools;
import com.yy.gslbsdk.util.IPTools;
import com.yy.gslbsdk.util.LogTools;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

public class HttpDnsService {
    private static HttpDnsService mHttpDnsService = null;
    private DegradationFilter mDegradationFilter = null;
    private AtomicBoolean mInit = new AtomicBoolean(false);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        AtomicBoolean atomicBoolean = this.mInit;
        synchronized (atomicBoolean) {
            if (this.mInit.get()) {
                return;
            }
            IpVersionController.getInstance().judgeIpVersion();
            ServerIPMgr.getInstance().initServerIP(GlobalTools.APP_CONTEXT, GlobalTools.APP_LOCALIZE_CODE);
            ServerIPV6Mgr.getInstance().initServerIP(GlobalTools.APP_CONTEXT, GlobalTools.APP_LOCALIZE_CODE);
            ServerIPMgr.getInstance().updateServerIpByLocalDns(GlobalTools.APP_CONTEXT);
            AsynTaskMgr.INSTANCE.startMonitors();
            this.mInit.set(true);
        }
    }

    public static synchronized HttpDnsService getService(Context ctx, String appId, ThreadPoolMgr.ITaskExecutor executor, String devId) {
        return HttpDnsService.getService(ctx, appId, executor, devId, "CN");
    }

    @Deprecated
    public static synchronized HttpDnsService getService(Context ctx, String appId, ThreadPoolMgr.ITaskExecutor executor, String devId, String localize) {
        if (mHttpDnsService == null) {
            if (ctx == null) {
                throw new IllegalArgumentException("Context is null");
            }
            GlobalTools.APP_CONTEXT = ctx.getApplicationContext();
            GlobalTools.ACCOUNT_ID = appId == null ? "" : appId;
            GlobalTools.APP_DEV_ID = devId == null ? "" : devId;
            GlobalTools.APP_LOCALIZE_CODE = "CN";
            mHttpDnsService = new HttpDnsService();
            ThreadPoolMgr.getInstance().create(executor);
            AsynTaskMgr.INSTANCE.start();
            HttpsLevelMgr.getInstance().update();
        }
        return mHttpDnsService;
    }

    public static synchronized HttpDnsService getService() {
        return mHttpDnsService;
    }

    public static synchronized void destroyService() {
        ThreadPoolMgr.getInstance().stop(200L);
        AsynTaskMgr.INSTANCE.stopMonitors();
        AsynTaskMgr.INSTANCE.stop();
        mHttpDnsService = null;
    }

    public void setPreResolveHosts(ArrayList<String> hostList) {
        DnsResolveFlow.getInstance().updateHostList(hostList, true);
    }

    public DnsResultInfo getIpsByHost(String host) {
        return this.getIpsByHost(host, false);
    }

    @Deprecated
    public DnsResultInfo getIpsByHost(String host, int requestId) {
        return this.getIpsByHost(host);
    }

    public DnsResultInfo getIpsByHost(String host, boolean forceRefresh) {
        return this.getIpsByHost(host, forceRefresh, true);
    }

    public DnsResultInfo getIpsByHost(String host, boolean forceRefresh, boolean enableLocalDns) {
        this.init();
        if (!IPTools.isHost(host)) {
            return new DnsResultInfo();
        }
        boolean degradation = false;
        if (this.mDegradationFilter != null) {
            degradation = this.mDegradationFilter.shouldDegradeHttpDNS(host);
        }
        return DnsResolveFlow.getInstance().handleDNS(host, degradation, false, false, forceRefresh, enableLocalDns);
    }

    public DnsResultInfo getIpsByHostAsync(String host) {
        return this.getIpsByHostAsync(host, false);
    }

    public DnsResultInfo getIpsByHostAsync(String host, boolean expiredIPEnabled) {
        return this.getIpsByHostAsync(host, expiredIPEnabled, true);
    }

    public DnsResultInfo getIpsByHostAsync(String host, boolean expiredIPEnabled, boolean enableLocalDns) {
        this.init();
        if (!IPTools.isHost(host)) {
            return new DnsResultInfo();
        }
        boolean degradation = false;
        if (this.mDegradationFilter != null) {
            degradation = this.mDegradationFilter.shouldDegradeHttpDNS(host);
        }
        return DnsResolveFlow.getInstance().handleDNS(host, degradation, true, expiredIPEnabled, false, enableLocalDns);
    }

    @Deprecated
    public void setPreResolveAfterNetworkChanged(boolean enable) {
        GlobalTools.REFRESH_AFTER_NETWORK_CHANGE = enable;
    }

    public void setDectorHost(String host, int protocol, int method, String url) {
        QualityDetectFlow.getInstance().updateDectorList(host, protocol, method, url);
    }

    public void setReport(String host, String ip, long delay_ms) {
        if (QualityDetectFlow.getInstance().canReport(host)) {
            QualityDetectFlow.getInstance().addReportData(host, ip, delay_ms);
        }
    }

    public void setLogEnabled(boolean shouldPrintLog) {
        GlobalTools.LOG_IS_OPEN = shouldPrintLog;
    }

    public String getSdkVersion() {
        return "2.1.6-SNAPSHOT";
    }

    public void setDegradationFilter(DegradationFilter filter) {
        this.mDegradationFilter = filter;
    }

    public DegradationFilter getDegradationFilter() {
        return this.mDegradationFilter;
    }

    public void setBackgroundModel(boolean isBackground) {
        GlobalTools.IS_BACKGOUND_MODEL = isBackground;
    }

    public void setHttpsEnable(boolean enable) {
        if (enable) {
            this.setHttpsEnable(1);
        } else {
            this.setHttpsEnable(0);
        }
    }

    public void setHttpsEnable(int level) {
        HttpsLevelMgr.getInstance().setHttpsLevel(level);
    }

    public void setGslbEventMessager(GslbEvent.GslbEventListener listener) {
        GslbEvent.INSTANCE.setListener(listener);
    }

    public String getGslbID() {
        return DataCacheMgr.INSTANCE.getIdentity(GlobalTools.APP_CONTEXT);
    }

    public void setMinTTL(int second) {
        if (second < 180) {
            return;
        }
        GlobalTools.sMinSecondTTL = second;
    }

    public void setGslbStatistic(StatisticMgr.IGslbStatistic callback) {
        StatisticMgr.getInstance().setStatistic(callback);
    }

    public void setCacheMaxExpired(int second) {
        GlobalTools.TTL_HOST_ALIVE_SECOND = Math.max(GlobalTools.TTL_HOST_ALIVE_SECOND, second);
    }

    @Deprecated
    public void cancelRequest(String host, int requestId) {
        LogTools.printDebug("This interface is Deprecated.");
    }

    @Deprecated
    public int getNextRequestId() {
        LogTools.printDebug("This interface is Deprecated.");
        return -1;
    }

    public void setEnableIpv6(boolean enable) {
        IpVersionController.getInstance().setEnableIpv6(enable);
    }

    @Deprecated
    public void setNetworkSupportV6(boolean support) {
        int status = support ? 3 : 1;
        IpVersionController.getInstance().setNetworkStatus(status);
    }

    public void setNetworkStatus(int status) {
        IpVersionController.getInstance().setNetworkStatus(status);
    }

    public void setExternalIpData(Map<String, Map<String, List<String>>> data, int scene) {
        ExternalCache.getInstance().setData(data);
        ExternalCache.getInstance().setScene(scene);
    }

    public void setExternalIpData(Map<String, Map<String, List<String>>> data) {
        ExternalCache.getInstance().setData(data);
    }

    public void setExternalIpEnable(boolean enable) {
        ExternalCache.getInstance().setEnable(enable);
    }

    public void setExternalIpScene(int scene) {
        ExternalCache.getInstance().setScene(scene);
    }

    public void setExternalIpNetType(ExternalCache.NetType netType) {
        ExternalCache.getInstance().setNetType(netType);
    }

    public void loadAssetsIp(String name) {
        ExternalCache.getInstance().loadFromAssets(GlobalTools.APP_CONTEXT, name);
    }

    public static interface DegradationFilter {
        public boolean shouldDegradeHttpDNS(String var1);
    }
}

