/*
 * Decompiled with CFR 0.152.
 */
package com.yy.gslbsdk.control;

import android.content.Context;
import com.yy.gslbsdk.GslbEvent;
import com.yy.gslbsdk.cache.DataCacheMgr;
import com.yy.gslbsdk.cache.DataV6CacheMgr;
import com.yy.gslbsdk.cache.ServerIPInfo;
import com.yy.gslbsdk.cache.ServerIPMgr;
import com.yy.gslbsdk.cache.ServerIPV6Mgr;
import com.yy.gslbsdk.db.DBAccessMgr;
import com.yy.gslbsdk.db.ResultTB;
import com.yy.gslbsdk.device.NetStatusInfo;
import com.yy.gslbsdk.protocol.DnsInfo;
import com.yy.gslbsdk.protocol.ResInfo;
import com.yy.gslbsdk.util.GlobalTools;
import com.yy.gslbsdk.util.LogTools;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

public class IpVersionController {
    public static final String IPV6_BIZ = "ipv6-biz";
    public static final String IPV4_BIZ = "ipv4-biz";
    public static final String IPV4_ONLY = "ipv4-only";
    public static final String IPV6_ONLY = "ipv6-only";
    public static final String IPV4_AND_V6 = "ipv4+v6";
    private static IpVersionController sInstance = null;
    private static final int IP_V4 = 1;
    private static final int IP_V6 = 2;
    public static final int STATUS_IP_V_NONE = 0;
    public static final int STATUS_IP_V4_ONLY = 1;
    public static final int STATUS_IP_V6_ONLY = 2;
    public static final int STATUS_IP_V4_AND_V6 = 3;
    private boolean sIpv6Switch = true;
    private boolean sSupportIpv6 = false;
    private int mCurrIpVer = 0;

    public static IpVersionController getInstance() {
        if (sInstance == null) {
            sInstance = new IpVersionController();
        }
        return sInstance;
    }

    public void setEnableIpv6(boolean enable) {
        this.sIpv6Switch = enable;
        DataCacheMgr.INSTANCE.getCachedNetStatusInfo().setCanV6(this.isNetworkStatusV6());
    }

    public void setNetworkSupportV6(boolean support) {
        this.sSupportIpv6 = support;
        DataCacheMgr.INSTANCE.getCachedNetStatusInfo().setCanV6(this.isNetworkStatusV6());
    }

    public boolean canV6() {
        return this.sIpv6Switch && this.sSupportIpv6;
    }

    public boolean canV4() {
        boolean enable = true;
        return enable;
    }

    public int getCurrIpVer() {
        if (this.mCurrIpVer == 0) {
            this.judgeIpVersion();
        }
        return this.mCurrIpVer;
    }

    public String getCurrIpVerStr() {
        String str = null;
        switch (this.getCurrIpVer()) {
            case 1: {
                str = IPV4_ONLY;
                break;
            }
            case 2: {
                str = IPV6_ONLY;
                break;
            }
            case 3: {
                str = IPV4_AND_V6;
                break;
            }
            default: {
                str = "unknown";
            }
        }
        return str;
    }

    public String getNetworkStatus() {
        String str = this.sIpv6Switch && this.sSupportIpv6 ? IPV6_BIZ : IPV4_BIZ;
        return str;
    }

    public boolean isNetworkStatusV6() {
        return this.sIpv6Switch && this.sSupportIpv6;
    }

    public void judgeIpVersion() {
        List<String> listIp = IpVersionController.getCurrentIp();
        LogTools.printError(String.format("judgeIpVersion listIp: %s", listIp.toString()));
        GslbEvent.INSTANCE.onMessage(String.format("judgeIpVersion listIp: %s", listIp.toString()));
        this.mCurrIpVer = 0;
        block4: for (int i = 0; i < listIp.size(); ++i) {
            String ip = listIp.get(i);
            int ipVer = IpVersionController.tellIpVer(ip);
            switch (ipVer) {
                case 4: {
                    this.mCurrIpVer |= 1;
                    continue block4;
                }
                case 6: {
                    this.mCurrIpVer |= 2;
                    continue block4;
                }
            }
        }
        if (listIp.size() > 0 && this.mCurrIpVer != 0) {
            LogTools.printError(String.format("judgeIpVersion ip version: %s", this.getCurrIpVerStr()));
            GslbEvent.INSTANCE.onMessage(String.format("judgeIpVersion ip version: %s", this.getCurrIpVerStr()));
        }
    }

    public static List<String> getCurrentIp() {
        ArrayList<String> list = new ArrayList<String>();
        try {
            Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
            while (en.hasMoreElements()) {
                NetworkInterface nif = en.nextElement();
                String nameNetCard = nif.getName();
                if (nameNetCard.contains("usb")) continue;
                Enumeration<InetAddress> inet = nif.getInetAddresses();
                while (inet.hasMoreElements()) {
                    boolean add = false;
                    InetAddress ip = inet.nextElement();
                    if (ip.isLoopbackAddress() || ip.isLinkLocalAddress()) continue;
                    if (list.size() < 1) {
                        list.add(nameNetCard);
                        add = true;
                    } else {
                        String name = (String)list.get(0);
                        if (name != null && name.equals(nameNetCard)) {
                            add = true;
                        }
                    }
                    String ipAddr = ip.getHostAddress();
                    if (!add) continue;
                    list.add(ipAddr);
                }
            }
        }
        catch (Exception e) {
            LogTools.printWarning(e);
        }
        return list;
    }

    public LinkedList<ServerIPInfo> getBestServerIPCache(boolean canV6) {
        if (canV6) {
            return ServerIPV6Mgr.getInstance().getBestServerIPCache();
        }
        return ServerIPMgr.getInstance().getBestServerIPCache();
    }

    public ArrayList<String> getServerIPByKnownISP(Context context, int isp, boolean canV6) {
        if (canV6) {
            return ServerIPV6Mgr.getInstance().getServerIPByKnownISP(context, isp);
        }
        return ServerIPMgr.getInstance().getServerIPByKnownISP(context, isp);
    }

    public ArrayList<String> getServerIPByUnKnownISP(Context context, boolean canV6) {
        if (canV6) {
            return ServerIPV6Mgr.getInstance().getServerIPByUnKnownISP(context);
        }
        return ServerIPMgr.getInstance().getServerIPByUnKnownISP(context);
    }

    public String getOneServerIPByKnownISP(Context context, int isp, boolean canV6) {
        if (canV6) {
            return ServerIPV6Mgr.getInstance().getOneServerIPByKnownISP(context, isp);
        }
        return ServerIPMgr.getInstance().getOneServerIPByKnownISP(context, isp);
    }

    public String getOneServerIPByUnKnownISP(Context context, boolean canV6) {
        if (canV6) {
            return ServerIPV6Mgr.getInstance().getOneServerIPByUnKnownISP(context);
        }
        return ServerIPMgr.getInstance().getOneServerIPByUnKnownISP(context);
    }

    public void resetBestServerIPCache(ServerIPInfo ipInfo) {
        if (IpVersionController.tellIpVer(ipInfo.getIp()) == 6) {
            ServerIPV6Mgr.getInstance().resetBestServerIPCache(ipInfo);
        } else {
            ServerIPMgr.getInstance().resetBestServerIPCache(ipInfo);
        }
    }

    public void clearBestServerIPCache() {
        ServerIPV6Mgr.getInstance().clearBestServerIPCache();
        ServerIPMgr.getInstance().clearBestServerIPCache();
    }

    public static int tellIpVer(String ip) {
        if (ip.contains(":")) {
            return 6;
        }
        if (7 <= ip.length() && ip.length() <= 15) {
            boolean isAllDigit = true;
            for (int i = 0; i < ip.length(); ++i) {
                if (ip.charAt(i) == '.' || Character.isDigit(ip.charAt(i))) continue;
                isAllDigit = false;
                break;
            }
            if (isAllDigit) {
                return 4;
            }
        }
        return 0;
    }

    public int delResult(ResultTB result) {
        int ver = IpVersionController.tellIpVer(result.getIp());
        int num = 0;
        if (ver == 6) {
            num = DBAccessMgr.getInstance(GlobalTools.APP_CONTEXT).delResultV6(result);
        } else if (ver == 4) {
            num = DBAccessMgr.getInstance(GlobalTools.APP_CONTEXT).delResult(result);
        } else {
            LogTools.printError(String.format("tell ip version failed! %s", result.getIp()));
        }
        return num;
    }

    public int delResultByHost(String host) {
        int num = 0;
        num += DBAccessMgr.getInstance(GlobalTools.APP_CONTEXT).delResultV6ByHost(host);
        return num += DBAccessMgr.getInstance(GlobalTools.APP_CONTEXT).delResultByHost(host);
    }

    public List<ResultTB> getResultByNetworkHost(String network, String host, boolean isV6) {
        List<ResultTB> ret = null;
        ret = isV6 ? DBAccessMgr.getInstance(GlobalTools.APP_CONTEXT).getResultV6ByNetworkHost(network, host) : DBAccessMgr.getInstance(GlobalTools.APP_CONTEXT).getResultByNetworkHost(network, host);
        return ret;
    }

    public void putLocalDNSIntoCache(DnsInfo dnsInfo) {
        String ip = dnsInfo.getIps().get(0);
        int ver = IpVersionController.tellIpVer(ip);
        if (ver == 6) {
            DataV6CacheMgr.INSTANCE.putLocalDNSIntoCache(dnsInfo);
        } else if (ver == 4) {
            DataCacheMgr.INSTANCE.putLocalDNSIntoCache(dnsInfo);
        } else {
            LogTools.printWarning(String.format("tell ip version failed! %s", ip));
        }
    }

    public int getLocalDNSFromCache(String host, DnsInfo dnsInfo) {
        int ret = 2;
        if (this.canV6()) {
            ret = DataV6CacheMgr.INSTANCE.getLocalDNSFromCache(host, dnsInfo);
        }
        if (ret != 0 && this.canV4()) {
            ret = DataCacheMgr.INSTANCE.getLocalDNSFromCache(host, dnsInfo);
        }
        return ret;
    }

    public int getHttpDNSFromCache(Context context, NetStatusInfo network, String host, DnsInfo dnsInfo) {
        String msg = String.format("getHttpDNSFromCache getCurrIpVerStr: %s, getNetworkStatus: %s", this.getCurrIpVerStr(), this.getNetworkStatus());
        GslbEvent.INSTANCE.onMessage(msg);
        LogTools.printDebug(msg);
        int ret = 2;
        if (this.canV6()) {
            ret = DataV6CacheMgr.INSTANCE.getHttpDNSFromCache(context, network.getNetStatusID(), host, dnsInfo);
        }
        if (ret != 0 && this.canV4() && (ret = DataCacheMgr.INSTANCE.getHttpDNSFromCache(context, network.getNetStatusID(), host, dnsInfo)) == 0 && network.canV6() && dnsInfo.getSource() != 6) {
            ret = 2;
        }
        return ret;
    }

    public int putHttpDNSIntoCache(Context context, ResInfo resInfo) {
        int ret = 2;
        LinkedHashMap<String, DnsInfo> listHostDns_v4 = new LinkedHashMap<String, DnsInfo>();
        LinkedHashMap<String, DnsInfo> listHostDns_v6 = new LinkedHashMap<String, DnsInfo>();
        LinkedHashMap<String, DnsInfo> listHostDns = resInfo.getDns();
        for (String host : listHostDns.keySet()) {
            DnsInfo dnsInfo = listHostDns.get(host);
            LinkedList<String> ips = dnsInfo.getIps();
            if (ips.isEmpty()) {
                listHostDns_v4.put(host, dnsInfo);
                listHostDns_v6.put(host, dnsInfo);
                continue;
            }
            for (int i = 0; i < ips.size(); ++i) {
                String ip = ips.get(i);
                int ver = IpVersionController.tellIpVer(ip);
                LinkedHashMap<String, DnsInfo> listTmp = null;
                listTmp = ver == 6 ? listHostDns_v6 : (ver == 4 ? listHostDns_v4 : new LinkedHashMap());
                DnsInfo di = listTmp.get(host);
                if (di == null) {
                    di = new DnsInfo();
                    di.cloneDnsInfo(dnsInfo);
                    di.setIps(new LinkedList<String>());
                    listTmp.put(host, di);
                }
                di.getIps().add(ip);
            }
        }
        ResInfo resInfoV4 = new ResInfo();
        resInfoV4.cloneResInfo(resInfo);
        resInfoV4.setDns(listHostDns_v4);
        DataCacheMgr.INSTANCE.putHttpDNSIntoCache(context, resInfoV4);
        ResInfo resInfoV6 = new ResInfo();
        resInfoV6.cloneResInfo(resInfo);
        resInfoV6.setDns(listHostDns_v6);
        DataV6CacheMgr.INSTANCE.putHttpDNSIntoCache(context, resInfoV6);
        ret = 0;
        return ret;
    }

    public void deleteHttpDNSFromMemCache(String host) {
        DataV6CacheMgr.INSTANCE.deleteHttpDNSFromMemCache(host);
        DataCacheMgr.INSTANCE.deleteHttpDNSFromMemCache(host);
    }

    public ConcurrentHashMap<String, DnsInfo> getAllLocalDNSFromCache() {
        ConcurrentHashMap<String, DnsInfo> map = null;
        if (this.canV6()) {
            map = DataV6CacheMgr.INSTANCE.getAllLocalDNSFromCache();
        }
        if (map == null || map.isEmpty()) {
            map = DataCacheMgr.INSTANCE.getAllLocalDNSFromCache();
        }
        return map;
    }
}

